/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.AbstractDNSToSwitchMapping;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.StaticMapping;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestStaticMapping
extends Assertions {
    private static final Logger LOG = LoggerFactory.getLogger(TestStaticMapping.class);

    private StaticMapping newInstance() {
        StaticMapping.resetMap();
        return new StaticMapping();
    }

    private StaticMapping newInstance(String script) {
        StaticMapping mapping = this.newInstance();
        mapping.setConf(this.createConf(script));
        return mapping;
    }

    private Configuration createConf(String script) {
        Configuration conf = new Configuration();
        if (script != null) {
            conf.set("net.topology.script.file.name", script);
        } else {
            conf.unset("net.topology.script.file.name");
        }
        return conf;
    }

    private void assertSingleSwitch(DNSToSwitchMapping mapping) {
        TestStaticMapping.assertEquals((Object)true, (Object)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping), (String)("Expected a single switch mapping " + mapping));
    }

    private void assertMultiSwitch(DNSToSwitchMapping mapping) {
        TestStaticMapping.assertEquals((Object)false, (Object)AbstractDNSToSwitchMapping.isMappingSingleSwitch((DNSToSwitchMapping)mapping), (String)("Expected a multi switch mapping " + mapping));
    }

    protected void assertMapSize(AbstractDNSToSwitchMapping switchMapping, int expectedSize) {
        TestStaticMapping.assertEquals((int)expectedSize, (int)switchMapping.getSwitchMap().size(), (String)("Expected two entries in the map " + switchMapping.dumpTopology()));
    }

    private List<String> createQueryList() {
        ArrayList<String> l1 = new ArrayList<String>(2);
        l1.add("n1");
        l1.add("unknown");
        return l1;
    }

    @Test
    public void testStaticIsSingleSwitchOnNullScript() throws Throwable {
        StaticMapping mapping = this.newInstance(null);
        mapping.setConf(this.createConf(null));
        this.assertSingleSwitch((DNSToSwitchMapping)mapping);
    }

    @Test
    public void testStaticIsMultiSwitchOnScript() throws Throwable {
        StaticMapping mapping = this.newInstance("ls");
        this.assertMultiSwitch((DNSToSwitchMapping)mapping);
    }

    @Test
    public void testAddResolveNodes() throws Throwable {
        StaticMapping mapping = this.newInstance();
        StaticMapping.addNodeToRack("n1", "/r1");
        List<String> queryList = this.createQueryList();
        List<String> resolved = mapping.resolve(queryList);
        TestStaticMapping.assertEquals((int)2, (int)resolved.size());
        TestStaticMapping.assertEquals((Object)"/r1", (Object)resolved.get(0));
        TestStaticMapping.assertEquals((Object)"/default-rack", (Object)resolved.get(1));
        Map<String, String> switchMap = mapping.getSwitchMap();
        String topology = mapping.dumpTopology();
        LOG.info(topology);
        TestStaticMapping.assertEquals((int)1, (int)switchMap.size(), (String)topology);
        TestStaticMapping.assertEquals((Object)"/r1", (Object)switchMap.get("n1"), (String)topology);
    }

    @Test
    public void testReadNodesFromConfig() throws Throwable {
        StaticMapping mapping = this.newInstance();
        Configuration conf = new Configuration();
        conf.set("hadoop.configured.node.mapping", "n1=/r1,n2=/r2");
        mapping.setConf(conf);
        this.assertSingleSwitch((DNSToSwitchMapping)mapping);
        ArrayList<String> l1 = new ArrayList<String>(3);
        l1.add("n1");
        l1.add("unknown");
        l1.add("n2");
        List<String> resolved = mapping.resolve(l1);
        TestStaticMapping.assertEquals((int)3, (int)resolved.size());
        TestStaticMapping.assertEquals((Object)"/r1", (Object)resolved.get(0));
        TestStaticMapping.assertEquals((Object)"/default-rack", (Object)resolved.get(1));
        TestStaticMapping.assertEquals((Object)"/r2", (Object)resolved.get(2));
        Map<String, String> switchMap = mapping.getSwitchMap();
        String topology = mapping.dumpTopology();
        LOG.info(topology);
        TestStaticMapping.assertEquals((int)2, (int)switchMap.size(), (String)topology);
        TestStaticMapping.assertEquals((Object)"/r1", (Object)switchMap.get("n1"), (String)topology);
        TestStaticMapping.assertNull((Object)switchMap.get("unknown"), (String)topology);
    }

    @Test
    public void testCachingRelaysSingleSwitchQueries() throws Throwable {
        StaticMapping staticMapping = this.newInstance(null);
        this.assertSingleSwitch((DNSToSwitchMapping)staticMapping);
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        LOG.info("Mapping: " + cachedMap + "\n" + cachedMap.dumpTopology());
        this.assertSingleSwitch((DNSToSwitchMapping)cachedMap);
    }

    @Test
    public void testCachingRelaysMultiSwitchQueries() throws Throwable {
        StaticMapping staticMapping = this.newInstance("top");
        this.assertMultiSwitch((DNSToSwitchMapping)staticMapping);
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        LOG.info("Mapping: " + cachedMap + "\n" + cachedMap.dumpTopology());
        this.assertMultiSwitch((DNSToSwitchMapping)cachedMap);
    }

    @Test
    public void testCachingRelaysResolveQueries() throws Throwable {
        StaticMapping mapping = this.newInstance();
        mapping.setConf(this.createConf("top"));
        StaticMapping staticMapping = mapping;
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 0);
        StaticMapping.addNodeToRack("n1", "/r1");
        this.assertMapSize(staticMapping, 1);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 0);
        cachedMap.resolve(this.createQueryList());
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 2);
    }

    @Test
    public void testCachingCachesNegativeEntries() throws Throwable {
        StaticMapping staticMapping = this.newInstance();
        CachedDNSToSwitchMapping cachedMap = new CachedDNSToSwitchMapping((DNSToSwitchMapping)staticMapping);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 0);
        this.assertMapSize(staticMapping, 0);
        List resolved = cachedMap.resolve(this.createQueryList());
        this.assertMapSize(staticMapping, 0);
        this.assertMapSize((AbstractDNSToSwitchMapping)cachedMap, 2);
    }
}

