/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.net.NetworkTopologyWithNodeGroup;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestNetworkTopologyWithNodeGroup {
    private static final NetworkTopologyWithNodeGroup cluster = new NetworkTopologyWithNodeGroup();
    private static final NodeBase[] dataNodes = new NodeBase[]{new NodeBase("h1", "/d1/r1/s1"), new NodeBase("h2", "/d1/r1/s1"), new NodeBase("h3", "/d1/r1/s2"), new NodeBase("h4", "/d1/r2/s3"), new NodeBase("h5", "/d1/r2/s3"), new NodeBase("h6", "/d1/r2/s4"), new NodeBase("h7", "/d2/r3/s5"), new NodeBase("h8", "/d2/r3/s6")};
    private static final NodeBase computeNode = new NodeBase("/d1/r1/s1/h9");
    private static final NodeBase rackOnlyNode = new NodeBase("h10", "/r2");

    @Test
    public void testNumOfChildren() throws Exception {
        Assertions.assertEquals((int)dataNodes.length, (int)cluster.getNumOfLeaves());
    }

    @Test
    public void testNumOfRacks() throws Exception {
        Assertions.assertEquals((int)3, (int)cluster.getNumOfRacks());
    }

    @Test
    public void testRacks() throws Exception {
        Assertions.assertEquals((int)3, (int)cluster.getNumOfRacks());
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[0], (Node)dataNodes[1]));
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[1], (Node)dataNodes[2]));
        Assertions.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[2], (Node)dataNodes[3]));
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[3], (Node)dataNodes[4]));
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[4], (Node)dataNodes[5]));
        Assertions.assertFalse((boolean)cluster.isOnSameRack((Node)dataNodes[5], (Node)dataNodes[6]));
        Assertions.assertTrue((boolean)cluster.isOnSameRack((Node)dataNodes[6], (Node)dataNodes[7]));
    }

    @Test
    public void testNodeGroups() throws Exception {
        Assertions.assertEquals((int)3, (int)cluster.getNumOfRacks());
        Assertions.assertTrue((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[0], (Node)dataNodes[1]));
        Assertions.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[1], (Node)dataNodes[2]));
        Assertions.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[2], (Node)dataNodes[3]));
        Assertions.assertTrue((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[3], (Node)dataNodes[4]));
        Assertions.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[4], (Node)dataNodes[5]));
        Assertions.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[5], (Node)dataNodes[6]));
        Assertions.assertFalse((boolean)cluster.isOnSameNodeGroup((Node)dataNodes[6], (Node)dataNodes[7]));
    }

    @Test
    public void testGetDistance() throws Exception {
        Assertions.assertEquals((int)0, (int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[0]));
        Assertions.assertEquals((int)2, (int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[1]));
        Assertions.assertEquals((int)4, (int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[2]));
        Assertions.assertEquals((int)6, (int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[3]));
        Assertions.assertEquals((int)8, (int)cluster.getDistance((Node)dataNodes[0], (Node)dataNodes[6]));
    }

    @Test
    public void testSortByDistance() throws Exception {
        NodeBase[] testNodes = new NodeBase[]{dataNodes[1], dataNodes[2], dataNodes[3], dataNodes[0]};
        cluster.sortByDistance((Node)dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[2] == dataNodes[2] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[3] == dataNodes[3] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[3];
        testNodes[1] = dataNodes[4];
        testNodes[2] = dataNodes[1];
        testNodes[3] = dataNodes[0];
        cluster.sortByDistance((Node)dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == dataNodes[1] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[5];
        testNodes[1] = dataNodes[3];
        testNodes[2] = dataNodes[2];
        testNodes[3] = dataNodes[0];
        cluster.sortByDistance((Node)dataNodes[0], (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == dataNodes[2] ? 1 : 0) != 0);
        testNodes[0] = dataNodes[6];
        testNodes[1] = dataNodes[7];
        testNodes[2] = dataNodes[2];
        testNodes[3] = dataNodes[0];
        cluster.sortByDistance((Node)computeNode, (Node[])testNodes, testNodes.length);
        Assertions.assertTrue((testNodes[0] == dataNodes[0] ? 1 : 0) != 0);
        Assertions.assertTrue((testNodes[1] == dataNodes[2] ? 1 : 0) != 0);
    }

    private Map<Node, Integer> pickNodesAtRandom(int numNodes, String excludedScope) {
        HashMap<Node, Integer> frequency = new HashMap<Node, Integer>();
        for (NodeBase dnd : dataNodes) {
            frequency.put((Node)dnd, 0);
        }
        for (int j = 0; j < numNodes; ++j) {
            Node random = cluster.chooseRandom(excludedScope);
            frequency.put(random, (Integer)frequency.get(random) + 1);
        }
        return frequency;
    }

    @Test
    public void testChooseRandomExcludedNode() {
        String scope = "~" + NodeBase.getPath((Node)dataNodes[0]);
        Map<Node, Integer> frequency = this.pickNodesAtRandom(100, scope);
        for (NodeBase key : dataNodes) {
            Assertions.assertTrue((frequency.get(key) > 0 || key == dataNodes[0] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNodeGroup() throws Exception {
        String res = cluster.getNodeGroup("");
        Assertions.assertTrue((boolean)res.equals(""), (String)"NodeGroup should be NodeBase.ROOT for empty location");
        try {
            cluster.getNodeGroup(null);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Network Location is null"), (String)"Null Network Location should throw exception!");
        }
    }

    @Test
    public void testAddNodeWithInvalidTopology() {
        try {
            cluster.add((Node)rackOnlyNode);
            Assertions.fail((String)"Exception should be thrown, so we should not have reached here.");
        }
        catch (Exception e) {
            if (!(e instanceof IllegalArgumentException)) {
                Assertions.fail((String)("Expecting IllegalArgumentException, but caught:" + e));
            }
            Assertions.assertTrue((boolean)e.getMessage().contains("illegal network location"));
        }
    }

    static {
        for (int i = 0; i < dataNodes.length; ++i) {
            cluster.add((Node)dataNodes[i]);
        }
    }
}

