/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.stat.inference.ChiSquareTest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestClusterTopology
extends Assertions {
    @Test
    public void testCountNumNodes() throws Exception {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node1 = this.getNewNode("node1", "/d1/r1");
        cluster.add((Node)node1);
        NodeElement node2 = this.getNewNode("node2", "/d1/r2");
        cluster.add((Node)node2);
        NodeElement node3 = this.getNewNode("node3", "/d1/r3");
        cluster.add((Node)node3);
        NodeElement node4 = this.getNewNode("node4", "/d1/r4");
        cluster.add((Node)node4);
        ArrayList<NodeElement> excludedNodes = new ArrayList<NodeElement>();
        TestClusterTopology.assertEquals((int)4, (int)cluster.countNumOfAvailableNodes("", excludedNodes), (String)"4 nodes should be available");
        NodeElement deadNode = this.getNewNode("node5", "/d1/r2");
        excludedNodes.add(deadNode);
        TestClusterTopology.assertEquals((int)4, (int)cluster.countNumOfAvailableNodes("", excludedNodes), (String)"4 nodes should be available with extra excluded Node");
        excludedNodes.add(node4);
        TestClusterTopology.assertEquals((int)3, (int)cluster.countNumOfAvailableNodes("", excludedNodes), (String)"excluded nodes with ROOT scope should be considered");
        TestClusterTopology.assertEquals((int)2, (int)cluster.countNumOfAvailableNodes("~" + deadNode.getNetworkLocation(), excludedNodes), (String)"excluded nodes without ~ scope should be considered");
        TestClusterTopology.assertEquals((int)1, (int)cluster.countNumOfAvailableNodes(deadNode.getNetworkLocation(), excludedNodes), (String)"excluded nodes with rack scope should be considered");
        excludedNodes.add(node2);
        TestClusterTopology.assertEquals((int)2, (int)cluster.countNumOfAvailableNodes("~" + deadNode.getNetworkLocation(), excludedNodes), (String)"excluded nodes with ~ scope should be considered");
        TestClusterTopology.assertEquals((int)0, (int)cluster.countNumOfAvailableNodes("/non-exist", excludedNodes), (String)"No nodes should be considered for non-exist scope");
        cluster.remove((Node)node1);
        TestClusterTopology.assertEquals((int)1, (int)cluster.countNumOfAvailableNodes("", excludedNodes), (String)"1 node should be available");
    }

    @Test
    public void testChooseRandom() {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node1 = this.getNewNode("node1", "/d1/r1");
        cluster.add((Node)node1);
        NodeElement node2 = this.getNewNode("node2", "/d1/r2");
        cluster.add((Node)node2);
        NodeElement node3 = this.getNewNode("node3", "/d1/r3");
        cluster.add((Node)node3);
        NodeElement node4 = this.getNewNode("node4", "/d1/r3");
        cluster.add((Node)node4);
        int numTestRuns = 3;
        int chiSquareTestRejectedCounter = 0;
        int numIterations = 100;
        for (int testRun = 0; testRun < numTestRuns; ++testRun) {
            HashMap<String, Integer> histogram = new HashMap<String, Integer>();
            for (int i = 0; i < numIterations; ++i) {
                String randomNode = cluster.chooseRandom("").getName();
                if (!histogram.containsKey(randomNode)) {
                    histogram.put(randomNode, 0);
                }
                histogram.put(randomNode, (Integer)histogram.get(randomNode) + 1);
            }
            TestClusterTopology.assertEquals((int)4, (int)histogram.size(), (String)"Random is not selecting all nodes");
            ChiSquareTest chiSquareTest = new ChiSquareTest();
            double[] expected = new double[histogram.size()];
            long[] observed = new long[histogram.size()];
            int j = 0;
            for (Integer occurrence : histogram.values()) {
                expected[j] = 1.0 * (double)numIterations / (double)histogram.size();
                observed[j] = occurrence.intValue();
                ++j;
            }
            boolean chiSquareTestRejected = chiSquareTest.chiSquareTest(expected, observed, 0.01);
            if (!chiSquareTestRejected) continue;
            ++chiSquareTestRejectedCounter;
        }
        TestClusterTopology.assertFalse((chiSquareTestRejectedCounter == 3 ? 1 : 0) != 0, (String)"Random not choosing nodes with proper distribution");
        HashMap<String, Integer> histogram = new HashMap<String, Integer>();
        for (int i = 0; i < numIterations; ++i) {
            String randomNode = cluster.chooseRandom("~/d1/r3").getName();
            if (!histogram.containsKey(randomNode)) {
                histogram.put(randomNode, 0);
            }
            histogram.put(randomNode, (Integer)histogram.get(randomNode) + 1);
        }
        TestClusterTopology.assertEquals((int)2, (int)histogram.size(), (String)"Random is not selecting the nodes it should");
        Node val = cluster.chooseRandom("/d1", "/d", Collections.emptyList());
        TestClusterTopology.assertNotNull((Object)val);
    }

    @Test
    public void testChooseRandomExcluded() {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node1 = this.getNewNode("node1", "/a1/b1/c1");
        cluster.add((Node)node1);
        NodeElement node2 = this.getNewNode("node2", "/a1/b1/c1");
        cluster.add((Node)node2);
        NodeElement node3 = this.getNewNode("node3", "/a1/b1/c2");
        cluster.add((Node)node3);
        NodeElement node4 = this.getNewNode("node4", "/a1/b2/c3");
        cluster.add((Node)node4);
        Node node = cluster.chooseRandom("/a1/b1", "/a1/b1/c1", null);
        TestClusterTopology.assertSame((Object)"node3", (Object)node.getName());
        node = cluster.chooseRandom("/a1/b1", "/a1/b1/c1", Arrays.asList(node1));
        TestClusterTopology.assertSame((Object)"node3", (Object)node.getName());
        node = cluster.chooseRandom("/a1/b1", "/a1/b1/c1", Arrays.asList(node3));
        TestClusterTopology.assertNull((Object)node);
        node = cluster.chooseRandom("/a1/b1", "/a1/b1/c1", Arrays.asList(node4));
        TestClusterTopology.assertSame((Object)"node3", (Object)node.getName());
    }

    @Test
    public void testNodeBaseNormalizeRemoveLeadingSlash() {
        TestClusterTopology.assertEquals((Object)"/d1", (Object)NodeBase.normalize((String)"/d1///"));
        TestClusterTopology.assertEquals((Object)"/d1", (Object)NodeBase.normalize((String)"/d1/"));
        TestClusterTopology.assertEquals((Object)"/d1", (Object)NodeBase.normalize((String)"/d1"));
        TestClusterTopology.assertEquals((Object)"", (Object)NodeBase.normalize((String)"///"));
        TestClusterTopology.assertEquals((Object)"", (Object)NodeBase.normalize((String)"/"));
    }

    private NodeElement getNewNode(String name, String rackLocation) {
        NodeElement node = new NodeElement(name);
        node.setNetworkLocation(rackLocation);
        return node;
    }

    private NodeElement getNewNode(NetworkTopology cluster, String name, String rackLocation) {
        NodeElement node = this.getNewNode(name, rackLocation);
        cluster.add((Node)node);
        return node;
    }

    @Test
    public void testWeights() {
        NetworkTopology cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node1 = this.getNewNode(cluster, "node1", "/r1");
        NodeElement node2 = this.getNewNode(cluster, "node2", "/r1");
        NodeElement node3 = this.getNewNode(cluster, "node3", "/r2");
        for (Pair test : new Pair[]{Pair.of((Object)0, (Object)node1), Pair.of((Object)2, (Object)node2), Pair.of((Object)4, (Object)node3)}) {
            int expect = (Integer)test.getLeft();
            TestClusterTopology.assertEquals((int)expect, (int)cluster.getWeight((Node)node1, (Node)test.getRight()), (String)test.toString());
            TestClusterTopology.assertEquals((int)expect, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)node1, (Node)((Node)test.getRight())), (String)test.toString());
        }
        cluster = NetworkTopology.getInstance((Configuration)new Configuration());
        NodeElement node5 = this.getNewNode(cluster, "node5", "/pod1/r1");
        NodeElement node6 = this.getNewNode(cluster, "node6", "/pod1/r1");
        NodeElement node7 = this.getNewNode(cluster, "node7", "/pod1/r2");
        NodeElement node8 = this.getNewNode(cluster, "node8", "/pod2/r3");
        for (Pair test : new Pair[]{Pair.of((Object)0, (Object)node5), Pair.of((Object)2, (Object)node6), Pair.of((Object)4, (Object)node7), Pair.of((Object)6, (Object)node8)}) {
            int expect = (Integer)test.getLeft();
            TestClusterTopology.assertEquals((int)expect, (int)cluster.getWeight((Node)node5, (Node)test.getRight()), (String)test.toString());
            TestClusterTopology.assertEquals((int)expect, (int)NetworkTopology.getWeightUsingNetworkLocation((Node)node5, (Node)((Node)test.getRight())), (String)test.toString());
        }
    }

    public static class NodeElement
    implements Node {
        private String location;
        private String name;
        private Node parent;
        private int level;

        public NodeElement(String name) {
            this.name = name;
        }

        public String getNetworkLocation() {
            return this.location;
        }

        public void setNetworkLocation(String location) {
            this.location = location;
        }

        public String getName() {
            return this.name;
        }

        public Node getParent() {
            return this.parent;
        }

        public void setParent(Node parent) {
            this.parent = parent;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int i) {
            this.level = i;
        }
    }
}

