/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import org.apache.hadoop.metrics2.util.SampleStat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSampleStat {
    private static final double EPSILON = 1.0E-42;

    @Test
    public void testSimple() {
        SampleStat stat = new SampleStat();
        Assertions.assertEquals((long)0L, (long)stat.numSamples(), (String)"num samples");
        Assertions.assertEquals((double)0.0, (double)stat.mean(), (double)1.0E-42, (String)"mean");
        Assertions.assertEquals((double)0.0, (double)stat.variance(), (double)1.0E-42, (String)"variance");
        Assertions.assertEquals((double)0.0, (double)stat.stddev(), (double)1.0E-42, (String)"stddev");
        Assertions.assertEquals((double)3.4028234663852886E38, (double)stat.min(), (double)1.0E-42, (String)"min");
        Assertions.assertEquals((double)1.4E-45f, (double)stat.max(), (double)1.0E-42, (String)"max");
        stat.add(3.0);
        Assertions.assertEquals((long)1L, (long)stat.numSamples(), (String)"num samples");
        Assertions.assertEquals((double)3.0, (double)stat.mean(), (double)1.0E-42, (String)"mean");
        Assertions.assertEquals((double)0.0, (double)stat.variance(), (double)1.0E-42, (String)"variance");
        Assertions.assertEquals((double)0.0, (double)stat.stddev(), (double)1.0E-42, (String)"stddev");
        Assertions.assertEquals((double)3.0, (double)stat.min(), (double)1.0E-42, (String)"min");
        Assertions.assertEquals((double)3.0, (double)stat.max(), (double)1.0E-42, (String)"max");
        stat.add(2.0).add(1.0);
        Assertions.assertEquals((long)3L, (long)stat.numSamples(), (String)"num samples");
        Assertions.assertEquals((double)2.0, (double)stat.mean(), (double)1.0E-42, (String)"mean");
        Assertions.assertEquals((double)1.0, (double)stat.variance(), (double)1.0E-42, (String)"variance");
        Assertions.assertEquals((double)1.0, (double)stat.stddev(), (double)1.0E-42, (String)"stddev");
        Assertions.assertEquals((double)1.0, (double)stat.min(), (double)1.0E-42, (String)"min");
        Assertions.assertEquals((double)3.0, (double)stat.max(), (double)1.0E-42, (String)"max");
        stat.reset();
        Assertions.assertEquals((long)0L, (long)stat.numSamples(), (String)"num samples");
        Assertions.assertEquals((double)0.0, (double)stat.mean(), (double)1.0E-42, (String)"mean");
        Assertions.assertEquals((double)0.0, (double)stat.variance(), (double)1.0E-42, (String)"variance");
        Assertions.assertEquals((double)0.0, (double)stat.stddev(), (double)1.0E-42, (String)"stddev");
        Assertions.assertEquals((double)3.4028234663852886E38, (double)stat.min(), (double)1.0E-42, (String)"min");
        Assertions.assertEquals((double)1.4E-45f, (double)stat.max(), (double)1.0E-42, (String)"max");
    }
}

