/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.metrics2.lib.MutableInverseQuantiles;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.metrics2.util.SampleQuantiles;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestSampleQuantiles {
    static final Quantile[] quantiles = new Quantile[]{new Quantile(0.5, 0.05), new Quantile(0.75, 0.025), new Quantile(0.9, 0.01), new Quantile(0.95, 0.005), new Quantile(0.99, 0.001)};
    SampleQuantiles estimator;
    static final int NUM_REPEATS = 10;

    @BeforeEach
    public void init() {
        this.estimator = new SampleQuantiles(quantiles);
    }

    @Test
    public void testCount() throws IOException {
        Assertions.assertThat((long)this.estimator.getCount()).isZero();
        Assertions.assertThat((int)this.estimator.getSampleCount()).isZero();
        Assertions.assertThat((Map)this.estimator.snapshot()).isNull();
        this.estimator.insert(1337L);
        Assertions.assertThat((long)this.estimator.getCount()).isOne();
        this.estimator.snapshot();
        Assertions.assertThat((int)this.estimator.getSampleCount()).isOne();
        Assertions.assertThat((String)this.estimator.toString()).isEqualTo((Object)"50.00 %ile +/- 5.00%: 1337\n75.00 %ile +/- 2.50%: 1337\n90.00 %ile +/- 1.00%: 1337\n95.00 %ile +/- 0.50%: 1337\n99.00 %ile +/- 0.10%: 1337");
    }

    @Test
    public void testClear() throws IOException {
        for (int i = 0; i < 1000; ++i) {
            this.estimator.insert((long)i);
        }
        this.estimator.clear();
        Assertions.assertThat((long)this.estimator.getCount()).isZero();
        Assertions.assertThat((int)this.estimator.getSampleCount()).isZero();
        Assertions.assertThat((Map)this.estimator.snapshot()).isNull();
    }

    @Test
    public void testQuantileError() throws IOException {
        int i;
        int count = 100000;
        Random rnd = new Random(-559030611L);
        int[] values = new int[100000];
        for (i = 0; i < 100000; ++i) {
            values[i] = i + 1;
        }
        for (i = 0; i < 10; ++i) {
            Collections.shuffle(Arrays.asList(new int[][]{values}), rnd);
            this.estimator.clear();
            for (int value : values) {
                this.estimator.insert((long)value);
            }
            Map snapshot = this.estimator.snapshot();
            for (Quantile q : quantiles) {
                long actual = (long)(q.quantile * 100000.0);
                long error = (long)(q.error * 100000.0);
                long estimate = (Long)snapshot.get(q);
                Assertions.assertThat((estimate <= actual + error ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((estimate >= actual - error ? 1 : 0) != 0).isTrue();
            }
        }
    }

    @Test
    public void testInverseQuantiles() throws IOException {
        int i;
        SampleQuantiles inverseQuantilesEstimator = new SampleQuantiles(MutableInverseQuantiles.INVERSE_QUANTILES);
        int count = 100000;
        Random rnd = new Random(-559030611L);
        int[] values = new int[100000];
        for (i = 0; i < 100000; ++i) {
            values[i] = i + 1;
        }
        for (i = 0; i < 10; ++i) {
            Collections.shuffle(Arrays.asList(new int[][]{values}), rnd);
            inverseQuantilesEstimator.clear();
            for (int value : values) {
                inverseQuantilesEstimator.insert((long)value);
            }
            Map snapshot = inverseQuantilesEstimator.snapshot();
            for (Quantile q : MutableInverseQuantiles.INVERSE_QUANTILES) {
                long actual = (long)(q.quantile * 100000.0);
                long error = (long)(q.error * 100000.0);
                long estimate = (Long)snapshot.get(q);
                Assertions.assertThat((estimate <= actual + error ? 1 : 0) != 0).isTrue();
                Assertions.assertThat((estimate >= actual - error ? 1 : 0) != 0).isTrue();
            }
        }
    }
}

