/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.util.Calendar;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.impl.ConfigBuilder;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSink;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRollingFileSystemSink {
    @Test
    public void testInit() {
        ConfigBuilder builder = new ConfigBuilder();
        SubsetConfiguration conf = builder.add("sink.roll-interval", "10m").add("sink.roll-offset-interval-millis", "1").add("sink.basepath", "path").add("sink.ignore-error", "true").add("sink.allow-append", "true").add("sink.source", "src").subset("sink");
        RollingFileSystemSink sink = new RollingFileSystemSink();
        sink.init(conf);
        Assertions.assertEquals((long)sink.rollIntervalMillis, (long)600000L, (String)"The roll interval was not set correctly");
        Assertions.assertEquals((long)sink.rollOffsetIntervalMillis, (long)1L, (String)"The roll offset interval was not set correctly");
        Assertions.assertEquals((Object)sink.basePath, (Object)new Path("path"), (String)"The base path was not set correctly");
        Assertions.assertEquals((Object)sink.ignoreError, (Object)true, (String)"ignore-error was not set correctly");
        Assertions.assertEquals((Object)sink.allowAppend, (Object)true, (String)"allow-append was not set correctly");
        Assertions.assertEquals((Object)sink.source, (Object)"src", (String)"The source was not set correctly");
    }

    @Test
    public void testSetInitialFlushTime() {
        RollingFileSystemSink rfsSink = new RollingFileSystemSink(1000L, 0L);
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        calendar.set(6, 1);
        calendar.set(1, 2016);
        Assertions.assertNull((Object)rfsSink.nextFlush, (String)"Last flush time should have been null prior to calling init()");
        rfsSink.setInitialFlushTime(calendar.getTime());
        long diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assertions.assertEquals((long)0L, (long)diff, (String)"The initial flush time was calculated incorrectly");
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assertions.assertEquals((long)-10L, (long)diff, (String)"The initial flush time was calculated incorrectly");
        calendar.set(13, 1);
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assertions.assertEquals((long)-10L, (long)diff, (String)"The initial flush time was calculated incorrectly");
        rfsSink = new RollingFileSystemSink(1000L, 100L);
        Assertions.assertNull((Object)rfsSink.nextFlush, (String)"Last flush time should have been null prior to calling init()");
        calendar.set(14, 0);
        calendar.set(13, 0);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assertions.assertTrue((diff == 0L || diff > -1000L && diff < -900L ? 1 : 0) != 0, (String)("The initial flush time was calculated incorrectly: " + diff));
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assertions.assertTrue((diff >= -10L && diff <= 0L || diff > -1000L && diff < -910L ? 1 : 0) != 0, (String)("The initial flush time was calculated incorrectly: " + diff));
        calendar.set(13, 1);
        calendar.set(14, 10);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assertions.assertTrue((diff >= -10L && diff <= 0L || diff > -1000L && diff < -910L ? 1 : 0) != 0, (String)("The initial flush time was calculated incorrectly: " + diff));
        rfsSink = new RollingFileSystemSink(1000L, 1000000L);
        Assertions.assertNull((Object)rfsSink.nextFlush, (String)"Last flush time should have been null prior to calling init()");
        calendar.set(14, 1);
        calendar.set(13, 0);
        rfsSink.setInitialFlushTime(calendar.getTime());
        diff = rfsSink.nextFlush.getTimeInMillis() - calendar.getTimeInMillis();
        Assertions.assertTrue((diff > -1000L && diff <= 0L ? 1 : 0) != 0, (String)("The initial flush time was calculated incorrectly: " + diff));
    }

    @Test
    public void testUpdateRollTime() {
        RollingFileSystemSink rfsSink = new RollingFileSystemSink(1000L, 0L);
        Calendar calendar = Calendar.getInstance();
        calendar.set(14, 0);
        calendar.set(13, 0);
        calendar.set(12, 0);
        calendar.set(10, 0);
        calendar.set(6, 1);
        calendar.set(1, 2016);
        rfsSink.nextFlush = Calendar.getInstance();
        rfsSink.nextFlush.setTime(calendar.getTime());
        rfsSink.updateFlushTime(calendar.getTime());
        Assertions.assertEquals((long)(calendar.getTimeInMillis() + 1000L), (long)rfsSink.nextFlush.getTimeInMillis(), (String)"The next roll time should have been 1 second in the future");
        rfsSink.nextFlush.setTime(calendar.getTime());
        calendar.add(14, 10);
        rfsSink.updateFlushTime(calendar.getTime());
        Assertions.assertEquals((long)(calendar.getTimeInMillis() + 990L), (long)rfsSink.nextFlush.getTimeInMillis(), (String)"The next roll time should have been 990 ms in the future");
        rfsSink.nextFlush.setTime(calendar.getTime());
        calendar.add(13, 2);
        calendar.add(14, 10);
        rfsSink.updateFlushTime(calendar.getTime());
        Assertions.assertEquals((long)(calendar.getTimeInMillis() + 990L), (long)rfsSink.nextFlush.getTimeInMillis(), (String)"The next roll time should have been 990 ms in the future");
    }

    @Test
    public void testGetRollInterval() {
        this.doTestGetRollInterval(1, new String[]{"m", "min", "minute", "minutes"}, 60000L);
        this.doTestGetRollInterval(1, new String[]{"h", "hr", "hour", "hours"}, 3600000L);
        this.doTestGetRollInterval(1, new String[]{"d", "day", "days"}, 86400000L);
        ConfigBuilder builder = new ConfigBuilder();
        SubsetConfiguration conf = builder.add("sink.roll-interval", "1").subset("sink");
        RollingFileSystemSink sink = new RollingFileSystemSink();
        sink.init(conf);
        Assertions.assertEquals((long)3600000L, (long)sink.getRollInterval());
        for (char c : "abcefgijklnopqrtuvwxyz".toCharArray()) {
            builder = new ConfigBuilder();
            conf = builder.add("sink.roll-interval", "90 " + c).subset("sink");
            try {
                sink.init(conf);
                sink.getRollInterval();
                Assertions.fail((String)("Allowed flush interval with bad units: " + c));
            }
            catch (MetricsException metricsException) {
                // empty catch block
            }
        }
    }

    private void doTestGetRollInterval(int num, String[] units, long expected) {
        RollingFileSystemSink sink = new RollingFileSystemSink();
        ConfigBuilder builder = new ConfigBuilder();
        for (String unit : units) {
            sink.init(builder.add("sink.roll-interval", num + unit).subset("sink"));
            Assertions.assertEquals((long)expected, (long)sink.getRollInterval());
            sink.init(builder.add("sink.roll-interval", num + unit.toUpperCase()).subset("sink"));
            Assertions.assertEquals((long)expected, (long)sink.getRollInterval());
            sink.init(builder.add("sink.roll-interval", num + " " + unit).subset("sink"));
            Assertions.assertEquals((long)expected, (long)sink.getRollInterval());
            sink.init(builder.add("sink.roll-interval", num + " " + unit.toUpperCase()).subset("sink"));
            Assertions.assertEquals((long)expected, (long)sink.getRollInterval());
        }
    }
}

