/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.Interns;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestInterns {
    @Test
    public void testInfo() {
        MetricsInfo info = Interns.info((String)"m", (String)"m desc");
        Assertions.assertSame((Object)info, (Object)Interns.info((String)"m", (String)"m desc"), (String)"same info");
    }

    @Test
    public void testTag() {
        MetricsTag tag = Interns.tag((String)"t", (String)"t desc", (String)"t value");
        Assertions.assertSame((Object)tag, (Object)Interns.tag((String)"t", (String)"t desc", (String)"t value"), (String)"same tag");
    }

    @Test
    public void testInfoOverflow() {
        MetricsInfo i0 = Interns.info((String)"m0", (String)"m desc");
        for (int i = 0; i < 2011; ++i) {
            Interns.info((String)("m" + i), (String)"m desc");
            if (i >= 2010) continue;
            Assertions.assertSame((Object)i0, (Object)Interns.info((String)"m0", (String)"m desc"), (String)"m0 is still there");
        }
        Assertions.assertNotSame((Object)i0, (Object)Interns.info((String)"m0", (String)"m desc"), (String)"m0 is gone");
        MetricsInfo i1 = Interns.info((String)"m1", (String)"m desc");
        for (int i = 0; i < 100; ++i) {
            Interns.info((String)"m1", (String)("m desc" + i));
            if (i >= 99) continue;
            Assertions.assertSame((Object)i1, (Object)Interns.info((String)"m1", (String)"m desc"), (String)"i1 is still there");
        }
        Assertions.assertNotSame((Object)i1, (Object)Interns.info((String)"m1", (String)"m desc"), (String)"i1 is gone");
    }

    @Test
    public void testTagOverflow() {
        MetricsTag t0 = Interns.tag((String)"t0", (String)"t desc", (String)"t value");
        for (int i = 0; i < 101; ++i) {
            Interns.tag((String)("t" + i), (String)"t desc", (String)"t value");
            if (i >= 100) continue;
            Assertions.assertSame((Object)t0, (Object)Interns.tag((String)"t0", (String)"t desc", (String)"t value"), (String)"t0 still there");
        }
        Assertions.assertNotSame((Object)t0, (Object)Interns.tag((String)"t0", (String)"t desc", (String)"t value"), (String)"t0 is gone");
        MetricsTag t1 = Interns.tag((String)"t1", (String)"t desc", (String)"t value");
        for (int i = 0; i < 1000; ++i) {
            Interns.tag((String)"t1", (String)"t desc", (String)("t value" + i));
            if (i >= 999) continue;
            Assertions.assertSame((Object)t1, (Object)Interns.tag((String)"t1", (String)"t desc", (String)"t value"), (String)"t1 is still there");
        }
        Assertions.assertNotSame((Object)t1, (Object)Interns.tag((String)"t1", (String)"t desc", (String)"t value"), (String)"t1 is gone");
    }
}

