/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.apache.hadoop.ipc.WeightedTimeCostProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestWeightedTimeCostProvider {
    private static final int QUEUE_TIME = 3;
    private static final int LOCKFREE_TIME = 5;
    private static final int LOCKSHARED_TIME = 7;
    private static final int LOCKEXCLUSIVE_TIME = 11;
    private WeightedTimeCostProvider costProvider;
    private ProcessingDetails processingDetails;

    @BeforeEach
    public void setup() {
        this.costProvider = new WeightedTimeCostProvider();
        this.processingDetails = new ProcessingDetails(TimeUnit.MILLISECONDS);
        this.processingDetails.set(ProcessingDetails.Timing.QUEUE, 3L);
        this.processingDetails.set(ProcessingDetails.Timing.LOCKFREE, 5L);
        this.processingDetails.set(ProcessingDetails.Timing.LOCKSHARED, 7L);
        this.processingDetails.set(ProcessingDetails.Timing.LOCKEXCLUSIVE, 11L);
    }

    @Test
    public void testGetCostBeforeInit() {
        Assertions.assertThrows(AssertionError.class, () -> this.costProvider.getCost(null));
    }

    @Test
    public void testGetCostDefaultWeights() {
        this.costProvider.init("foo", new Configuration());
        long actualCost = this.costProvider.getCost(this.processingDetails);
        long expectedCost = 1175L;
        Assertions.assertEquals((long)expectedCost, (long)actualCost);
    }

    @Test
    public void testGetCostConfiguredWeights() {
        Configuration conf = new Configuration();
        int queueWeight = 1000;
        int lockfreeWeight = 10000;
        int locksharedWeight = 100000;
        conf.setInt("foo.weighted-cost.queue", queueWeight);
        conf.setInt("foo.weighted-cost.lockfree", lockfreeWeight);
        conf.setInt("foo.weighted-cost.lockshared", locksharedWeight);
        conf.setInt("bar.weighted-cost.lockexclusive", 0);
        this.costProvider.init("foo", conf);
        long actualCost = this.costProvider.getCost(this.processingDetails);
        long expectedCost = queueWeight * 3 + lockfreeWeight * 5 + locksharedWeight * 7 + 1100;
        Assertions.assertEquals((long)expectedCost, (long)actualCost);
    }
}

