/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.net.SocksSocketFactory;
import org.apache.hadoop.net.StandardSocketFactory;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestSocketFactory {
    private static final int START_STOP_TIMEOUT_SEC = 30;
    private ServerRunnable serverRunnable;
    private Thread serverThread;
    private int port;

    private void startTestServer() throws Exception {
        this.serverRunnable = new ServerRunnable();
        this.serverThread = new Thread(this.serverRunnable);
        this.serverThread.start();
        long timeout = System.currentTimeMillis() + 30000L;
        while (!this.serverRunnable.isReady()) {
            org.junit.jupiter.api.Assertions.assertNull((Object)this.serverRunnable.getThrowable());
            Thread.sleep(10L);
            if (System.currentTimeMillis() <= timeout) continue;
            org.junit.jupiter.api.Assertions.fail((String)"Server thread did not start properly in allowed time of 30 sec.");
        }
        this.port = this.serverRunnable.getPort();
    }

    @AfterEach
    public void stopTestServer() throws InterruptedException {
        Thread t = this.serverThread;
        if (t != null) {
            this.serverThread = null;
            this.port = -1;
            this.serverRunnable.stop();
            t.join(30000L);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)t.isAlive());
            org.junit.jupiter.api.Assertions.assertNull((Object)this.serverRunnable.getThrowable());
        }
    }

    @Test
    public void testSocketFactoryAsKeyInMap() {
        HashMap<SocketFactory, Integer> dummyCache = new HashMap<SocketFactory, Integer>();
        int toBeCached1 = 1;
        int toBeCached2 = 2;
        Configuration conf = new Configuration();
        conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.ipc.TestSocketFactory$DummySocketFactory");
        SocketFactory dummySocketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        dummyCache.put(dummySocketFactory, toBeCached1);
        conf.set("hadoop.rpc.socket.factory.class.default", "org.apache.hadoop.net.StandardSocketFactory");
        SocketFactory defaultSocketFactory = NetUtils.getDefaultSocketFactory((Configuration)conf);
        dummyCache.put(defaultSocketFactory, toBeCached2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)dummyCache.size()).withFailMessage("The cache contains two elements", new Object[0])).isEqualTo(2);
        ((ObjectAssert)Assertions.assertThat((Object)defaultSocketFactory).withFailMessage("Equals of both socket factory shouldn't be same", new Object[0])).isNotEqualTo((Object)dummySocketFactory);
        org.junit.jupiter.api.Assertions.assertSame((Object)toBeCached2, dummyCache.remove(defaultSocketFactory));
        dummyCache.put(defaultSocketFactory, toBeCached2);
        org.junit.jupiter.api.Assertions.assertSame((Object)toBeCached1, dummyCache.remove(dummySocketFactory));
    }

    @Test
    @Timeout(value=5L)
    public void testSocksSocketFactory() throws Exception {
        this.startTestServer();
        this.testSocketFactory((SocketFactory)new SocksSocketFactory());
    }

    @Test
    @Timeout(value=5L)
    public void testStandardSocketFactory() throws Exception {
        this.startTestServer();
        this.testSocketFactory((SocketFactory)new StandardSocketFactory());
    }

    private void testSocketFactory(SocketFactory socketFactory) throws Exception {
        org.junit.jupiter.api.Assertions.assertNull((Object)this.serverRunnable.getThrowable());
        InetAddress address = InetAddress.getLocalHost();
        Socket socket = socketFactory.createSocket(address, this.port);
        this.checkSocket(socket);
        socket.close();
        socket = socketFactory.createSocket(address, this.port, InetAddress.getLocalHost(), 0);
        this.checkSocket(socket);
        socket.close();
        socket = socketFactory.createSocket("localhost", this.port);
        this.checkSocket(socket);
        socket.close();
        socket = socketFactory.createSocket("localhost", this.port, InetAddress.getLocalHost(), 0);
        this.checkSocket(socket);
        socket.close();
    }

    @Test
    @Timeout(value=5L)
    public void testProxy() throws Exception {
        SocksSocketFactory templateWithoutProxy = new SocksSocketFactory();
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, InetSocketAddress.createUnresolved("localhost", 0));
        SocksSocketFactory templateWithProxy = new SocksSocketFactory(proxy);
        Assertions.assertThat((Object)templateWithoutProxy).isNotEqualTo((Object)templateWithProxy);
        Configuration configuration = new Configuration();
        configuration.set("hadoop.socks.server", "localhost:0");
        templateWithoutProxy.setConf(configuration);
        Assertions.assertThat((Object)templateWithoutProxy).isEqualTo((Object)templateWithProxy);
    }

    private void checkSocket(Socket socket) throws Exception {
        BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        out.writeBytes("test\n");
        String answer = input.readLine();
        Assertions.assertThat((String)answer).isEqualTo((Object)"TEST");
    }

    private static class ServerRunnable
    implements Runnable {
        private volatile boolean works = true;
        private ServerSocket testSocket;
        private volatile boolean ready = false;
        private volatile Throwable throwable;
        private int port0;

        private ServerRunnable() {
        }

        @Override
        public void run() {
            try {
                this.testSocket = new ServerSocket(0);
                this.port0 = this.testSocket.getLocalPort();
                this.ready = true;
                while (this.works) {
                    try {
                        Socket connectionSocket = this.testSocket.accept();
                        BufferedReader input = new BufferedReader(new InputStreamReader(connectionSocket.getInputStream()));
                        DataOutputStream out = new DataOutputStream(connectionSocket.getOutputStream());
                        String inData = input.readLine();
                        String outData = inData.toUpperCase() + "\n";
                        out.writeBytes(outData);
                    }
                    catch (SocketException connectionSocket) {}
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                this.throwable = ioe;
            }
        }

        public void stop() {
            this.works = false;
            try {
                this.testSocket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isReady() {
            return this.ready;
        }

        public int getPort() {
            return this.port0;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }

    static class DummySocketFactory
    extends StandardSocketFactory {
        DummySocketFactory() {
        }
    }
}

