/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.ipc.ProcessingDetails;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProcessingDetails {
    @Test
    public void testTimeConversion() {
        ProcessingDetails details = new ProcessingDetails(TimeUnit.MICROSECONDS);
        details.set(ProcessingDetails.Timing.ENQUEUE, 10L);
        Assertions.assertEquals((long)10L, (long)details.get(ProcessingDetails.Timing.ENQUEUE));
        Assertions.assertEquals((long)10000L, (long)details.get(ProcessingDetails.Timing.ENQUEUE, TimeUnit.NANOSECONDS));
        details.set(ProcessingDetails.Timing.QUEUE, 20L, TimeUnit.MILLISECONDS);
        details.add(ProcessingDetails.Timing.QUEUE, 20L, TimeUnit.MICROSECONDS);
        Assertions.assertEquals((long)20020L, (long)details.get(ProcessingDetails.Timing.QUEUE));
        Assertions.assertEquals((long)0L, (long)details.get(ProcessingDetails.Timing.QUEUE, TimeUnit.SECONDS));
    }

    @Test
    public void testToString() {
        ProcessingDetails details = new ProcessingDetails(TimeUnit.MICROSECONDS);
        details.set(ProcessingDetails.Timing.ENQUEUE, 10L);
        details.set(ProcessingDetails.Timing.QUEUE, 20L, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((Object)"enqueueTime=10 queueTime=20000 handlerTime=0 processingTime=0 lockfreeTime=0 lockwaitTime=0 locksharedTime=0 lockexclusiveTime=0 responseTime=0", (Object)details.toString());
    }
}

