/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.IdentityProvider;
import org.apache.hadoop.ipc.Schedulable;
import org.apache.hadoop.ipc.UserIdentityProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.Test;

public class TestIdentityProviders {
    @Test
    public void testPluggableIdentityProvider() {
        Configuration conf = new Configuration();
        conf.set("identity-provider.impl", "org.apache.hadoop.ipc.UserIdentityProvider");
        List providers = conf.getInstances("identity-provider.impl", IdentityProvider.class);
        ((ListAssert)Assertions.assertThat((List)providers).describedAs("provider list", new Object[0])).hasSize(1);
        IdentityProvider ip = (IdentityProvider)providers.get(0);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)ip);
        org.junit.jupiter.api.Assertions.assertEquals(ip.getClass(), UserIdentityProvider.class);
    }

    @Test
    public void testUserIdentityProvider() throws Exception {
        UserIdentityProvider uip = new UserIdentityProvider();
        FakeSchedulable fakeSchedulable = new FakeSchedulable();
        String identity = uip.makeIdentity((Schedulable)fakeSchedulable);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        String username = ugi.getUserName();
        org.junit.jupiter.api.Assertions.assertEquals((Object)username, (Object)identity);
        LambdaTestUtils.intercept(UnsupportedOperationException.class, "Invalid operation.", () -> ((FakeSchedulable)fakeSchedulable).getCallerContext());
    }

    public static class FakeSchedulable
    implements Schedulable {
        public UserGroupInformation getUserGroupInformation() {
            try {
                return UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                return null;
            }
        }

        public int getPriorityLevel() {
            return 0;
        }
    }
}

