/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.io.retry.UnreliableImplementation;
import org.apache.hadoop.io.retry.UnreliableInterface;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.util.ThreadUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFailoverProxy {
    private static FlipFlopProxyProvider<UnreliableInterface> newFlipFlopProxyProvider() {
        return new FlipFlopProxyProvider<UnreliableInterface>(UnreliableInterface.class, new UnreliableImplementation("impl1"), new UnreliableImplementation("impl2"));
    }

    private static FlipFlopProxyProvider<UnreliableInterface> newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith t1, UnreliableImplementation.TypeOfExceptionToFailWith t2) {
        return new FlipFlopProxyProvider<UnreliableInterface>(UnreliableInterface.class, new UnreliableImplementation("impl1", t1), new UnreliableImplementation("impl2", t2));
    }

    @Test
    public void testSuccedsOnceThenFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), (RetryPolicy)new FailOverOnceOnAnyExceptionPolicy());
        Assertions.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        Assertions.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assertions.fail((String)"should not have succeeded more than twice");
        }
        catch (UnreliableInterface.UnreliableException unreliableException) {
            // empty catch block
        }
    }

    @Test
    public void testSucceedsTenTimesThenFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), (RetryPolicy)new FailOverOnceOnAnyExceptionPolicy());
        for (int i = 0; i < 10; ++i) {
            Assertions.assertEquals((Object)"impl1", (Object)unreliable.succeedsTenTimesThenFailsReturningString());
        }
        Assertions.assertEquals((Object)"impl2", (Object)unreliable.succeedsTenTimesThenFailsReturningString());
    }

    @Test
    public void testNeverFailOver() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), (RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL);
        unreliable.succeedsOnceThenFailsReturningString();
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assertions.fail((String)"should not have succeeded twice");
        }
        catch (UnreliableInterface.UnreliableException e) {
            Assertions.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
    }

    @Test
    public void testFailoverOnStandbyException() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(), (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)1));
        Assertions.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assertions.fail((String)"should not have succeeded twice");
        }
        catch (UnreliableInterface.UnreliableException e) {
            Assertions.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
        unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)1));
        Assertions.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        Assertions.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningString());
    }

    @Test
    public void testFailoverOnNetworkExceptionIdempotentOperation() throws UnreliableInterface.UnreliableException, IOException, StandbyException {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.IO_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)1));
        Assertions.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningString());
        try {
            unreliable.succeedsOnceThenFailsReturningString();
            Assertions.fail((String)"should not have succeeded twice");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"impl1", (Object)e.getMessage());
        }
        Assertions.assertEquals((Object)"impl1", (Object)unreliable.succeedsOnceThenFailsReturningStringIdempotent());
        Assertions.assertEquals((Object)"impl2", (Object)unreliable.succeedsOnceThenFailsReturningStringIdempotent());
    }

    @Test
    public void testExceptionPropagatedForNonIdempotentVoid() throws Exception {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.IO_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)1));
        try {
            unreliable.nonIdempotentVoidFailsIfIdentifierDoesntMatch("impl2");
            Assertions.fail((String)"did not throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConcurrentMethodFailures() throws InterruptedException {
        FlipFlopProxyProvider<UnreliableImplementation> proxyProvider = new FlipFlopProxyProvider<UnreliableImplementation>(UnreliableInterface.class, new SynchronizedUnreliableImplementation("impl1", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION, 2), new UnreliableImplementation("impl2", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION));
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, proxyProvider, (RetryPolicy)RetryPolicies.failoverOnNetworkException((int)10));
        ConcurrentMethodThread t1 = new ConcurrentMethodThread(unreliable);
        ConcurrentMethodThread t2 = new ConcurrentMethodThread(unreliable);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        Assertions.assertEquals((Object)"impl2", (Object)t1.result);
        Assertions.assertEquals((Object)"impl2", (Object)t2.result);
        Assertions.assertEquals((int)1, (int)proxyProvider.getFailoversOccurred());
    }

    @Test
    public void testFailoverBetweenMultipleStandbys() throws UnreliableInterface.UnreliableException, StandbyException, IOException {
        long millisToSleep = 10000L;
        final UnreliableImplementation impl1 = new UnreliableImplementation("impl1", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION);
        FlipFlopProxyProvider<UnreliableImplementation> proxyProvider = new FlipFlopProxyProvider<UnreliableImplementation>(UnreliableInterface.class, impl1, new UnreliableImplementation("impl2", UnreliableImplementation.TypeOfExceptionToFailWith.STANDBY_EXCEPTION));
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, proxyProvider, (RetryPolicy)RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)10, (long)1000L, (long)10000L));
        new Thread(){

            @Override
            public void run() {
                ThreadUtil.sleepAtLeastIgnoreInterrupts((long)10000L);
                impl1.setIdentifier("renamed-impl1");
            }
        }.start();
        String result = unreliable.failsIfIdentifierDoesntMatch("renamed-impl1");
        Assertions.assertEquals((Object)"renamed-impl1", (Object)result);
    }

    @Test
    public void testExpectedIOException() {
        UnreliableInterface unreliable = (UnreliableInterface)RetryProxy.create(UnreliableInterface.class, TestFailoverProxy.newFlipFlopProxyProvider(UnreliableImplementation.TypeOfExceptionToFailWith.REMOTE_EXCEPTION, UnreliableImplementation.TypeOfExceptionToFailWith.UNRELIABLE_EXCEPTION), (RetryPolicy)RetryPolicies.failoverOnNetworkException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, (int)10, (long)1000L, (long)10000L));
        try {
            unreliable.failsIfIdentifierDoesntMatch("no-such-identifier");
            Assertions.fail((String)"Should have thrown *some* exception");
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IOException), (String)("Expected IOE but got " + e.getClass()));
        }
    }

    private static class ConcurrentMethodThread
    extends Thread {
        private UnreliableInterface unreliable;
        public String result;

        public ConcurrentMethodThread(UnreliableInterface unreliable) {
            this.unreliable = unreliable;
        }

        @Override
        public void run() {
            try {
                this.result = this.unreliable.failsIfIdentifierDoesntMatch("impl2");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class SynchronizedUnreliableImplementation
    extends UnreliableImplementation {
        private CountDownLatch methodLatch;

        public SynchronizedUnreliableImplementation(String identifier, UnreliableImplementation.TypeOfExceptionToFailWith exceptionToFailWith, int threadCount) {
            super(identifier, exceptionToFailWith);
            this.methodLatch = new CountDownLatch(threadCount);
        }

        @Override
        public String failsIfIdentifierDoesntMatch(String identifier) throws UnreliableInterface.UnreliableException, StandbyException, IOException {
            this.methodLatch.countDown();
            try {
                this.methodLatch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return super.failsIfIdentifierDoesntMatch(identifier);
        }
    }

    public static class FailOverOnceOnAnyExceptionPolicy
    implements RetryPolicy {
        public RetryPolicy.RetryAction shouldRetry(Exception e, int retries, int failovers, boolean isIdempotentOrAtMostOnce) {
            return failovers < 1 ? RetryPolicy.RetryAction.FAILOVER_AND_RETRY : RetryPolicy.RetryAction.FAIL;
        }
    }

    public static class FlipFlopProxyProvider<T>
    implements FailoverProxyProvider<T> {
        private Class<T> iface;
        private T currentlyActive;
        private T impl1;
        private T impl2;
        private int failoversOccurred = 0;

        public FlipFlopProxyProvider(Class<T> iface, T activeImpl, T standbyImpl) {
            this.iface = iface;
            this.impl1 = activeImpl;
            this.impl2 = standbyImpl;
            this.currentlyActive = this.impl1;
        }

        public FailoverProxyProvider.ProxyInfo<T> getProxy() {
            return new FailoverProxyProvider.ProxyInfo(this.currentlyActive, this.currentlyActive.toString());
        }

        public synchronized void performFailover(Object currentProxy) {
            this.currentlyActive = this.impl1 == currentProxy ? this.impl2 : this.impl1;
            ++this.failoversOccurred;
        }

        public Class<T> getInterface() {
            return this.iface;
        }

        public void close() throws IOException {
        }

        public int getFailoversOccurred() {
            return this.failoversOccurred;
        }
    }
}

