/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.retry;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.RpcNoSuchMethodException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestConnectionRetryPolicy {
    private static RetryPolicy getDefaultRetryPolicy(boolean defaultRetryPolicyEnabled, String defaultRetryPolicySpec, String remoteExceptionToRetry) {
        return TestConnectionRetryPolicy.getDefaultRetryPolicy(new Configuration(), defaultRetryPolicyEnabled, defaultRetryPolicySpec, remoteExceptionToRetry);
    }

    private static RetryPolicy getDefaultRetryPolicy(boolean defaultRetryPolicyEnabled, String defaultRetryPolicySpec) {
        return TestConnectionRetryPolicy.getDefaultRetryPolicy(new Configuration(), defaultRetryPolicyEnabled, defaultRetryPolicySpec, "");
    }

    public static RetryPolicy getDefaultRetryPolicy(Configuration conf, boolean defaultRetryPolicyEnabled, String defaultRetryPolicySpec, String remoteExceptionToRetry) {
        return RetryUtils.getDefaultRetryPolicy((Configuration)conf, (String)"org.apache.hadoop.io.retry.TestConnectionRetryPolicy.No.Such.Key", (boolean)defaultRetryPolicyEnabled, (String)"org.apache.hadoop.io.retry.TestConnectionRetryPolicy.No.Such.Key", (String)defaultRetryPolicySpec, (String)"");
    }

    @Test
    @Timeout(value=60L)
    public void testDefaultRetryPolicyEquivalence() {
        RetryPolicy rp1 = null;
        RetryPolicy rp2 = null;
        RetryPolicy rp3 = null;
        rp1 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "10000,2");
        rp2 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "10000,2");
        rp3 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "10000,2");
        this.verifyRetryPolicyEquivalence(new RetryPolicy[]{rp1, rp2, rp3});
        rp1 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "10000,2", new RemoteException(PathIOException.class.getName(), "path IO exception").getClassName());
        rp2 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "10000,2", new RemoteException(RpcNoSuchMethodException.class.getName(), "no such method exception").getClassName());
        rp3 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "10000,2", new RemoteException(RetriableException.class.getName(), "retriable exception").getClassName());
        this.verifyRetryPolicyEquivalence(new RetryPolicy[]{rp1, rp2, rp3});
        rp1 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "20000,3");
        rp2 = TestConnectionRetryPolicy.getDefaultRetryPolicy(true, "30000,4");
        Assertions.assertNotEquals((Object)rp1, (Object)rp2, (String)"should not be equal");
        Assertions.assertNotEquals((int)rp1.hashCode(), (int)rp2.hashCode(), (String)"should not have the same hash code");
        rp1 = TestConnectionRetryPolicy.getDefaultRetryPolicy(false, "40000,5");
        rp2 = TestConnectionRetryPolicy.getDefaultRetryPolicy(false, "40000,5");
        Assertions.assertEquals((Object)rp1, (Object)rp2, (String)"should be equal");
        Assertions.assertEquals((Object)rp1, (Object)rp2, (String)"should have the same hash code");
        rp1 = TestConnectionRetryPolicy.getDefaultRetryPolicy(false, "50000,6");
        rp2 = TestConnectionRetryPolicy.getDefaultRetryPolicy(false, "60000,7");
        Assertions.assertEquals((Object)rp1, (Object)rp2, (String)"should be equal");
        Assertions.assertEquals((Object)rp1, (Object)rp2, (String)"should have the same hash code");
    }

    public static RetryPolicy newTryOnceThenFail() {
        return new RetryPolicies.TryOnceThenFail();
    }

    @Test
    @Timeout(value=60L)
    public void testTryOnceThenFailEquivalence() throws Exception {
        RetryPolicy rp1 = TestConnectionRetryPolicy.newTryOnceThenFail();
        RetryPolicy rp2 = TestConnectionRetryPolicy.newTryOnceThenFail();
        RetryPolicy rp3 = TestConnectionRetryPolicy.newTryOnceThenFail();
        this.verifyRetryPolicyEquivalence(new RetryPolicy[]{rp1, rp2, rp3});
    }

    private void verifyRetryPolicyEquivalence(RetryPolicy[] polices) {
        for (int i = 0; i < polices.length; ++i) {
            for (int j = 0; j < polices.length; ++j) {
                if (i == j) continue;
                Assertions.assertEquals((Object)polices[i], (Object)polices[j], (String)"should be equal");
                Assertions.assertEquals((int)polices[i].hashCode(), (int)polices[j].hashCode(), (String)"should have the same hash code");
            }
        }
    }
}

