/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTFileSplit {
    private static String ROOT = GenericTestUtils.getTestDir().getAbsolutePath();
    private static final int BLOCK_SIZE = 65536;
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private FileSystem fs;
    private Configuration conf;
    private Path path;
    private Random random = new Random();
    private String comparator = "memcmp";
    private String outputFile = "TestTFileSplit";

    void createFile(int count, String compress) throws IOException {
        this.conf = new Configuration();
        this.path = new Path(ROOT, this.outputFile + "." + compress);
        this.fs = this.path.getFileSystem(this.conf);
        FSDataOutputStream out = this.fs.create(this.path);
        TFile.Writer writer = new TFile.Writer(out, 65536, compress, this.comparator, this.conf);
        for (int nx = 0; nx < count; ++nx) {
            byte[] key = TestTFileSplit.composeSortedKey(KEY, count, nx).getBytes();
            byte[] value = (VALUE + nx).getBytes();
            writer.append(key, value);
        }
        writer.close();
        out.close();
    }

    void readFile() throws IOException {
        long fileLength = this.fs.getFileStatus(this.path).getLen();
        int numSplit = 10;
        long splitSize = fileLength / (long)numSplit + 1L;
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        long offset = 0L;
        long rowCount = 0L;
        int i = 0;
        while (i < numSplit) {
            TFile.Reader.Scanner scanner = reader.createScannerByByteRange(offset, splitSize);
            int count = 0;
            BytesWritable key = new BytesWritable();
            BytesWritable value = new BytesWritable();
            while (!scanner.atEnd()) {
                scanner.entry().get(key, value);
                ++count;
                scanner.advance();
            }
            scanner.close();
            Assertions.assertTrue((count > 0 ? 1 : 0) != 0);
            rowCount += (long)count;
            ++i;
            offset += splitSize;
        }
        Assertions.assertEquals((long)rowCount, (long)reader.getEntryCount());
        reader.close();
    }

    void readRowSplits(int numSplits) throws IOException {
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), this.fs.getFileStatus(this.path).getLen(), this.conf);
        long totalRecords = reader.getEntryCount();
        for (int i = 0; i < numSplits; ++i) {
            long startRec = (long)i * totalRecords / (long)numSplits;
            long endRec = (long)(i + 1) * totalRecords / (long)numSplits;
            if (i == numSplits - 1) {
                endRec = totalRecords;
            }
            TFile.Reader.Scanner scanner = reader.createScannerByRecordNum(startRec, endRec);
            int count = 0;
            BytesWritable key = new BytesWritable();
            BytesWritable value = new BytesWritable();
            long x = startRec;
            while (!scanner.atEnd()) {
                Assertions.assertEquals((long)scanner.getRecordNum(), (long)x, (String)"Incorrect RecNum returned by scanner");
                scanner.entry().get(key, value);
                ++count;
                Assertions.assertEquals((long)scanner.getRecordNum(), (long)x, (String)"Incorrect RecNum returned by scanner");
                scanner.advance();
                ++x;
            }
            scanner.close();
            Assertions.assertTrue(((long)count == endRec - startRec ? 1 : 0) != 0);
        }
        TFile.Reader.Scanner scanner = reader.createScannerByRecordNum(totalRecords, -1L);
        Assertions.assertTrue((boolean)scanner.atEnd());
    }

    static String composeSortedKey(String prefix, int total, int value) {
        return String.format("%s%010d", prefix, value);
    }

    void checkRecNums() throws IOException {
        long i;
        long end;
        long fileLen = this.fs.getFileStatus(this.path).getLen();
        TFile.Reader reader = new TFile.Reader(this.fs.open(this.path), fileLen, this.conf);
        long totalRecs = reader.getEntryCount();
        long begin = this.random.nextLong() % (totalRecs / 2L);
        if (begin < 0L) {
            begin += totalRecs / 2L;
        }
        if ((end = this.random.nextLong() % (totalRecs / 2L)) < 0L) {
            end += totalRecs / 2L;
        }
        end += totalRecs / 2L + 1L;
        Assertions.assertEquals((long)0L, (long)reader.getRecordNumNear(0L), (String)"RecNum for offset=0 should be 0");
        for (long x : new long[]{fileLen, fileLen + 1L, 2L * fileLen}) {
            Assertions.assertEquals((long)totalRecs, (long)reader.getRecordNumNear(x), (String)"RecNum for offset>=fileLen should be total entries");
        }
        for (i = 0L; i < 100L; ++i) {
            Assertions.assertEquals((long)i, (long)reader.getRecordNumByLocation(reader.getLocationByRecordNum(i)), (String)"Locaton to RecNum conversion not symmetric");
        }
        for (i = 1L; i < 100L; ++i) {
            long x = totalRecs - i;
            Assertions.assertEquals((long)x, (long)reader.getRecordNumByLocation(reader.getLocationByRecordNum(x)), (String)"Locaton to RecNum conversion not symmetric");
        }
        for (i = begin; i < end; ++i) {
            Assertions.assertEquals((long)i, (long)reader.getRecordNumByLocation(reader.getLocationByRecordNum(i)), (String)"Locaton to RecNum conversion not symmetric");
        }
        for (int i2 = 0; i2 < 1000; ++i2) {
            long x = this.random.nextLong() % totalRecs;
            if (x < 0L) {
                x += totalRecs;
            }
            Assertions.assertEquals((long)x, (long)reader.getRecordNumByLocation(reader.getLocationByRecordNum(x)), (String)"Locaton to RecNum conversion not symmetric");
        }
    }

    @Test
    public void testSplit() throws IOException {
        System.out.println("testSplit");
        this.createFile(100000, Compression.Algorithm.NONE.getName());
        this.checkRecNums();
        this.readFile();
        this.readRowSplits(10);
        this.fs.delete(this.path, true);
        this.createFile(500000, Compression.Algorithm.GZ.getName());
        this.checkRecNums();
        this.readFile();
        this.readRowSplits(83);
        this.fs.delete(this.path, true);
    }
}

