/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.file.tfile.TFile;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTFileComparator2 {
    private static String ROOT = GenericTestUtils.getTestDir().getAbsolutePath();
    private static final String name = "test-tfile-comparator2";
    private static final int BLOCK_SIZE = 512;
    private static final String VALUE = "value";
    private static final String jClassLongWritableComparator = "jclass:" + LongWritable.Comparator.class.getName();
    private static final long NENTRY = 10000L;

    private static long cube(long n) {
        return n * n * n;
    }

    private static String buildValue(long i) {
        return String.format("%s-%d", VALUE, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSortedLongWritable() throws IOException {
        Configuration conf = new Configuration();
        Path path = new Path(ROOT, name);
        FileSystem fs = path.getFileSystem(conf);
        try (FSDataOutputStream out = fs.create(path);
             TFile.Writer writer = new TFile.Writer(out, 512, "gz", jClassLongWritableComparator, conf);){
            LongWritable key = new LongWritable(0L);
            for (long i = 0L; i < 10000L; ++i) {
                key.set(TestTFileComparator2.cube(i - 5000L));
                try (DataOutputStream dos = writer.prepareAppendKey(-1);){
                    key.write((DataOutput)dos);
                }
                dos = writer.prepareAppendValue(-1);
                try {
                    dos.write(TestTFileComparator2.buildValue(i).getBytes());
                    continue;
                }
                finally {
                    dos.close();
                }
            }
        }
        try (FSDataInputStream in = fs.open(path);
             TFile.Reader reader = new TFile.Reader(in, fs.getFileStatus(path).getLen(), conf);){
            TFile.Reader.Scanner scanner = reader.createScanner();
            long i = 0L;
            BytesWritable value = new BytesWritable();
            while (!scanner.atEnd()) {
                scanner.entry().getValue(value);
                Assertions.assertEquals((Object)TestTFileComparator2.buildValue(i), (Object)new String(value.getBytes(), 0, value.getLength()));
                ++i;
                scanner.advance();
            }
        }
    }
}

