/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import org.apache.hadoop.io.erasurecode.ErasureCodeNative;
import org.apache.hadoop.io.erasurecode.rawcoder.RawErasureCoderBenchmark;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestRawErasureCoderBenchmark {
    @Test
    public void testDummyCoder() throws Exception {
        RawErasureCoderBenchmark.performBench("encode", RawErasureCoderBenchmark.CODER.DUMMY_CODER, 2, 100, 1024);
        RawErasureCoderBenchmark.performBench("decode", RawErasureCoderBenchmark.CODER.DUMMY_CODER, 5, 150, 100);
    }

    @Test
    public void testLegacyRSCoder() throws Exception {
        RawErasureCoderBenchmark.performBench("encode", RawErasureCoderBenchmark.CODER.LEGACY_RS_CODER, 2, 80, 200);
        RawErasureCoderBenchmark.performBench("decode", RawErasureCoderBenchmark.CODER.LEGACY_RS_CODER, 5, 300, 350);
    }

    @Test
    public void testRSCoder() throws Exception {
        RawErasureCoderBenchmark.performBench("encode", RawErasureCoderBenchmark.CODER.RS_CODER, 3, 200, 200);
        RawErasureCoderBenchmark.performBench("decode", RawErasureCoderBenchmark.CODER.RS_CODER, 4, 135, 20);
    }

    @Test
    public void testISALCoder() throws Exception {
        Assumptions.assumeTrue((boolean)ErasureCodeNative.isNativeCodeLoaded());
        RawErasureCoderBenchmark.performBench("encode", RawErasureCoderBenchmark.CODER.ISAL_CODER, 5, 300, 64);
        RawErasureCoderBenchmark.performBench("decode", RawErasureCoderBenchmark.CODER.ISAL_CODER, 6, 200, 128);
    }
}

