/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.erasurecode.rawcoder;

import java.nio.ByteBuffer;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.io.erasurecode.rawcoder.CoderUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCoderUtil {
    private final int numInputs = 9;
    private final int chunkSize = 1024;

    @Test
    public void testGetEmptyChunk() {
        byte[] ret = CoderUtil.getEmptyChunk((int)1024);
        for (int i = 0; i < 1024; ++i) {
            Assertions.assertEquals((int)0, (int)ret[i]);
        }
    }

    @Test
    public void testResetBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(2048).putInt(1234);
        buf.position(0);
        ByteBuffer ret = CoderUtil.resetBuffer((ByteBuffer)buf, (int)1024);
        for (int i = 0; i < 1024; ++i) {
            Assertions.assertEquals((int)0, (int)ret.getInt(i));
        }
        byte[] inputs = ByteBuffer.allocate(9).putInt(1234).array();
        CoderUtil.resetBuffer((byte[])inputs, (int)0, (int)9);
        for (int i = 0; i < 9; ++i) {
            Assertions.assertEquals((int)0, (int)inputs[i]);
        }
    }

    @Test
    public void testGetValidIndexes() {
        byte[][] inputs = new byte[9][];
        inputs[0] = new byte[1024];
        inputs[1] = new byte[1024];
        inputs[7] = new byte[1024];
        inputs[8] = new byte[1024];
        int[] validIndexes = CoderUtil.getValidIndexes((Object[])inputs);
        Assertions.assertEquals((int)4, (int)validIndexes.length);
        Assertions.assertEquals((int)0, (int)validIndexes[0]);
        Assertions.assertEquals((int)1, (int)validIndexes[1]);
        Assertions.assertEquals((int)7, (int)validIndexes[2]);
        Assertions.assertEquals((int)8, (int)validIndexes[3]);
    }

    @Test
    public void testNoValidIndexes() {
        byte[][] inputs = new byte[9][];
        for (int i = 0; i < 9; ++i) {
            inputs[i] = null;
        }
        int[] validIndexes = CoderUtil.getValidIndexes((Object[])inputs);
        Assertions.assertEquals((int)0, (int)validIndexes.length);
    }

    @Test
    public void testGetNullIndexes() {
        byte[][] inputs = new byte[9][];
        inputs[0] = new byte[1024];
        inputs[1] = new byte[1024];
        for (int i = 2; i < 7; ++i) {
            inputs[i] = null;
        }
        inputs[7] = new byte[1024];
        inputs[8] = new byte[1024];
        int[] nullIndexes = CoderUtil.getNullIndexes((Object[])inputs);
        Assertions.assertEquals((int)2, (int)nullIndexes[0]);
        Assertions.assertEquals((int)3, (int)nullIndexes[1]);
        Assertions.assertEquals((int)4, (int)nullIndexes[2]);
        Assertions.assertEquals((int)5, (int)nullIndexes[3]);
        Assertions.assertEquals((int)6, (int)nullIndexes[4]);
    }

    @Test
    public void testFindFirstValidInput() {
        byte[][] inputs = new byte[9][];
        inputs[8] = ByteBuffer.allocate(4).putInt(1234).array();
        byte[] firstValidInput = (byte[])CoderUtil.findFirstValidInput((Object[])inputs);
        Assertions.assertEquals((Object)firstValidInput, (Object)inputs[8]);
    }

    @Test
    public void testNoValidInput() {
        Assertions.assertThrows(HadoopIllegalArgumentException.class, () -> {
            byte[][] inputs = new byte[9][];
            CoderUtil.findFirstValidInput((Object[])inputs);
        });
    }
}

