/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.lz4;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.lz4.Lz4Compressor;
import org.apache.hadoop.io.compress.lz4.Lz4Decompressor;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLz4CompressorDecompressor {
    private static final Random rnd = new Random(12345L);

    @Test
    public void testCompressorSetInputNullPointerException() {
        try {
            Lz4Compressor compressor = new Lz4Compressor();
            compressor.setInput(null, 0, 10);
            Assertions.fail((String)"testCompressorSetInputNullPointerException error !!!");
        }
        catch (NullPointerException compressor) {
        }
        catch (Exception e) {
            Assertions.fail((String)"testCompressorSetInputNullPointerException ex error !!!");
        }
    }

    @Test
    public void testDecompressorSetInputNullPointerException() {
        try {
            Lz4Decompressor decompressor = new Lz4Decompressor();
            decompressor.setInput(null, 0, 10);
            Assertions.fail((String)"testDecompressorSetInputNullPointerException error !!!");
        }
        catch (NullPointerException decompressor) {
        }
        catch (Exception e) {
            Assertions.fail((String)"testDecompressorSetInputNullPointerException ex error !!!");
        }
    }

    @Test
    public void testCompressorSetInputAIOBException() {
        try {
            Lz4Compressor compressor = new Lz4Compressor();
            compressor.setInput(new byte[0], -5, 10);
            Assertions.fail((String)"testCompressorSetInputAIOBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException compressor) {
        }
        catch (Exception ex) {
            Assertions.fail((String)"testCompressorSetInputAIOBException ex error !!!");
        }
    }

    @Test
    public void testDecompressorSetInputAIOUBException() {
        try {
            Lz4Decompressor decompressor = new Lz4Decompressor();
            decompressor.setInput(new byte[0], -5, 10);
            Assertions.fail((String)"testDecompressorSetInputAIOBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException decompressor) {
        }
        catch (Exception e) {
            Assertions.fail((String)"testDecompressorSetInputAIOBException ex error !!!");
        }
    }

    @Test
    public void testCompressorCompressNullPointerException() {
        try {
            Lz4Compressor compressor = new Lz4Compressor();
            byte[] bytes = TestLz4CompressorDecompressor.generate(6144);
            compressor.setInput(bytes, 0, bytes.length);
            compressor.compress(null, 0, 0);
            Assertions.fail((String)"testCompressorCompressNullPointerException error !!!");
        }
        catch (NullPointerException compressor) {
        }
        catch (Exception e) {
            Assertions.fail((String)"testCompressorCompressNullPointerException ex error !!!");
        }
    }

    @Test
    public void testDecompressorCompressNullPointerException() {
        try {
            Lz4Decompressor decompressor = new Lz4Decompressor();
            byte[] bytes = TestLz4CompressorDecompressor.generate(6144);
            decompressor.setInput(bytes, 0, bytes.length);
            decompressor.decompress(null, 0, 0);
            Assertions.fail((String)"testDecompressorCompressNullPointerException error !!!");
        }
        catch (NullPointerException decompressor) {
        }
        catch (Exception e) {
            Assertions.fail((String)"testDecompressorCompressNullPointerException ex error !!!");
        }
    }

    @Test
    public void testCompressorCompressAIOBException() {
        try {
            Lz4Compressor compressor = new Lz4Compressor();
            byte[] bytes = TestLz4CompressorDecompressor.generate(6144);
            compressor.setInput(bytes, 0, bytes.length);
            compressor.compress(new byte[0], 0, -1);
            Assertions.fail((String)"testCompressorCompressAIOBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException compressor) {
        }
        catch (Exception e) {
            Assertions.fail((String)"testCompressorCompressAIOBException ex error !!!");
        }
    }

    @Test
    public void testDecompressorCompressAIOBException() {
        try {
            Lz4Decompressor decompressor = new Lz4Decompressor();
            byte[] bytes = TestLz4CompressorDecompressor.generate(6144);
            decompressor.setInput(bytes, 0, bytes.length);
            decompressor.decompress(new byte[0], 0, -1);
            Assertions.fail((String)"testDecompressorCompressAIOBException error !!!");
        }
        catch (ArrayIndexOutOfBoundsException decompressor) {
        }
        catch (Exception e) {
            Assertions.fail((String)"testDecompressorCompressAIOBException ex error !!!");
        }
    }

    @Test
    public void testSetInputWithBytesSizeMoreThenDefaultLz4CompressorByfferSize() {
        int BYTES_SIZE = 65537;
        try {
            Lz4Compressor compressor = new Lz4Compressor();
            byte[] bytes = TestLz4CompressorDecompressor.generate(BYTES_SIZE);
            Assertions.assertTrue((boolean)compressor.needsInput(), (String)"needsInput error !!!");
            compressor.setInput(bytes, 0, bytes.length);
            byte[] emptyBytes = new byte[BYTES_SIZE];
            int csize = compressor.compress(emptyBytes, 0, bytes.length);
            Assertions.assertTrue((csize != 0 ? 1 : 0) != 0, (String)"testSetInputWithBytesSizeMoreThenDefaultLz4CompressorByfferSize error !!!");
        }
        catch (Exception ex) {
            Assertions.fail((String)"testSetInputWithBytesSizeMoreThenDefaultLz4CompressorByfferSize ex error !!!");
        }
    }

    @Test
    public void testCompressDecompress() {
        int BYTE_SIZE = 55296;
        byte[] bytes = TestLz4CompressorDecompressor.generate(BYTE_SIZE);
        Lz4Compressor compressor = new Lz4Compressor();
        try {
            compressor.setInput(bytes, 0, bytes.length);
            Assertions.assertTrue((compressor.getBytesRead() > 0L ? 1 : 0) != 0, (String)"Lz4CompressDecompress getBytesRead error !!!");
            Assertions.assertTrue((compressor.getBytesWritten() == 0L ? 1 : 0) != 0, (String)"Lz4CompressDecompress getBytesWritten before compress error !!!");
            byte[] compressed = new byte[BYTE_SIZE];
            int cSize = compressor.compress(compressed, 0, compressed.length);
            Assertions.assertTrue((compressor.getBytesWritten() > 0L ? 1 : 0) != 0, (String)"Lz4CompressDecompress getBytesWritten after compress error !!!");
            Lz4Decompressor decompressor = new Lz4Decompressor();
            decompressor.setInput(compressed, 0, cSize);
            byte[] decompressed = new byte[BYTE_SIZE];
            decompressor.decompress(decompressed, 0, decompressed.length);
            Assertions.assertTrue((boolean)decompressor.finished(), (String)"testLz4CompressDecompress finished error !!!");
            Assertions.assertArrayEquals((byte[])bytes, (byte[])decompressed);
            compressor.reset();
            decompressor.reset();
            Assertions.assertTrue((decompressor.getRemaining() == 0 ? 1 : 0) != 0, (String)"decompressor getRemaining error !!!");
        }
        catch (Exception e) {
            Assertions.fail((String)"testLz4CompressDecompress ex error!!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressorDecompressorEmptyStreamLogic() {
        ByteArrayInputStream bytesIn = null;
        ByteArrayOutputStream bytesOut = null;
        byte[] buf = null;
        BlockDecompressorStream blockDecompressorStream = null;
        try {
            bytesOut = new ByteArrayOutputStream();
            BlockCompressorStream blockCompressorStream = new BlockCompressorStream((OutputStream)bytesOut, (Compressor)new Lz4Compressor(), 1024, 0);
            blockCompressorStream.close();
            buf = bytesOut.toByteArray();
            Assertions.assertEquals((int)4, (int)buf.length, (String)"empty stream compressed output size != 4");
            bytesIn = new ByteArrayInputStream(buf);
            blockDecompressorStream = new BlockDecompressorStream((InputStream)bytesIn, (Decompressor)new Lz4Decompressor(), 1024);
            Assertions.assertEquals((int)-1, (int)blockDecompressorStream.read(), (String)"return value is not -1");
        }
        catch (Exception e) {
            Assertions.fail((String)("testCompressorDecompressorEmptyStreamLogic ex error !!!" + e.getMessage()));
        }
        finally {
            if (blockDecompressorStream != null) {
                try {
                    bytesIn.close();
                    bytesOut.close();
                    blockDecompressorStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressorDecopressorLogicWithCompressionStreams() {
        FilterOutputStream deflateOut = null;
        FilterInputStream inflateIn = null;
        int BYTE_SIZE = 102400;
        byte[] bytes = TestLz4CompressorDecompressor.generate(BYTE_SIZE);
        int bufferSize = 262144;
        int compressionOverhead = bufferSize / 6 + 32;
        try {
            DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
            BlockCompressorStream deflateFilter = new BlockCompressorStream((OutputStream)compressedDataBuffer, (Compressor)new Lz4Compressor(bufferSize), bufferSize, compressionOverhead);
            deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));
            ((DataOutputStream)deflateOut).write(bytes, 0, bytes.length);
            ((DataOutputStream)deflateOut).flush();
            deflateFilter.finish();
            DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
            deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
            BlockDecompressorStream inflateFilter = new BlockDecompressorStream((InputStream)deCompressedDataBuffer, (Decompressor)new Lz4Decompressor(bufferSize), bufferSize);
            inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));
            byte[] result = new byte[BYTE_SIZE];
            ((DataInputStream)inflateIn).read(result);
            Assertions.assertArrayEquals((byte[])result, (byte[])bytes, (String)"original array not equals compress/decompressed array");
        }
        catch (IOException e) {
            Assertions.fail((String)"testLz4CompressorDecopressorLogicWithCompressionStreams ex error !!!");
        }
        finally {
            try {
                if (deflateOut != null) {
                    deflateOut.close();
                }
                if (inflateIn != null) {
                    inflateIn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static byte[] generate(int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (byte)rnd.nextInt(16);
        }
        return array;
    }

    @Test
    public void testLz4CompressDecompressInMultiThreads() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 10; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    TestLz4CompressorDecompressor.this.testCompressDecompress();
                }
            });
        }
        ctx.startThreads();
        ctx.waitFor(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLz4Compatibility() throws Exception {
        Path filePath = new Path(TestLz4CompressorDecompressor.class.getResource("/lz4/sequencefile").toURI());
        Configuration conf = new Configuration();
        conf.setInt("io.seqfile.compress.blocksize", 1000);
        FileSystem fs = FileSystem.get((Configuration)conf);
        int lines = 2000;
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, filePath, conf);
        Writable key = (Writable)reader.getKeyClass().newInstance();
        Writable value = (Writable)reader.getValueClass().newInstance();
        int lc = 0;
        try {
            while (reader.next(key, value)) {
                Assertions.assertEquals((Object)("key" + lc), (Object)key.toString());
                Assertions.assertEquals((Object)("value" + lc), (Object)value.toString());
                ++lc;
            }
        }
        finally {
            reader.close();
        }
        Assertions.assertEquals((int)lines, (int)lc);
    }
}

