/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.bzip2;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.bzip2.Bzip2Compressor;
import org.apache.hadoop.io.compress.bzip2.Bzip2Decompressor;
import org.apache.hadoop.io.compress.bzip2.Bzip2Factory;
import org.apache.hadoop.test.MultithreadedTestUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestBzip2CompressorDecompressor {
    private static final Random rnd = new Random(12345L);

    @BeforeEach
    public void before() {
        Assumptions.assumeTrue((boolean)Bzip2Factory.isNativeBzip2Loaded((Configuration)new Configuration()));
    }

    @Test
    public void testCompressDecompress() {
        byte[] rawData = null;
        int rawDataSize = 0;
        rawDataSize = 65536;
        rawData = TestBzip2CompressorDecompressor.generate(rawDataSize);
        try {
            Bzip2Compressor compressor = new Bzip2Compressor();
            Bzip2Decompressor decompressor = new Bzip2Decompressor();
            Assertions.assertFalse((boolean)compressor.finished(), (String)"testBzip2CompressDecompress finished error");
            compressor.setInput(rawData, 0, rawData.length);
            Assertions.assertTrue((compressor.getBytesRead() == 0L ? 1 : 0) != 0, (String)"testBzip2CompressDecompress getBytesRead before error");
            compressor.finish();
            byte[] compressedResult = new byte[rawDataSize];
            int cSize = compressor.compress(compressedResult, 0, rawDataSize);
            Assertions.assertTrue((compressor.getBytesRead() == (long)rawDataSize ? 1 : 0) != 0, (String)"testBzip2CompressDecompress getBytesRead after error");
            Assertions.assertTrue((cSize < rawDataSize ? 1 : 0) != 0, (String)"testBzip2CompressDecompress compressed size no less than original size");
            decompressor.setInput(compressedResult, 0, cSize);
            byte[] decompressedBytes = new byte[rawDataSize];
            decompressor.decompress(decompressedBytes, 0, decompressedBytes.length);
            Assertions.assertArrayEquals((byte[])rawData, (byte[])decompressedBytes, (String)"testBzip2CompressDecompress arrays not equals ");
            compressor.reset();
            decompressor.reset();
        }
        catch (IOException ex) {
            Assertions.fail((String)("testBzip2CompressDecompress ex !!!" + ex));
        }
    }

    public static byte[] generate(int size) {
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (byte)rnd.nextInt(16);
        }
        return array;
    }

    @Test
    public void testBzip2CompressDecompressInMultiThreads() throws Exception {
        MultithreadedTestUtil.TestContext ctx = new MultithreadedTestUtil.TestContext();
        for (int i = 0; i < 10; ++i) {
            ctx.addThread(new MultithreadedTestUtil.TestingThread(ctx){

                @Override
                public void doWork() throws Exception {
                    TestBzip2CompressorDecompressor.this.testCompressDecompress();
                }
            });
        }
        ctx.startThreads();
        ctx.waitFor(60000L);
    }
}

