/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.io.compress.SnappyCodec;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.io.compress.ZStandardCodec;
import org.apache.hadoop.io.compress.bzip2.Bzip2Factory;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipCompressor;
import org.apache.hadoop.io.compress.zlib.BuiltInGzipDecompressor;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibDeflater;
import org.apache.hadoop.io.compress.zlib.BuiltInZlibInflater;
import org.apache.hadoop.io.compress.zlib.ZlibCompressor;
import org.apache.hadoop.io.compress.zlib.ZlibFactory;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.LineReader;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCodec {
    private static final Logger LOG = LoggerFactory.getLogger(TestCodec.class);
    private Configuration conf = new Configuration();
    private int count = 10000;
    private int seed = new Random().nextInt();

    @AfterEach
    public void after() {
        ZlibFactory.loadNativeZLib();
    }

    @Test
    public void testDefaultCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.DefaultCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.DefaultCodec");
    }

    @Test
    public void testGzipCodec() throws IOException {
        Configuration conf = new Configuration();
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.GzipCodec");
            TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
        }
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.GzipCodec");
        TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
    }

    @Test
    @Timeout(value=20L)
    public void testBZip2Codec() throws IOException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "java-builtin");
        TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.BZip2Codec");
        TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
    }

    @Test
    @Timeout(value=20L)
    public void testBZip2NativeCodec() throws IOException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "system-native");
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            if (Bzip2Factory.isNativeBzip2Loaded((Configuration)conf)) {
                TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.BZip2Codec");
                TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
                conf.set("io.compression.codec.bzip2.library", "java-builtin");
                TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.BZip2Codec");
                TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.BZip2Codec");
            } else {
                LOG.warn("Native hadoop library available but native bzip2 is not");
            }
        }
    }

    @Test
    public void testSnappyCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.SnappyCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.SnappyCodec");
    }

    @Test
    public void testLz4Codec() throws IOException {
        this.conf.setBoolean("io.compression.codec.lz4.use.lz4hc", false);
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.Lz4Codec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.Lz4Codec");
        this.conf.setBoolean("io.compression.codec.lz4.use.lz4hc", true);
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.Lz4Codec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.Lz4Codec");
    }

    @Test
    public void testDeflateCodec() throws IOException {
        TestCodec.codecTest(this.conf, this.seed, 0, "org.apache.hadoop.io.compress.DeflateCodec");
        TestCodec.codecTest(this.conf, this.seed, this.count, "org.apache.hadoop.io.compress.DeflateCodec");
    }

    @Test
    public void testGzipCodecWithParam() throws IOException {
        Configuration conf = new Configuration(this.conf);
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.BEST_COMPRESSION);
        ZlibFactory.setCompressionStrategy((Configuration)conf, (ZlibCompressor.CompressionStrategy)ZlibCompressor.CompressionStrategy.HUFFMAN_ONLY);
        TestCodec.codecTest(conf, this.seed, 0, "org.apache.hadoop.io.compress.GzipCodec");
        TestCodec.codecTest(conf, this.seed, this.count, "org.apache.hadoop.io.compress.GzipCodec");
    }

    private static void codecTest(Configuration conf, int seed, int count, String codecClass) throws IOException {
        Throwable throwable;
        CompressionCodec codec = null;
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(codecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        LOG.info("Created a Codec object of type: " + codecClass);
        DataOutputBuffer data = new DataOutputBuffer();
        RandomDatum.Generator generator = new RandomDatum.Generator(seed);
        for (int i = 0; i < count; ++i) {
            generator.next();
            RandomDatum key = generator.getKey();
            RandomDatum value = generator.getValue();
            key.write((DataOutput)data);
            value.write((DataOutput)data);
        }
        LOG.info("Generated " + count + " records");
        DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
        int leasedCompressorsBefore = codec.getCompressorType() == null ? -1 : CodecPool.getLeasedCompressorsCount((CompressionCodec)codec);
        try (CompressionOutputStream deflateFilter = codec.createOutputStream((OutputStream)compressedDataBuffer);
             DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream((OutputStream)deflateFilter));){
            deflateOut.write(data.getData(), 0, data.getLength());
            deflateOut.flush();
            deflateFilter.finish();
        }
        if (leasedCompressorsBefore > -1) {
            org.junit.jupiter.api.Assertions.assertEquals((int)leasedCompressorsBefore, (int)CodecPool.getLeasedCompressorsCount((CompressionCodec)codec), (String)"leased compressor not returned to the codec pool");
        }
        LOG.info("Finished compressing data");
        DataInputBuffer deCompressedDataBuffer = new DataInputBuffer();
        deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
        DataInputBuffer originalData = new DataInputBuffer();
        int leasedDecompressorsBefore = CodecPool.getLeasedDecompressorsCount((CompressionCodec)codec);
        try (CompressionInputStream inflateFilter = codec.createInputStream((InputStream)deCompressedDataBuffer);){
            throwable = null;
            try (DataInputStream inflateIn = new DataInputStream(new BufferedInputStream((InputStream)inflateFilter));){
                originalData.reset(data.getData(), 0, data.getLength());
                DataInputStream originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));
                for (int i = 0; i < count; ++i) {
                    RandomDatum k1 = new RandomDatum();
                    RandomDatum v1 = new RandomDatum();
                    k1.readFields(originalIn);
                    v1.readFields(originalIn);
                    RandomDatum k2 = new RandomDatum();
                    RandomDatum v2 = new RandomDatum();
                    k2.readFields(inflateIn);
                    v2.readFields(inflateIn);
                    org.junit.jupiter.api.Assertions.assertTrue((k1.equals(k2) && v1.equals(v2) ? 1 : 0) != 0, (String)"original and compressed-then-decompressed-output not equal");
                    HashMap<RandomDatum, String> m = new HashMap<RandomDatum, String>();
                    m.put(k1, k1.toString());
                    m.put(v1, v1.toString());
                    String result = (String)m.get(k2);
                    org.junit.jupiter.api.Assertions.assertEquals((Object)result, (Object)k1.toString(), (String)"k1 and k2 hashcode not equal");
                    result = (String)m.get(v2);
                    org.junit.jupiter.api.Assertions.assertEquals((Object)result, (Object)v1.toString(), (String)"v1 and v2 hashcode not equal");
                }
            }
            catch (Throwable originalIn) {
                throwable = originalIn;
                throw originalIn;
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)leasedDecompressorsBefore, (int)CodecPool.getLeasedDecompressorsCount((CompressionCodec)codec), (String)"leased decompressor not returned to the codec pool");
        originalData.reset(data.getData(), 0, data.getLength());
        deCompressedDataBuffer.reset(compressedDataBuffer.getData(), 0, compressedDataBuffer.getLength());
        inflateFilter = codec.createInputStream((InputStream)deCompressedDataBuffer);
        var13_21 = null;
        try {
            throwable = null;
            try (DataInputStream originalIn = new DataInputStream(new BufferedInputStream((InputStream)originalData));){
                int expected;
                do {
                    expected = originalIn.read();
                    org.junit.jupiter.api.Assertions.assertEquals((int)expected, (int)inflateFilter.read(), (String)"Inflated stream read by byte does not match");
                } while (expected != -1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            var13_21 = throwable3;
            throw throwable3;
        }
        finally {
            if (inflateFilter != null) {
                if (var13_21 != null) {
                    try {
                        inflateFilter.close();
                    }
                    catch (Throwable throwable4) {
                        var13_21.addSuppressed(throwable4);
                    }
                } else {
                    inflateFilter.close();
                }
            }
        }
        LOG.info("SUCCESS! Completed checking " + count + " records");
    }

    @Test
    public void testSplitableCodecs() throws Exception {
        this.testSplitableCodec(BZip2Codec.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSplitableCodec(Class<? extends SplittableCompressionCodec> codecClass) throws IOException {
        long DEFLBYTES = 0x200000L;
        Configuration conf = new Configuration();
        Random rand = new Random();
        long seed = rand.nextLong();
        LOG.info("seed: " + seed);
        rand.setSeed(seed);
        SplittableCompressionCodec codec = (SplittableCompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)conf);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FileStatus infile = fs.getFileStatus(TestCodec.writeSplitTestFile((FileSystem)fs, rand, (CompressionCodec)codec, 0x200000L));
        if (infile.getLen() > Integer.MAX_VALUE) {
            org.junit.jupiter.api.Assertions.fail((String)("Unexpected compression: 2097152 -> " + infile.getLen()));
        }
        int flen = (int)infile.getLen();
        Text line = new Text();
        Decompressor dcmp = CodecPool.getDecompressor((CompressionCodec)codec);
        try {
            int pos = 0;
            while ((long)pos < infile.getLen()) {
                SplitCompressionInputStream in = codec.createInputStream((InputStream)fs.open(infile.getPath()), dcmp, (long)pos, (long)flen, SplittableCompressionCodec.READ_MODE.BYBLOCK);
                if (in.getAdjustedStart() >= (long)flen) {
                    break;
                }
                LOG.info("SAMPLE " + in.getAdjustedStart() + "," + in.getAdjustedEnd());
                LineReader lreader = new LineReader((InputStream)in);
                lreader.readLine(line);
                if (in.getPos() >= (long)flen) {
                    break;
                }
                lreader.readLine(line);
                int seq1 = TestCodec.readLeadingInt(line);
                lreader.readLine(line);
                if (in.getPos() >= (long)flen) {
                    break;
                }
                int seq2 = TestCodec.readLeadingInt(line);
                org.junit.jupiter.api.Assertions.assertEquals((int)(seq1 + 1), (int)seq2, (String)"Mismatched lines");
                pos += rand.nextInt(flen / 8);
            }
        }
        finally {
            CodecPool.returnDecompressor((Decompressor)dcmp);
        }
        fs.delete(infile.getPath().getParent(), true);
    }

    private static int readLeadingInt(Text txt) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(txt.getBytes()));
        return in.readInt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path writeSplitTestFile(FileSystem fs, Random rand, CompressionCodec codec, long infLen) throws IOException {
        int REC_SIZE = 1024;
        Path wd = new Path(GenericTestUtils.getTempPath(codec.getClass().getSimpleName())).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Path file = new Path(wd, "test" + codec.getDefaultExtension());
        byte[] b = new byte[1024];
        Base64 b64 = new Base64(0, null);
        Compressor cmp = CodecPool.getCompressor((CompressionCodec)codec);
        try (DataOutputStream fout = new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fs.create(file, true), cmp));){
            DataOutputBuffer dob = new DataOutputBuffer(1369);
            int seq = 0;
            while (infLen > 0L) {
                rand.nextBytes(b);
                byte[] b64enc = b64.encode(b);
                dob.reset();
                dob.writeInt(seq);
                System.arraycopy(dob.getData(), 0, b64enc, 0, dob.getLength());
                fout.write(b64enc);
                fout.write(10);
                ++seq;
                infLen -= (long)b64enc.length;
            }
            LOG.info("Wrote " + seq + " records to " + file);
        }
        finally {
            CodecPool.returnCompressor((Compressor)cmp);
        }
        return file;
    }

    @Test
    public void testCodecPoolGzipReuse() throws Exception {
        Configuration conf = new Configuration();
        Assumptions.assumeTrue((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        GzipCodec gzc = (GzipCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        DefaultCodec dfc = (DefaultCodec)ReflectionUtils.newInstance(DefaultCodec.class, (Configuration)conf);
        Compressor c1 = CodecPool.getCompressor((CompressionCodec)gzc);
        Compressor c2 = CodecPool.getCompressor((CompressionCodec)dfc);
        CodecPool.returnCompressor((Compressor)c1);
        CodecPool.returnCompressor((Compressor)c2);
        org.junit.jupiter.api.Assertions.assertTrue((c2 != CodecPool.getCompressor((CompressionCodec)gzc) ? 1 : 0) != 0, (String)"Got mismatched ZlibCompressor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gzipReinitTest(Configuration conf, CompressionCodec codec) throws IOException {
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.BEST_COMPRESSION);
        ZlibFactory.setCompressionStrategy((Configuration)conf, (ZlibCompressor.CompressionStrategy)ZlibCompressor.CompressionStrategy.DEFAULT_STRATEGY);
        Compressor c1 = CodecPool.getCompressor((CompressionCodec)codec);
        CodecPool.returnCompressor((Compressor)c1);
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.NO_COMPRESSION);
        Compressor c2 = CodecPool.getCompressor((CompressionCodec)codec, (Configuration)conf);
        org.junit.jupiter.api.Assertions.assertTrue((c1 == c2 ? 1 : 0) != 0, (String)"Got mismatched ZlibCompressor");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CompressionOutputStream cos = null;
        byte[] b = new byte[32768];
        Arrays.fill(b, (byte)43);
        try {
            cos = codec.createOutputStream((OutputStream)bos, c2);
            cos.write(b);
        }
        finally {
            if (cos != null) {
                cos.close();
            }
            CodecPool.returnCompressor((Compressor)c2);
        }
        byte[] outbytes = bos.toByteArray();
        org.junit.jupiter.api.Assertions.assertTrue((outbytes.length >= b.length ? 1 : 0) != 0, (String)"Compressed bytes contrary to configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void codecTestWithNOCompression(Configuration conf, String codecClass) throws IOException {
        CompressionCodec codec = null;
        ZlibFactory.setCompressionLevel((Configuration)conf, (ZlibCompressor.CompressionLevel)ZlibCompressor.CompressionLevel.NO_COMPRESSION);
        try {
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)conf.getClassByName(codecClass), (Configuration)conf);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException("Illegal codec!");
        }
        Compressor c = codec.createCompressor();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CompressionOutputStream cos = null;
        byte[] b = new byte[32768];
        Arrays.fill(b, (byte)43);
        try {
            cos = codec.createOutputStream((OutputStream)bos, c);
            cos.write(b);
        }
        finally {
            if (cos != null) {
                cos.close();
            }
        }
        byte[] outbytes = bos.toByteArray();
        org.junit.jupiter.api.Assertions.assertTrue((outbytes.length >= b.length ? 1 : 0) != 0, (String)"Compressed bytes contrary to configuration(NO_COMPRESSION)");
    }

    @Test
    public void testCodecInitWithCompressionLevel() throws Exception {
        Configuration conf = new Configuration();
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            LOG.info("testCodecInitWithCompressionLevel with native");
            TestCodec.codecTestWithNOCompression(conf, "org.apache.hadoop.io.compress.GzipCodec");
            TestCodec.codecTestWithNOCompression(conf, "org.apache.hadoop.io.compress.DefaultCodec");
        }
        conf = new Configuration();
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        LOG.info("testCodecInitWithCompressionLevel without native libs");
        TestCodec.codecTestWithNOCompression(conf, "org.apache.hadoop.io.compress.DefaultCodec");
        TestCodec.codecTestWithNOCompression(conf, "org.apache.hadoop.io.compress.GzipCodec");
    }

    @Test
    public void testCodecPoolCompressorReinit() throws Exception {
        Configuration conf = new Configuration();
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            GzipCodec gzc = (GzipCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
            TestCodec.gzipReinitTest(conf, (CompressionCodec)gzc);
        } else {
            LOG.warn("testCodecPoolCompressorReinit skipped: native libs not loaded");
        }
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        DefaultCodec dfc = (DefaultCodec)ReflectionUtils.newInstance(DefaultCodec.class, (Configuration)conf);
        TestCodec.gzipReinitTest(conf, (CompressionCodec)dfc);
    }

    @Test
    public void testSequenceFileDefaultCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestCodec.sequenceFileCodecTest(this.conf, 100, "org.apache.hadoop.io.compress.DefaultCodec", 100);
        TestCodec.sequenceFileCodecTest(this.conf, 200000, "org.apache.hadoop.io.compress.DefaultCodec", 1000000);
    }

    @Test
    @Timeout(value=20L)
    public void testSequenceFileBZip2Codec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "java-builtin");
        TestCodec.sequenceFileCodecTest(conf, 0, "org.apache.hadoop.io.compress.BZip2Codec", 100);
        TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.BZip2Codec", 100);
        TestCodec.sequenceFileCodecTest(conf, 200000, "org.apache.hadoop.io.compress.BZip2Codec", 1000000);
    }

    @Test
    @Timeout(value=20L)
    public void testSequenceFileZStandardCodec() throws Exception {
        Assumptions.assumeTrue((boolean)ZStandardCodec.isNativeCodeLoaded());
        Configuration conf = new Configuration();
        TestCodec.sequenceFileCodecTest(conf, 0, "org.apache.hadoop.io.compress.ZStandardCodec", 100);
        TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.ZStandardCodec", 100);
        TestCodec.sequenceFileCodecTest(conf, 200000, "org.apache.hadoop.io.compress.ZStandardCodec", 1000000);
    }

    @Test
    @Timeout(value=20L)
    public void testSequenceFileBZip2NativeCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Configuration conf = new Configuration();
        conf.set("io.compression.codec.bzip2.library", "system-native");
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            if (Bzip2Factory.isNativeBzip2Loaded((Configuration)conf)) {
                TestCodec.sequenceFileCodecTest(conf, 0, "org.apache.hadoop.io.compress.BZip2Codec", 100);
                TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.BZip2Codec", 100);
                TestCodec.sequenceFileCodecTest(conf, 200000, "org.apache.hadoop.io.compress.BZip2Codec", 1000000);
            } else {
                LOG.warn("Native hadoop library available but native bzip2 is not");
            }
        }
    }

    @Test
    public void testSequenceFileDeflateCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        TestCodec.sequenceFileCodecTest(this.conf, 100, "org.apache.hadoop.io.compress.DeflateCodec", 100);
        TestCodec.sequenceFileCodecTest(this.conf, 200000, "org.apache.hadoop.io.compress.DeflateCodec", 1000000);
    }

    @Test
    public void testSequenceFileGzipCodec() throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Configuration conf = new Configuration();
        if (ZlibFactory.isNativeZlibLoaded((Configuration)conf)) {
            TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.GzipCodec", 5);
            TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.GzipCodec", 100);
            TestCodec.sequenceFileCodecTest(conf, 200000, "org.apache.hadoop.io.compress.GzipCodec", 1000000);
        }
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.GzipCodec", 5);
        TestCodec.sequenceFileCodecTest(conf, 100, "org.apache.hadoop.io.compress.GzipCodec", 100);
        TestCodec.sequenceFileCodecTest(conf, 200000, "org.apache.hadoop.io.compress.GzipCodec", 1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sequenceFileCodecTest(Configuration conf, int lines, String codecClass, int blockSize) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Writable value;
        Text key;
        Path filePath = new Path("SequenceFileCodecTest." + codecClass);
        conf.setInt("io.seqfile.compress.blocksize", blockSize);
        FileSystem fs = FileSystem.get((Configuration)conf);
        LOG.info("Creating SequenceFile with codec \"" + codecClass + "\"");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)filePath, Text.class, Text.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)((CompressionCodec)Class.forName(codecClass).newInstance()));
        LOG.info("Writing to SequenceFile...");
        for (int i = 0; i < lines; ++i) {
            key = new Text("key" + i);
            value = new Text("value" + i);
            writer.append((Writable)key, value);
        }
        writer.close();
        LOG.info("Reading from the SequenceFile...");
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, filePath, conf);
        key = (Writable)reader.getKeyClass().newInstance();
        value = (Writable)reader.getValueClass().newInstance();
        int lc = 0;
        try {
            while (reader.next((Writable)key, value)) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)("key" + lc), (Object)key.toString());
                org.junit.jupiter.api.Assertions.assertEquals((Object)("value" + lc), (Object)value.toString());
                ++lc;
            }
        }
        finally {
            reader.close();
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)lines, (int)lc);
        fs.delete(filePath, false);
        LOG.info("SUCCESS! Completed SequenceFileCodecTest with codec \"" + codecClass + "\"");
    }

    @Test
    public void testSnappyMapFile() throws Exception {
        this.codecTestMapFile(SnappyCodec.class, SequenceFile.CompressionType.BLOCK, 100);
    }

    private void codecTestMapFile(Class<? extends CompressionCodec> clazz, SequenceFile.CompressionType type, int records) throws Exception {
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        LOG.info("Creating MapFiles with " + records + " records using codec " + clazz.getSimpleName());
        Path path = new Path(GenericTestUtils.getTempPath(clazz.getSimpleName() + "-" + type + "-" + records));
        LOG.info("Writing " + path);
        TestCodec.createMapFile(this.conf, fs, path, clazz.newInstance(), type, records);
        MapFile.Reader reader = new MapFile.Reader(path, this.conf, new SequenceFile.Reader.Option[0]);
        Text key1 = new Text("002");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)reader.get((WritableComparable)key1, (Writable)new Text()));
        Text key2 = new Text("004");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)reader.get((WritableComparable)key2, (Writable)new Text()));
    }

    private static void createMapFile(Configuration conf, FileSystem fs, Path path, CompressionCodec codec, SequenceFile.CompressionType type, int records) throws IOException {
        MapFile.Writer writer = new MapFile.Writer(conf, path, new SequenceFile.Writer.Option[]{MapFile.Writer.keyClass(Text.class), MapFile.Writer.valueClass(Text.class), MapFile.Writer.compression((SequenceFile.CompressionType)type, (CompressionCodec)codec)});
        Text key = new Text();
        for (int j = 0; j < records; ++j) {
            key.set(String.format("%03d", j));
            writer.append((WritableComparable)key, (Writable)key);
        }
        writer.close();
    }

    public static void main(String[] args) throws IOException {
        int count = 10000;
        String codecClass = "org.apache.hadoop.io.compress.DefaultCodec";
        String usage = "TestCodec [-count N] [-codec <codec class>]";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].equals("-count")) {
                count = Integer.parseInt(args[++i]);
                continue;
            }
            if (!args[i].equals("-codec")) continue;
            codecClass = args[++i];
        }
        Configuration conf = new Configuration();
        int seed = 0;
        TestCodec.codecTest(conf, seed, count, codecClass);
    }

    @Test
    public void testGzipCompatibility() throws IOException {
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        LOG.info("seed: " + seed);
        DataOutputBuffer dflbuf = new DataOutputBuffer();
        GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)dflbuf);
        byte[] b = new byte[r.nextInt(131073)];
        r.nextBytes(b);
        gzout.write(b);
        gzout.close();
        DataInputBuffer gzbuf = new DataInputBuffer();
        gzbuf.reset(dflbuf.getData(), dflbuf.getLength());
        Configuration conf = new Configuration();
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        Decompressor decom = codec.createDecompressor();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)decom);
        org.junit.jupiter.api.Assertions.assertEquals(BuiltInGzipDecompressor.class, decom.getClass());
        CompressionInputStream gzin = codec.createInputStream((InputStream)gzbuf, decom);
        dflbuf.reset();
        IOUtils.copyBytes((InputStream)gzin, (OutputStream)dflbuf, (int)4096);
        byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])b, (byte[])dflchk);
    }

    @Test
    public void testGzipCompatibilityWithCompressor() throws IOException {
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        Configuration hadoopConf = new Configuration();
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)hadoopConf);
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            Compressor compressor = codec.createCompressor();
            ((ObjectAssert)Assertions.assertThat((Object)compressor).withFailMessage("should be BuiltInGzipCompressor", new Object[0])).isInstanceOf(BuiltInGzipCompressor.class);
            long randonSeed = r.nextLong();
            r.setSeed(randonSeed);
            LOG.info("seed: {}", (Object)randonSeed);
            int inputSize = r.nextInt(262145);
            byte[] b = new byte[inputSize];
            r.nextBytes(b);
            compressor.setInput(b, 0, b.length);
            compressor.finish();
            byte[] output = new byte[inputSize + 1024];
            int outputOff = 0;
            while (!compressor.finished()) {
                byte[] buf = new byte[r.nextInt(1024)];
                int compressed = compressor.compress(buf, 0, buf.length);
                System.arraycopy(buf, 0, output, outputOff, compressed);
                outputOff += compressed;
            }
            DataInputBuffer gzbuf = new DataInputBuffer();
            gzbuf.reset(output, outputOff);
            Decompressor decom = codec.createDecompressor();
            ((ObjectAssert)Assertions.assertThat((Object)decom).as("decompressor should not be null", new Object[0])).isNotNull();
            ((ObjectAssert)Assertions.assertThat((Object)decom).withFailMessage("should be BuiltInGzipDecompressor", new Object[0])).isInstanceOf(BuiltInGzipDecompressor.class);
            try (CompressionInputStream gzin = codec.createInputStream((InputStream)gzbuf, decom);
                 DataOutputBuffer dflbuf = new DataOutputBuffer();){
                dflbuf.reset();
                IOUtils.copyBytes((InputStream)gzin, (OutputStream)dflbuf, (int)4096);
                byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
                ((AbstractByteArrayAssert)Assertions.assertThat((byte[])b).as("check decompressed output", new Object[0])).isEqualTo((Object)dflchk);
                continue;
            }
        }
    }

    @Test
    public void testGzipCompatibilityWithCompressorAndGZIPOutputStream() throws IOException {
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        Configuration hadoopConf = new Configuration();
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)hadoopConf);
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            Compressor compressor = codec.createCompressor();
            ((ObjectAssert)Assertions.assertThat((Object)compressor).withFailMessage("should be BuiltInGzipCompressor", new Object[0])).isInstanceOf(BuiltInGzipCompressor.class);
            long randonSeed = r.nextLong();
            r.setSeed(randonSeed);
            LOG.info("seed: {}", (Object)randonSeed);
            int inputSize = r.nextInt(262145);
            byte[] b = new byte[inputSize];
            r.nextBytes(b);
            compressor.setInput(b, 0, b.length);
            compressor.finish();
            byte[] output = new byte[inputSize + 1024];
            int outputOff = 0;
            while (!compressor.finished()) {
                byte[] buf = new byte[r.nextInt(1024)];
                int compressed = compressor.compress(buf, 0, buf.length);
                System.arraycopy(buf, 0, output, outputOff, compressed);
                outputOff += compressed;
            }
            try (DataOutputBuffer dflbuf = new DataOutputBuffer();
                 GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)dflbuf);){
                gzout.write(b);
                gzout.close();
                byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
                LOG.info("output: {}", (Object)outputOff);
                LOG.info("dflchk: {}", (Object)dflchk.length);
                org.junit.jupiter.api.Assertions.assertEquals((int)outputOff, (int)dflchk.length);
                this.uncompressGzipOutput(b, output, outputOff, codec);
                this.uncompressGzipOutput(b, dflchk, dflchk.length, codec);
                continue;
            }
        }
    }

    @Test
    public void testGzipCompatibilityWithCompressorStreamAndGZIPOutputStream() throws IOException {
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        Configuration hadoopConf = new Configuration();
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)hadoopConf);
        Random r = new Random();
        for (int i = 0; i < 100; ++i) {
            Compressor compressor = codec.createCompressor();
            try (DataOutputBuffer dflbuf = new DataOutputBuffer();){
                ((ObjectAssert)Assertions.assertThat((Object)compressor).withFailMessage("should be BuiltInGzipCompressor", new Object[0])).isInstanceOf(BuiltInGzipCompressor.class);
                CompressionOutputStream compressionOutputStream = codec.createOutputStream((OutputStream)dflbuf, compressor);
                long randonSeed = r.nextLong();
                r.setSeed(randonSeed);
                LOG.info("seed: {}", (Object)randonSeed);
                int inputSize = r.nextInt(262145);
                byte[] b = new byte[inputSize];
                r.nextBytes(b);
                compressionOutputStream.write(b);
                compressionOutputStream.close();
                byte[] output = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
                dflbuf.reset();
                try (GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)dflbuf);){
                    gzout.write(b);
                    gzout.close();
                    byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
                    LOG.info("output: {}", (Object)output.length);
                    LOG.info("dflchk: {}", (Object)dflchk.length);
                    ((AbstractIntegerAssert)Assertions.assertThat((int)output.length).as("check compressed data length", new Object[0])).isEqualTo(dflchk.length);
                    this.uncompressGzipOutput(b, output, output.length, codec);
                    this.uncompressGzipOutput(b, dflchk, dflchk.length, codec);
                    continue;
                }
            }
        }
    }

    private void uncompressGzipOutput(byte[] origin, byte[] output, int outputLen, CompressionCodec codec) throws IOException {
        DataInputBuffer gzbuf = new DataInputBuffer();
        gzbuf.reset(output, outputLen);
        Decompressor decom = codec.createDecompressor();
        ((ObjectAssert)Assertions.assertThat((Object)decom).as("decompressor should not be null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)decom).withFailMessage("should be BuiltInGzipDecompressor", new Object[0])).isInstanceOf(BuiltInGzipDecompressor.class);
        CompressionInputStream gzin = codec.createInputStream((InputStream)gzbuf, decom);
        DataOutputBuffer dflbuf = new DataOutputBuffer();
        dflbuf.reset();
        IOUtils.copyBytes((InputStream)gzin, (OutputStream)dflbuf, (int)4096);
        byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])origin).as("check decompressed output", new Object[0])).isEqualTo((Object)dflchk);
    }

    void GzipConcatTest(Configuration conf, Class<? extends Decompressor> decomClass) throws IOException {
        Random r = new Random();
        long seed = r.nextLong();
        r.setSeed(seed);
        LOG.info(decomClass + " seed: " + seed);
        int CONCAT = r.nextInt(4) + 3;
        int BUFLEN = 131072;
        DataOutputBuffer dflbuf = new DataOutputBuffer();
        DataOutputBuffer chkbuf = new DataOutputBuffer();
        byte[] b = new byte[131072];
        for (int i = 0; i < CONCAT; ++i) {
            GZIPOutputStream gzout = new GZIPOutputStream((OutputStream)dflbuf);
            r.nextBytes(b);
            int len = r.nextInt(131072);
            int off = r.nextInt(131072 - len);
            chkbuf.write(b, off, len);
            gzout.write(b, off, len);
            gzout.close();
        }
        byte[] chk = Arrays.copyOf(chkbuf.getData(), chkbuf.getLength());
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        Decompressor decom = codec.createDecompressor();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)decom);
        org.junit.jupiter.api.Assertions.assertEquals(decomClass, decom.getClass());
        DataInputBuffer gzbuf = new DataInputBuffer();
        gzbuf.reset(dflbuf.getData(), dflbuf.getLength());
        CompressionInputStream gzin = codec.createInputStream((InputStream)gzbuf, decom);
        dflbuf.reset();
        IOUtils.copyBytes((InputStream)gzin, (OutputStream)dflbuf, (int)4096);
        byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])chk, (byte[])dflchk);
    }

    @Test
    public void testBuiltInGzipConcat() throws IOException {
        Configuration conf = new Configuration();
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        this.GzipConcatTest(conf, BuiltInGzipDecompressor.class);
    }

    @Test
    public void testNativeGzipConcat() throws IOException {
        Configuration conf = new Configuration();
        Assumptions.assumeTrue((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf));
        this.GzipConcatTest(conf, GzipCodec.GzipZlibDecompressor.class);
    }

    @Test
    public void testGzipCodecRead() throws IOException {
        Configuration conf = new Configuration();
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)zlibDecompressor, (String)"zlibDecompressor is null!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(zlibDecompressor instanceof BuiltInZlibInflater), (String)"ZlibFactory returned unexpected inflator");
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        Path f = new Path(GenericTestUtils.getTempPath("testGzipCodecRead.txt.gz"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f.toString()))));
        String msg = "This is the message in the file!";
        bw.write("This is the message in the file!");
        bw.close();
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(f);
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream is = fs.open(f);
        is = codec.createInputStream((InputStream)is, decompressor);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is));
        String line = br.readLine();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"This is the message in the file!", (Object)line, (String)"Didn't get the same message back!");
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyGzipFile(String filename, String msg) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(filename))));
        try {
            String line = r.readLine();
            org.junit.jupiter.api.Assertions.assertEquals((Object)msg, (Object)line, (String)("Got invalid line back from " + filename));
        }
        finally {
            r.close();
            new File(filename).delete();
        }
    }

    @Test
    public void testGzipLongOverflow() throws IOException {
        int i;
        LOG.info("testGzipLongOverflow");
        Configuration conf = new Configuration();
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf), (String)"ZlibFactory is using native libs against request");
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)zlibDecompressor, (String)"zlibDecompressor is null!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(zlibDecompressor instanceof BuiltInZlibInflater), (String)"ZlibFactory returned unexpected inflator");
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        Path f = new Path(GenericTestUtils.getTempPath("testGzipLongOverflow.bin.gz"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(f.toString()))));
        int NBUF = 4097;
        char[] buf = new char[0x100000];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = '\u0000';
        }
        for (i = 0; i < 4097; ++i) {
            bw.write(buf);
        }
        bw.close();
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(f);
        Decompressor decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        FSDataInputStream is = fs.open(f);
        is = codec.createInputStream((InputStream)is, decompressor);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)is));
        for (int j = 0; j < 4097; ++j) {
            int n = br.read(buf);
            org.junit.jupiter.api.Assertions.assertEquals((int)n, (int)buf.length, (String)"got wrong read length!");
            for (int i2 = 0; i2 < buf.length; ++i2) {
                org.junit.jupiter.api.Assertions.assertEquals((char)buf[i2], (char)'\u0000', (String)"got wrong byte!");
            }
        }
        br.close();
    }

    private void testGzipCodecWrite(boolean useNative) throws IOException {
        int i;
        Configuration hadoopConf = new Configuration();
        if (useNative) {
            Assumptions.assumeTrue((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)hadoopConf));
        } else {
            org.junit.jupiter.api.Assertions.assertFalse((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)hadoopConf), (String)"ZlibFactory is using native libs against request");
        }
        Compressor zlibCompressor = ZlibFactory.getZlibCompressor((Configuration)hadoopConf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)zlibCompressor, (String)"zlibCompressor is null!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(useNative ? zlibCompressor instanceof ZlibCompressor : zlibCompressor instanceof BuiltInZlibDeflater), (String)"ZlibFactory returned unexpected deflator");
        CodecPool.returnCompressor((Compressor)zlibCompressor);
        CompressionCodecFactory ccf = new CompressionCodecFactory(hadoopConf);
        CompressionCodec codec = ccf.getCodec(new Path("foo.gz"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(codec instanceof GzipCodec), (String)"Codec for .gz file is not GzipCodec");
        String fileName = new Path(GenericTestUtils.getTempPath("testGzipCodecWrite.txt.gz")).toString();
        BufferedWriter w = null;
        Compressor gzipCompressor = CodecPool.getCompressor((CompressionCodec)codec);
        CompressorStream os = new CompressorStream((OutputStream)new FileOutputStream(fileName), gzipCompressor);
        int bufferSize = 10000;
        char[] inputBuffer = new char[bufferSize];
        Random rand = new Random();
        for (int i2 = 0; i2 < bufferSize; ++i2) {
            inputBuffer[i2] = (char)(97 + rand.nextInt(26));
        }
        w = new BufferedWriter(new OutputStreamWriter((OutputStream)os), bufferSize);
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 10; ++i) {
            w.write(inputBuffer);
            sb.append(inputBuffer);
        }
        w.close();
        CodecPool.returnCompressor((Compressor)gzipCompressor);
        this.verifyGzipFile(fileName, sb.toString());
        w = new BufferedWriter(new OutputStreamWriter((OutputStream)codec.createOutputStream((OutputStream)new FileOutputStream(fileName))));
        for (i = 0; i < 10; ++i) {
            w.write(inputBuffer);
        }
        w.close();
        this.verifyGzipFile(fileName, sb.toString());
    }

    @Test
    public void testGzipCodecWriteJava() throws IOException {
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        this.testGzipCodecWrite(false);
    }

    @Test
    public void testGzipNativeCodecWrite() throws IOException {
        this.testGzipCodecWrite(true);
    }

    @Test
    public void testCodecPoolAndGzipCompressor() {
        Compressor poolCompressor;
        Configuration conf = new Configuration();
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf), (String)"ZlibFactory is using native libs against request");
        Compressor zlibCompressor = ZlibFactory.getZlibCompressor((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)zlibCompressor, (String)"zlibCompressor is null!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(zlibCompressor instanceof BuiltInZlibDeflater), (String)"ZlibFactory returned unexpected deflator");
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(new Path("foo.gz"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(codec instanceof GzipCodec), (String)"Codec for .gz file is not GzipCodec");
        Compressor codecCompressor = codec.createCompressor();
        if (null == codecCompressor) {
            org.junit.jupiter.api.Assertions.fail((String)"Got null codecCompressor");
        }
        if (null == (poolCompressor = CodecPool.getCompressor((CompressionCodec)codec))) {
            org.junit.jupiter.api.Assertions.fail((String)"Got null poolCompressor");
        }
        CodecPool.returnCompressor((Compressor)zlibCompressor);
        CodecPool.returnCompressor((Compressor)poolCompressor);
        Compressor poolCompressor2 = CodecPool.getCompressor((CompressionCodec)codec);
        if (poolCompressor.getClass() == BuiltInGzipCompressor.class) {
            if (poolCompressor == poolCompressor2) {
                org.junit.jupiter.api.Assertions.fail((String)"Reused java gzip compressor in pool");
            }
        } else if (poolCompressor != poolCompressor2) {
            org.junit.jupiter.api.Assertions.fail((String)"Did not reuse native gzip compressor in pool");
        }
    }

    @Test
    public void testCodecPoolAndGzipDecompressor() {
        Decompressor poolDecompressor;
        Configuration conf = new Configuration();
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ZlibFactory.isNativeZlibLoaded((Configuration)conf), (String)"ZlibFactory is using native libs against request");
        Decompressor zlibDecompressor = ZlibFactory.getZlibDecompressor((Configuration)conf);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)zlibDecompressor, (String)"zlibDecompressor is null!");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(zlibDecompressor instanceof BuiltInZlibInflater), (String)"ZlibFactory returned unexpected inflator");
        CompressionCodecFactory ccf = new CompressionCodecFactory(conf);
        CompressionCodec codec = ccf.getCodec(new Path("foo.gz"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(codec instanceof GzipCodec), (String)"Codec for .gz file is not GzipCodec");
        Decompressor codecDecompressor = codec.createDecompressor();
        if (null == codecDecompressor) {
            org.junit.jupiter.api.Assertions.fail((String)"Got null codecDecompressor");
        }
        if (null == (poolDecompressor = CodecPool.getDecompressor((CompressionCodec)codec))) {
            org.junit.jupiter.api.Assertions.fail((String)"Got null poolDecompressor");
        }
        CodecPool.returnDecompressor((Decompressor)zlibDecompressor);
        CodecPool.returnDecompressor((Decompressor)poolDecompressor);
        Decompressor poolDecompressor2 = CodecPool.getDecompressor((CompressionCodec)codec);
        if (poolDecompressor.getClass() == BuiltInGzipDecompressor.class) {
            if (poolDecompressor == poolDecompressor2) {
                org.junit.jupiter.api.Assertions.fail((String)"Reused java gzip decompressor in pool");
            }
        } else if (poolDecompressor != poolDecompressor2) {
            org.junit.jupiter.api.Assertions.fail((String)"Did not reuse native gzip decompressor in pool");
        }
    }

    @Test
    @Timeout(value=20L)
    public void testGzipCompressorWithEmptyInput() throws IOException {
        ZlibFactory.setNativeZlibLoaded((boolean)false);
        Configuration conf = new Configuration();
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(GzipCodec.class, (Configuration)conf);
        Compressor compressor = codec.createCompressor();
        ((ObjectAssert)Assertions.assertThat((Object)compressor).withFailMessage("should be BuiltInGzipCompressor", new Object[0])).isInstanceOf(BuiltInGzipCompressor.class);
        byte[] b = new byte[]{};
        compressor.setInput(b, 0, b.length);
        compressor.finish();
        byte[] output = new byte[100];
        int outputOff = 0;
        while (!compressor.finished()) {
            byte[] buf = new byte[100];
            int compressed = compressor.compress(buf, 0, buf.length);
            System.arraycopy(buf, 0, output, outputOff, compressed);
            outputOff += compressed;
        }
        DataInputBuffer gzbuf = new DataInputBuffer();
        gzbuf.reset(output, outputOff);
        Decompressor decom = codec.createDecompressor();
        ((ObjectAssert)Assertions.assertThat((Object)decom).as("decompressor should not be null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)decom).withFailMessage("should be BuiltInGzipDecompressor", new Object[0])).isInstanceOf(BuiltInGzipDecompressor.class);
        try (CompressionInputStream gzin = codec.createInputStream((InputStream)gzbuf, decom);
             DataOutputBuffer dflbuf = new DataOutputBuffer();){
            dflbuf.reset();
            IOUtils.copyBytes((InputStream)gzin, (OutputStream)dflbuf, (int)4096);
            byte[] dflchk = Arrays.copyOf(dflbuf.getData(), dflbuf.getLength());
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])b).as("check decompressed output", new Object[0])).isEqualTo((Object)dflchk);
        }
    }
}

