/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableName;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWritableName {
    private static final String testName = "mystring";

    @Test
    public void testGoodName() throws Exception {
        Configuration conf = new Configuration();
        Class test = WritableName.getClass((String)"long", (Configuration)conf);
        Assertions.assertTrue((test != null ? 1 : 0) != 0);
    }

    @Test
    public void testSetName() throws Exception {
        Configuration conf = new Configuration();
        WritableName.setName(SimpleWritable.class, (String)testName);
        Class test = WritableName.getClass((String)testName, (Configuration)conf);
        Assertions.assertTrue((boolean)test.equals(SimpleWritable.class));
    }

    @Test
    public void testAddName() throws Exception {
        Configuration conf = new Configuration();
        String altName = "mystring.alt";
        WritableName.setName(SimpleWritable.class, (String)testName);
        WritableName.addName(SimpleWritable.class, (String)altName);
        Class test = WritableName.getClass((String)altName, (Configuration)conf);
        Assertions.assertTrue((boolean)test.equals(SimpleWritable.class));
        test = WritableName.getClass((String)testName, (Configuration)conf);
        Assertions.assertTrue((boolean)test.equals(SimpleWritable.class));
    }

    @Test
    public void testAddNameSerializable() throws Exception {
        Configuration conf = new Configuration();
        conf.set("io.serializations", SimpleSerializer.class.getName());
        SerializationFactory serializationFactory = new SerializationFactory(conf);
        String altName = "mystring.alt";
        WritableName.addName(SimpleSerializable.class, (String)altName);
        Class test = WritableName.getClass((String)altName, (Configuration)conf);
        Assertions.assertEquals((Object)test, SimpleSerializable.class);
        Assertions.assertNotNull((Object)serializationFactory.getSerialization(test));
        test = WritableName.getClass((String)SimpleSerializable.class.getName(), (Configuration)conf);
        Assertions.assertEquals((Object)test, SimpleSerializable.class);
        Assertions.assertNotNull((Object)serializationFactory.getSerialization(test));
    }

    @Test
    public void testBadName() throws Exception {
        Configuration conf = new Configuration();
        try {
            WritableName.getClass((String)"unknown_junk", (Configuration)conf);
            Assertions.assertTrue((boolean)false);
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)e.getMessage().matches(".*unknown_junk.*"));
        }
    }

    private static class SimpleSerializer
    implements Serialization<SimpleSerializable> {
        private SimpleSerializer() {
        }

        public boolean accept(Class<?> c) {
            return c.equals(SimpleSerializable.class);
        }

        public Serializer<SimpleSerializable> getSerializer(Class<SimpleSerializable> c) {
            return null;
        }

        public Deserializer<SimpleSerializable> getDeserializer(Class<SimpleSerializable> c) {
            return null;
        }
    }

    private static class SimpleSerializable {
        private SimpleSerializable() {
        }
    }

    public static class SimpleWritable
    implements Writable {
        private static final Random RANDOM = new Random();
        int state = RANDOM.nextInt();

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.state);
        }

        public void readFields(DataInput in) throws IOException {
            this.state = in.readInt();
        }

        public static SimpleWritable read(DataInput in) throws IOException {
            SimpleWritable result = new SimpleWritable();
            result.readFields(in);
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SimpleWritable)) {
                return false;
            }
            SimpleWritable other = (SimpleWritable)o;
            return this.state == other.state;
        }
    }
}

