/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.io.BoundedByteArrayOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBoundedByteArrayOutputStream {
    private static final int SIZE = 1024;
    private static final byte[] INPUT = new byte[1024];

    @Test
    public void testBoundedStream() throws IOException {
        BoundedByteArrayOutputStream stream = new BoundedByteArrayOutputStream(1024);
        stream.write(INPUT, 0, 1024);
        Assertions.assertTrue((boolean)Arrays.equals(INPUT, stream.getBuffer()), (String)"Array Contents Mismatch");
        boolean caughtException = false;
        try {
            stream.write((int)INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assertions.assertTrue((boolean)caughtException, (String)"Writing beyond limit did not throw an exception");
        stream.reset();
        Assertions.assertTrue((stream.getLimit() == 1024 ? 1 : 0) != 0, (String)"Limit did not get reset correctly");
        stream.write(INPUT, 0, 1024);
        Assertions.assertTrue((boolean)Arrays.equals(INPUT, stream.getBuffer()), (String)"Array Contents Mismatch");
        caughtException = false;
        try {
            stream.write((int)INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        stream.reset(1023);
        Assertions.assertTrue((stream.getLimit() == 1023 ? 1 : 0) != 0, (String)"Limit did not get reset correctly");
        caughtException = false;
        try {
            stream.write(INPUT, 0, 1024);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assertions.assertTrue((boolean)caughtException, (String)"Writing beyond limit did not throw an exception");
    }

    @Test
    public void testResetBuffer() throws IOException {
        ResettableBoundedByteArrayOutputStream stream = new ResettableBoundedByteArrayOutputStream(1024);
        stream.write(INPUT, 0, 1024);
        Assertions.assertTrue((boolean)Arrays.equals(INPUT, stream.getBuffer()), (String)"Array Contents Mismatch");
        boolean caughtException = false;
        try {
            stream.write(INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assertions.assertTrue((boolean)caughtException, (String)"Writing beyond limit did not throw an exception");
        byte[] newBuf = new byte[1024];
        stream.resetBuffer(newBuf, 0, newBuf.length);
        Assertions.assertTrue((stream.getLimit() == 1024 ? 1 : 0) != 0, (String)"Limit did not get reset correctly");
        stream.write(INPUT, 0, 1024);
        Assertions.assertTrue((boolean)Arrays.equals(INPUT, stream.getBuffer()), (String)"Array Contents Mismatch");
        caughtException = false;
        try {
            stream.write(INPUT[0]);
        }
        catch (Exception e) {
            caughtException = true;
        }
        Assertions.assertTrue((boolean)caughtException, (String)"Writing beyond limit did not throw an exception");
    }

    static {
        new Random().nextBytes(INPUT);
    }

    static class ResettableBoundedByteArrayOutputStream
    extends BoundedByteArrayOutputStream {
        public ResettableBoundedByteArrayOutputStream(int capacity) {
            super(capacity);
        }

        public void resetBuffer(byte[] buf, int offset, int length) {
            super.resetBuffer(buf, offset, length);
        }
    }
}

