/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBooleanWritable {
    @Test
    public void testCompareUnequalWritables() throws Exception {
        DataOutputBuffer bTrue = this.writeWritable((Writable)new BooleanWritable(true));
        DataOutputBuffer bFalse = this.writeWritable((Writable)new BooleanWritable(false));
        WritableComparator writableComparator = WritableComparator.get(BooleanWritable.class);
        Assertions.assertEquals((int)0, (int)this.compare(writableComparator, bTrue, bTrue));
        Assertions.assertEquals((int)0, (int)this.compare(writableComparator, bFalse, bFalse));
        Assertions.assertEquals((int)1, (int)this.compare(writableComparator, bTrue, bFalse));
        Assertions.assertEquals((int)-1, (int)this.compare(writableComparator, bFalse, bTrue));
    }

    private int compare(WritableComparator writableComparator, DataOutputBuffer buf1, DataOutputBuffer buf2) {
        return writableComparator.compare(buf1.getData(), 0, buf1.size(), buf2.getData(), 0, buf2.size());
    }

    protected DataOutputBuffer writeWritable(Writable writable) throws IOException {
        DataOutputBuffer out = new DataOutputBuffer(1024);
        writable.write((DataOutput)out);
        out.flush();
        return out;
    }

    @Test
    public void testCommonMethods() {
        Assertions.assertTrue((boolean)TestBooleanWritable.newInstance(true).equals((Object)TestBooleanWritable.newInstance(true)), (String)"testCommonMethods1 error !!!");
        Assertions.assertTrue((boolean)TestBooleanWritable.newInstance(false).equals((Object)TestBooleanWritable.newInstance(false)), (String)"testCommonMethods2 error  !!!");
        Assertions.assertFalse((boolean)TestBooleanWritable.newInstance(false).equals((Object)TestBooleanWritable.newInstance(true)), (String)"testCommonMethods3 error !!!");
        Assertions.assertTrue((boolean)this.checkHashCode(TestBooleanWritable.newInstance(true), TestBooleanWritable.newInstance(true)), (String)"testCommonMethods4 error !!!");
        Assertions.assertFalse((boolean)this.checkHashCode(TestBooleanWritable.newInstance(true), TestBooleanWritable.newInstance(false)), (String)"testCommonMethods5 error !!! ");
        Assertions.assertTrue((TestBooleanWritable.newInstance(true).compareTo(TestBooleanWritable.newInstance(false)) > 0 ? 1 : 0) != 0, (String)"testCommonMethods6 error !!!");
        Assertions.assertTrue((TestBooleanWritable.newInstance(false).compareTo(TestBooleanWritable.newInstance(true)) < 0 ? 1 : 0) != 0, (String)"testCommonMethods7 error !!!");
        Assertions.assertTrue((TestBooleanWritable.newInstance(false).compareTo(TestBooleanWritable.newInstance(false)) == 0 ? 1 : 0) != 0, (String)"testCommonMethods8 error !!!");
        Assertions.assertEquals((Object)"true", (Object)TestBooleanWritable.newInstance(true).toString(), (String)"testCommonMethods9 error !!!");
    }

    private boolean checkHashCode(BooleanWritable f, BooleanWritable s) {
        return f.hashCode() == s.hashCode();
    }

    private static BooleanWritable newInstance(boolean flag) {
        return new BooleanWritable(flag);
    }
}

