/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.apache.hadoop.net.NetUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHttpServerLogs
extends HttpServerFunctionalTest {
    static final Logger LOG = LoggerFactory.getLogger(TestHttpServerLogs.class);
    private static HttpServer2 server;

    @BeforeAll
    public static void setup() throws Exception {
    }

    private void startServer(Configuration conf) throws Exception {
        server = TestHttpServerLogs.createTestServer(conf);
        server.start();
        baseUrl = TestHttpServerLogs.getServerURL(server);
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterAll
    public static void cleanup() throws Exception {
        if (server != null && server.isAlive()) {
            server.stop();
        }
    }

    @Test
    public void testLogsEnabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.http.logs.enabled", true);
        this.startServer(conf);
        InetSocketAddress inetSocketAddress = Objects.requireNonNull(server.getConnectorAddress(0));
        URL url = new URL("http://" + NetUtils.getHostPortString((InetSocketAddress)inetSocketAddress) + "/logs");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestHttpServerLogs.assertEquals((int)200, (int)conn.getResponseCode());
    }

    @Test
    public void testLogsDisabled() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("hadoop.http.logs.enabled", false);
        this.startServer(conf);
        URL url = new URL(baseUrl + "/logs");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        TestHttpServerLogs.assertEquals((int)404, (int)conn.getResponseCode());
    }
}

