/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.junit.jupiter.api.Test;

public class TestHttpServerLifecycle
extends HttpServerFunctionalTest {
    private void assertAlive(HttpServer2 server) {
        TestHttpServerLifecycle.assertTrue((boolean)server.isAlive(), (String)"Server is not alive");
        this.assertToStringContains(server, " - alive");
    }

    private void assertNotLive(HttpServer2 server) {
        TestHttpServerLifecycle.assertTrue((!server.isAlive() ? 1 : 0) != 0, (String)"Server should not be live");
        this.assertToStringContains(server, " - not live");
    }

    @Test
    public void testCreatedServerIsNotAlive() throws Throwable {
        HttpServer2 server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
    }

    @Test
    public void testStopUnstartedServer() throws Throwable {
        HttpServer2 server = TestHttpServerLifecycle.createTestServer();
        TestHttpServerLifecycle.stop(server);
    }

    @Test
    public void testStartedServerIsAlive() throws Throwable {
        HttpServer2 server = null;
        server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
        server.start();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
    }

    private void assertToStringContains(HttpServer2 server, String text) {
        String description = server.toString();
        TestHttpServerLifecycle.assertTrue((boolean)description.contains(text), (String)("Did not find \"" + text + "\" in \"" + description + "\""));
    }

    @Test
    public void testStoppedServerIsNotAlive() throws Throwable {
        HttpServer2 server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }

    @Test
    public void testStoppingTwiceServerIsAllowed() throws Throwable {
        HttpServer2 server = TestHttpServerLifecycle.createAndStartTestServer();
        this.assertAlive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
        TestHttpServerLifecycle.stop(server);
        this.assertNotLive(server);
    }

    @Test
    public void testWepAppContextAfterServerStop() throws Throwable {
        HttpServer2 server = null;
        String key = "test.attribute.key";
        String value = "test.attribute.value";
        server = TestHttpServerLifecycle.createTestServer();
        this.assertNotLive(server);
        server.start();
        server.setAttribute(key, (Object)value);
        this.assertAlive(server);
        TestHttpServerLifecycle.assertEquals((Object)value, (Object)server.getAttribute(key));
        TestHttpServerLifecycle.stop(server);
        TestHttpServerLifecycle.assertNull((Object)server.getAttribute(key), (String)"Server context should have cleared");
    }
}

