/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.http.HttpServer2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHtmlQuoting {
    @Test
    public void testNeedsQuoting() throws Exception {
        Assertions.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abcde>"));
        Assertions.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"<abcde"));
        Assertions.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abc'de"));
        Assertions.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"abcde\""));
        Assertions.assertTrue((boolean)HtmlQuoting.needsQuoting((String)"&"));
        Assertions.assertFalse((boolean)HtmlQuoting.needsQuoting((String)""));
        Assertions.assertFalse((boolean)HtmlQuoting.needsQuoting((String)"ab\ncdef"));
        Assertions.assertFalse((boolean)HtmlQuoting.needsQuoting(null));
    }

    @Test
    public void testQuoting() throws Exception {
        Assertions.assertEquals((Object)"ab&lt;cd", (Object)HtmlQuoting.quoteHtmlChars((String)"ab<cd"));
        Assertions.assertEquals((Object)"ab&gt;", (Object)HtmlQuoting.quoteHtmlChars((String)"ab>"));
        Assertions.assertEquals((Object)"&amp;&amp;&amp;", (Object)HtmlQuoting.quoteHtmlChars((String)"&&&"));
        Assertions.assertEquals((Object)" &apos;\n", (Object)HtmlQuoting.quoteHtmlChars((String)" '\n"));
        Assertions.assertEquals((Object)"&quot;", (Object)HtmlQuoting.quoteHtmlChars((String)"\""));
        Assertions.assertEquals(null, (Object)HtmlQuoting.quoteHtmlChars(null));
    }

    private void runRoundTrip(String str) throws Exception {
        Assertions.assertEquals((Object)str, (Object)HtmlQuoting.unquoteHtmlChars((String)HtmlQuoting.quoteHtmlChars((String)str)));
    }

    @Test
    public void testRoundtrip() throws Exception {
        this.runRoundTrip("");
        this.runRoundTrip("<>&'\"");
        this.runRoundTrip("ab>cd<ef&ghi'\"");
        this.runRoundTrip("A string\n with no quotable chars in it!");
        this.runRoundTrip(null);
        StringBuilder buffer = new StringBuilder();
        for (char ch = '\u0000'; ch < '\u007f'; ch = (char)(ch + '\u0001')) {
            buffer.append(ch);
        }
        this.runRoundTrip(buffer.toString());
    }

    @Test
    public void testRequestQuoting() throws Exception {
        HttpServletRequest mockReq = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServer2.QuotingInputFilter.RequestQuoter quoter = new HttpServer2.QuotingInputFilter.RequestQuoter(mockReq);
        ((HttpServletRequest)Mockito.doReturn((Object)"a<b").when((Object)mockReq)).getParameter("x");
        Assertions.assertEquals((Object)"a&lt;b", (Object)quoter.getParameter("x"), (String)"Test simple param quoting");
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)mockReq)).getParameter("x");
        Assertions.assertEquals(null, (Object)quoter.getParameter("x"), (String)"Test that missing parameters dont cause NPE");
        ((HttpServletRequest)Mockito.doReturn((Object)new String[]{"a<b", "b"}).when((Object)mockReq)).getParameterValues("x");
        Assertions.assertArrayEquals((Object[])new String[]{"a&lt;b", "b"}, (Object[])quoter.getParameterValues("x"), (String)"Test escaping of an array");
        ((HttpServletRequest)Mockito.doReturn(null).when((Object)mockReq)).getParameterValues("x");
        Assertions.assertArrayEquals(null, (Object[])quoter.getParameterValues("x"), (String)"Test that missing parameters dont cause NPE for array");
    }
}

