/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.http.HttpServerFunctionalTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestDisabledProfileServlet
extends HttpServerFunctionalTest {
    private static HttpServer2 server;
    private static URL baseUrl;

    @BeforeAll
    public static void setup() throws Exception {
        server = TestDisabledProfileServlet.createTestServer();
        server.start();
        baseUrl = TestDisabledProfileServlet.getServerURL(server);
    }

    @AfterAll
    public static void cleanup() throws Exception {
        server.stop();
    }

    @Test
    public void testQuery() throws Exception {
        try {
            TestDisabledProfileServlet.readOutput(new URL(baseUrl, "/prof"));
            throw new IllegalStateException("Should not reach here");
        }
        catch (IOException e) {
            TestDisabledProfileServlet.assertTrue((boolean)e.getMessage().contains("500 for URL: " + baseUrl));
            HttpURLConnection conn = (HttpURLConnection)new URL(baseUrl, "/prof").openConnection();
            TestDisabledProfileServlet.assertEquals((Object)"GET", (Object)conn.getHeaderField("Access-Control-Allow-Methods"));
            TestDisabledProfileServlet.assertNotNull((Object)conn.getHeaderField("Access-Control-Allow-Origin"));
            conn.disconnect();
            return;
        }
    }

    @Test
    public void testRequestMethods() throws IOException {
        HttpURLConnection connection = this.getConnection("PUT");
        TestDisabledProfileServlet.assertEquals((int)405, (int)connection.getResponseCode(), (String)"Unexpected response code");
        connection.disconnect();
        connection = this.getConnection("POST");
        TestDisabledProfileServlet.assertEquals((int)405, (int)connection.getResponseCode(), (String)"Unexpected response code");
        connection.disconnect();
        connection = this.getConnection("DELETE");
        TestDisabledProfileServlet.assertEquals((int)405, (int)connection.getResponseCode(), (String)"Unexpected response code");
        connection.disconnect();
        connection = this.getConnection("GET");
        TestDisabledProfileServlet.assertEquals((int)500, (int)connection.getResponseCode(), (String)"Unexpected response code");
        connection.disconnect();
    }

    private HttpURLConnection getConnection(String method) throws IOException {
        URL url = new URL(baseUrl, "/prof");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        return conn;
    }
}

