/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.SshFenceByTcpPort;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.event.Level;

public class TestSshFenceByTcpPort {
    private static String TEST_FENCING_HOST;
    private static final String TEST_FENCING_PORT;
    private static final String TEST_KEYFILE;
    private static final InetSocketAddress TEST_ADDR;
    private static final HAServiceTarget TEST_TARGET;
    private static final HAServiceTarget UNFENCEABLE_TARGET;

    @Test
    @Timeout(value=20L)
    public void testFence() throws BadFencingConfigurationException {
        Assumptions.assumeTrue((boolean)this.isConfigured());
        Configuration conf = new Configuration();
        conf.set("dfs.ha.fencing.ssh.private-key-files", TEST_KEYFILE);
        SshFenceByTcpPort fence = new SshFenceByTcpPort();
        fence.setConf(conf);
        Assertions.assertTrue((boolean)fence.tryFence(TEST_TARGET, null));
    }

    @Test
    @Timeout(value=20L)
    public void testConnectTimeout() throws BadFencingConfigurationException {
        Configuration conf = new Configuration();
        conf.setInt("dfs.ha.fencing.ssh.connect-timeout", 3000);
        SshFenceByTcpPort fence = new SshFenceByTcpPort();
        fence.setConf(conf);
        Assertions.assertFalse((boolean)fence.tryFence(UNFENCEABLE_TARGET, ""));
    }

    @Test
    public void testArgsParsing() throws BadFencingConfigurationException {
        SshFenceByTcpPort.Args args = new SshFenceByTcpPort.Args(null);
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)args.user);
        Assertions.assertEquals((int)22, (int)args.sshPort);
        args = new SshFenceByTcpPort.Args("");
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)args.user);
        Assertions.assertEquals((int)22, (int)args.sshPort);
        args = new SshFenceByTcpPort.Args("12345");
        Assertions.assertEquals((Object)"12345", (Object)args.user);
        Assertions.assertEquals((int)22, (int)args.sshPort);
        args = new SshFenceByTcpPort.Args(":12345");
        Assertions.assertEquals((Object)System.getProperty("user.name"), (Object)args.user);
        Assertions.assertEquals((int)12345, (int)args.sshPort);
        args = new SshFenceByTcpPort.Args("foo:2222");
        Assertions.assertEquals((Object)"foo", (Object)args.user);
        Assertions.assertEquals((int)2222, (int)args.sshPort);
    }

    @Test
    public void testBadArgsParsing() throws BadFencingConfigurationException {
        this.assertBadArgs(":");
        this.assertBadArgs("bar.com:");
        this.assertBadArgs(":xx");
        this.assertBadArgs("bar.com:xx");
    }

    private void assertBadArgs(String argStr) {
        try {
            new SshFenceByTcpPort.Args(argStr);
            Assertions.fail((String)("Did not fail on bad args: " + argStr));
        }
        catch (BadFencingConfigurationException badFencingConfigurationException) {
            // empty catch block
        }
    }

    private boolean isConfigured() {
        return TEST_FENCING_HOST != null && !TEST_FENCING_HOST.isEmpty() && TEST_FENCING_PORT != null && !TEST_FENCING_PORT.isEmpty() && TEST_KEYFILE != null && !TEST_KEYFILE.isEmpty();
    }

    static {
        GenericTestUtils.setLogLevel(SshFenceByTcpPort.LOG, Level.TRACE);
        TEST_FENCING_HOST = System.getProperty("test.TestSshFenceByTcpPort.host", "localhost");
        TEST_FENCING_PORT = System.getProperty("test.TestSshFenceByTcpPort.port", "8020");
        TEST_KEYFILE = System.getProperty("test.TestSshFenceByTcpPort.key");
        TEST_ADDR = new InetSocketAddress(TEST_FENCING_HOST, Integer.parseInt(TEST_FENCING_PORT));
        TEST_TARGET = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, TEST_ADDR);
        UNFENCEABLE_TARGET = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, new InetSocketAddress("8.8.8.8", 1234));
    }
}

