/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.local.LocalConfigKeys;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.AclUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.viewfs.ChRootedFs;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.Constants;
import org.apache.hadoop.fs.viewfs.InodeTree;
import org.apache.hadoop.fs.viewfs.NotInMountpointException;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFs;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class ViewFsBaseTest {
    protected static final String MOUNT_TABLE_NAME = "mycluster";
    FileContext fcView;
    FileContext fcTarget;
    Path targetTestRoot;
    Configuration conf;
    FileContext xfcViewWithAuthority;
    URI schemeWithAuthority;
    final FileContextTestHelper fileContextTestHelper = this.createFileContextHelper();
    protected static boolean SupportsBlocks = false;

    protected FileContextTestHelper createFileContextHelper() {
        return new FileContextTestHelper();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.initializeTargetTestRoot();
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "user"), FileContext.DEFAULT_PERM, true);
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "data"), FileContext.DEFAULT_PERM, true);
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "dir2"), FileContext.DEFAULT_PERM, true);
        this.fcTarget.mkdir(new Path(this.targetTestRoot, "dir3"), FileContext.DEFAULT_PERM, true);
        FileContextTestHelper.createFile(this.fcTarget, new Path(this.targetTestRoot, "aFile"));
        this.conf = new Configuration();
        this.conf.set("fs.viewfs.mounttable.default.name.key", MOUNT_TABLE_NAME);
        ConfigUtil.addLink((Configuration)this.conf, (String)"/targetRoot", (URI)this.targetTestRoot.toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/user2", (URI)new Path(this.targetTestRoot, "user").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/data", (URI)new Path(this.targetTestRoot, "data").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/linkToDir2", (URI)new Path(this.targetTestRoot, "dir2").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/internalDir/internalDir2/linkToDir3", (URI)new Path(this.targetTestRoot, "dir3").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/danglingLink", (URI)new Path(this.targetTestRoot, "missingTarget").toUri());
        ConfigUtil.addLink((Configuration)this.conf, (String)"/linkToAFile", (URI)new Path(this.targetTestRoot, "aFile").toUri());
        this.fcView = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)this.conf);
    }

    void initializeTargetTestRoot() throws IOException {
        this.targetTestRoot = this.fileContextTestHelper.getAbsoluteTestRootPath(this.fcTarget);
        this.fcTarget.delete(this.targetTestRoot, true);
        this.fcTarget.mkdir(this.targetTestRoot, FileContext.DEFAULT_PERM, true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.fcTarget.delete(this.fileContextTestHelper.getTestRootPath(this.fcTarget), true);
    }

    @Test
    public void testGetMountPoints() {
        ViewFs viewfs = (ViewFs)this.fcView.getDefaultFileSystem();
        ViewFs.MountPoint[] mountPoints = viewfs.getMountPoints();
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)mountPoints.length);
    }

    int getExpectedDelegationTokenCount() {
        return 0;
    }

    @Test
    public void testGetDelegationTokens() throws IOException {
        List delTokens = this.fcView.getDelegationTokens(new Path("/"), "sanjay");
        org.junit.jupiter.api.Assertions.assertEquals((int)this.getExpectedDelegationTokenCount(), (int)delTokens.size());
    }

    @Test
    public void testBasicPaths() {
        org.junit.jupiter.api.Assertions.assertEquals((Object)FsConstants.VIEWFS_URI, (Object)this.fcView.getDefaultFileSystem().getUri());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getWorkingDirectory());
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fcView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fcView.getHomeDirectory());
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path("/foo/bar").makeQualified(FsConstants.VIEWFS_URI, null), (Object)this.fcView.makeQualified(new Path("/foo/bar")));
    }

    @Test
    public void testOperationsThroughMountLinks() throws IOException {
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/user/foo");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcView, new Path("/user/foo")), (String)"Create file should be file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "user/foo")), (String)"Target of created file should be type file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.delete(new Path("/user/foo"), false), (String)"Delete should succeed");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/foo")), (String)"File should not exist after delete");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/foo")), (String)"Target File should not exist after delete");
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/internalDir/linkToDir2/foo");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcView, new Path("/internalDir/linkToDir2/foo")), (String)"Created file should be type file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "dir2/foo")), (String)"Target of created file should be type file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.delete(new Path("/internalDir/linkToDir2/foo"), false), (String)"Delete should succeed");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcView, new Path("/internalDir/linkToDir2/foo")), (String)"File should not exist after deletion");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "dir2/foo")), (String)"Target should not exist after deletion");
        this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/internalDir/internalDir2/linkToDir3/foo");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcView, new Path("/internalDir/internalDir2/linkToDir3/foo")), (String)"Created file should be of type file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "dir3/foo")), (String)"Target of created file should also be type file");
        this.fileContextTestHelper.createFile(this.fcView, "/internalDir/linkToDir2/missingDir/miss2/foo");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcView, new Path("/internalDir/linkToDir2/missingDir/miss2/foo")), (String)"Created file should be of type file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "dir2/missingDir/miss2/foo")), (String)"Target of created file should also be type file");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.delete(new Path("/internalDir/internalDir2/linkToDir3/foo"), false), (String)"Delete should succeed");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcView, new Path("/internalDir/internalDir2/linkToDir3/foo")), (String)"Deleted File should not exist");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "dir3/foo")), (String)"Target of deleted file should not exist");
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX"), FileContext.DEFAULT_PERM, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcView, new Path("/user/dirX")), (String)"New dir should be type dir");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.targetTestRoot, "user/dirX")), (String)"Target of new dir should be of type dir");
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX/dirY"), FileContext.DEFAULT_PERM, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcView, new Path("/user/dirX/dirY")), (String)"New dir should be type dir");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.targetTestRoot, "user/dirX/dirY")), (String)"Target of new dir should be of type dir");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.delete(new Path("/user/dirX/dirY"), false), (String)"Delete should succeed");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/dirX/dirY")), (String)"Deleted File should not exist");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/dirX/dirY")), (String)"Deleted Target should not exist");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.delete(new Path("/user/dirX"), false), (String)"Delete should succeed");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/dirX")), (String)"Deleted File should not exist");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/dirX")), (String)"Deleted Target should not exist");
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        this.fcView.rename(new Path("/user/foo"), new Path("/user/fooBar"), new Options.Rename[0]);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/foo")), (String)"Renamed src should not exist");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/foo")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcView, this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/fooBar")));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.targetTestRoot, "user/fooBar")));
        this.fcView.mkdir(new Path("/user/dirFoo"), FileContext.DEFAULT_PERM, false);
        this.fcView.rename(new Path("/user/dirFoo"), new Path("/user/dirFooBar"), new Options.Rename[0]);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcView, new Path("/user/dirFoo")), (String)"Renamed src should not exist");
        org.junit.jupiter.api.Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.targetTestRoot, "user/dirFoo")), (String)"Renamed src should not exist in target");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcView, this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirFooBar")), (String)"Renamed dest should  exist as dir");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.targetTestRoot, "user/dirFooBar")), (String)"Renamed dest should  exist as dir in target");
        this.fcView.mkdir(new Path("/targetRoot/dirFoo"), FileContext.DEFAULT_PERM, false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)FileContextTestHelper.exists(this.fcView, new Path("/targetRoot/dirFoo")));
        boolean dirFooPresent = false;
        RemoteIterator dirContents = this.fcView.listStatus(new Path("/targetRoot/"));
        while (dirContents.hasNext()) {
            FileStatus fileStatus = (FileStatus)dirContents.next();
            if (!fileStatus.getPath().getName().equals("dirFoo")) continue;
            dirFooPresent = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dirFooPresent);
        RemoteIterator dirLocatedContents = this.fcView.listLocatedStatus(new Path("/targetRoot/"));
        dirFooPresent = false;
        while (dirLocatedContents.hasNext()) {
            FileStatus fileStatus = (FileStatus)dirLocatedContents.next();
            if (!fileStatus.getPath().getName().equals("dirFoo")) continue;
            dirFooPresent = true;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dirFooPresent);
    }

    @Test
    public void testRenameAcrossMounts1() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        try {
            this.fcView.rename(new Path("/user/foo"), new Path("/user2/fooBarBar"), new Options.Rename[0]);
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossMounts2() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        try {
            this.fcView.rename(new Path("/user/foo"), new Path("/data/fooBar"), new Options.Rename[0]);
            ContractTestUtils.fail((String)"IOException is not thrown on rename operation");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("Renames across Mount points not supported", e);
        }
    }

    @Test
    public void testRenameAcrossMounts3() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_TARGET_URI_ACROSS_MOUNTPOINT.toString());
        FileContext fcView2 = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        String user1Path = "/user/foo";
        this.fileContextTestHelper.createFile(fcView2, user1Path);
        String user2Path = "/user2/fooBarBar";
        Path user2Dst = new Path(user2Path);
        fcView2.rename(new Path(user1Path), user2Dst, new Options.Rename[0]);
        ContractTestUtils.assertPathDoesNotExist(fcView2, "src should not exist after rename", new Path(user1Path));
        ContractTestUtils.assertPathDoesNotExist(this.fcTarget, "src should not exist after rename", new Path(this.targetTestRoot, "user/foo"));
        ContractTestUtils.assertIsFile(fcView2, this.fileContextTestHelper.getTestRootPath(fcView2, user2Path));
        ContractTestUtils.assertIsFile(this.fcTarget, new Path(this.targetTestRoot, "user/fooBarBar"));
    }

    @Test
    public void testRenameAcrossMounts4() throws IOException {
        Configuration conf2 = new Configuration(this.conf);
        conf2.set("fs.viewfs.rename.strategy", ViewFileSystem.RenameStrategy.SAME_FILESYSTEM_ACROSS_MOUNTPOINT.toString());
        FileContext fcView2 = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)conf2);
        String userPath = "/user/foo";
        this.fileContextTestHelper.createFile(fcView2, userPath);
        String anotherMountPath = "/data/fooBar";
        Path anotherDst = new Path(anotherMountPath);
        fcView2.rename(new Path(userPath), anotherDst, new Options.Rename[0]);
        ContractTestUtils.assertPathDoesNotExist(fcView2, "src should not exist after rename", new Path(userPath));
        ContractTestUtils.assertPathDoesNotExist(this.fcTarget, "src should not exist after rename", new Path(this.targetTestRoot, "user/foo"));
        ContractTestUtils.assertIsFile(fcView2, this.fileContextTestHelper.getTestRootPath(fcView2, anotherMountPath));
        ContractTestUtils.assertIsFile(fcView2, new Path(this.targetTestRoot, "data/fooBar"));
    }

    @Test
    public void testGetBlockLocations() throws IOException {
        Path targetFilePath = new Path(this.targetTestRoot, "data/largeFile");
        FileContextTestHelper.createFile(this.fcTarget, targetFilePath, 10, 1024);
        Path viewFilePath = new Path("/data/largeFile");
        FileContextTestHelper.checkFileStatus(this.fcView, viewFilePath.toString(), FileContextTestHelper.fileType.isFile);
        BlockLocation[] viewBL = this.fcView.getFileBlockLocations(viewFilePath, 0L, 10340L);
        org.junit.jupiter.api.Assertions.assertEquals((int)(SupportsBlocks ? 10 : 1), (int)viewBL.length);
        BlockLocation[] targetBL = this.fcTarget.getFileBlockLocations(targetFilePath, 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
        this.fcView.getFileBlockLocations(viewFilePath, 0L, 10340L);
        targetBL = this.fcTarget.getFileBlockLocations(targetFilePath, 0L, 10340L);
        this.compareBLs(viewBL, targetBL);
    }

    void compareBLs(BlockLocation[] viewBL, BlockLocation[] targetBL) {
        org.junit.jupiter.api.Assertions.assertEquals((int)targetBL.length, (int)viewBL.length);
        int i = 0;
        for (BlockLocation vbl : viewBL) {
            Assertions.assertThat((String)vbl.toString()).isEqualTo((Object)targetBL[i].toString());
            Assertions.assertThat((long)vbl.getOffset()).isEqualTo(targetBL[i].getOffset());
            Assertions.assertThat((long)vbl.getLength()).isEqualTo(targetBL[i].getLength());
            ++i;
        }
    }

    @Test
    public void testListOnInternalDirsOfMountTable() throws IOException {
        FileStatus[] dirPaths = this.fcView.util().listStatus(new Path("/"));
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)dirPaths.length);
        FileStatus fs = this.fileContextTestHelper.containsPath(this.fcView, "/user", dirPaths);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/data", dirPaths);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/internalDir", dirPaths);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isDirectory(), (String)"InternalDirs should appear as dir");
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/danglingLink", dirPaths);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/linkToAFile", dirPaths);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
        dirPaths = this.fcView.util().listStatus(new Path("/internalDir"));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)dirPaths.length);
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/internalDir/internalDir2", dirPaths);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isDirectory(), (String)"InternalDirs should appear as dir");
        fs = this.fileContextTestHelper.containsPath(this.fcView, "/internalDir/linkToDir2", dirPaths);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)fs);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)fs.isSymlink(), (String)"A mount should appear as symlink");
    }

    @Test
    public void testFileStatusOnMountLink() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.getFileStatus(new Path("/")).isDirectory(), (String)"Slash should appear as dir");
            FileContextTestHelper.checkFileStatus(this.fcView, "/", FileContextTestHelper.fileType.isDir);
            FileContextTestHelper.checkFileStatus(this.fcView, "/user", FileContextTestHelper.fileType.isDir);
            FileContextTestHelper.checkFileStatus(this.fcView, "/data", FileContextTestHelper.fileType.isDir);
            FileContextTestHelper.checkFileStatus(this.fcView, "/internalDir", FileContextTestHelper.fileType.isDir);
            FileContextTestHelper.checkFileStatus(this.fcView, "/internalDir/linkToDir2", FileContextTestHelper.fileType.isDir);
            FileContextTestHelper.checkFileStatus(this.fcView, "/internalDir/internalDir2/linkToDir3", FileContextTestHelper.fileType.isDir);
            FileContextTestHelper.checkFileStatus(this.fcView, "/linkToAFile", FileContextTestHelper.fileType.isFile);
            this.fcView.getFileStatus(new Path("/danglingLink"));
        });
    }

    @Test
    public void testGetFileChecksum() throws AccessControlException, UnresolvedLinkException, IOException, URISyntaxException {
        AbstractFileSystem mockAFS = (AbstractFileSystem)Mockito.mock(AbstractFileSystem.class);
        InodeTree.ResolveResult res = new InodeTree.ResolveResult(null, (Object)mockAFS, null, new Path("someFile"), true);
        InodeTree fsState = (InodeTree)Mockito.mock(InodeTree.class);
        Mockito.when((Object)fsState.resolve(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean())).thenReturn((Object)res);
        ViewFs vfs = new ViewFs(this.conf);
        vfs.fsState = fsState;
        vfs.getFileChecksum(new Path("/tmp/someFile"));
        ((AbstractFileSystem)Mockito.verify((Object)mockAFS)).getFileChecksum(new Path("someFile"));
    }

    @Test
    public void testgetFSonDanglingLink() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> this.fcView.getFileStatus(new Path("/danglingLink")));
    }

    @Test
    public void testgetFSonNonExistingInternalDir() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> this.fcView.getFileStatus(new Path("/internalDir/nonExisting")));
    }

    @Test
    public void testgetFileLinkStatus() throws IOException {
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/user", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/data", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir/linkToDir2", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir/internalDir2/linkToDir3", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/linkToAFile", FileContextTestHelper.fileType.isSymlink);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir", FileContextTestHelper.fileType.isDir);
        FileContextTestHelper.checkFileLinkStatus(this.fcView, "/internalDir/internalDir2", FileContextTestHelper.fileType.isDir);
    }

    @Test
    public void testgetFileLinkStatusonNonExistingInternalDir() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> this.fcView.getFileLinkStatus(new Path("/internalDir/nonExisting")));
    }

    @Test
    public void testSymlinkTarget() throws IOException {
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fcView.getLinkTarget(new Path("/user")), (Object)new Path(this.targetTestRoot, "user"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fcView.getLinkTarget(new Path("/data")), (Object)new Path(this.targetTestRoot, "data"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fcView.getLinkTarget(new Path("/internalDir/linkToDir2")), (Object)new Path(this.targetTestRoot, "dir2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fcView.getLinkTarget(new Path("/internalDir/internalDir2/linkToDir3")), (Object)new Path(this.targetTestRoot, "dir3"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.fcView.getLinkTarget(new Path("/linkToAFile")), (Object)new Path(this.targetTestRoot, "aFile"));
    }

    @Test
    public void testgetLinkTargetOnNonLink() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> this.fcView.getLinkTarget(new Path("/internalDir/internalDir2")));
    }

    @Test
    public void testResolvePathInternalPaths() throws IOException {
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path("/"), (Object)this.fcView.resolvePath(new Path("/")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path("/internalDir"), (Object)this.fcView.resolvePath(new Path("/internalDir")));
    }

    @Test
    public void testResolvePathMountPoints() throws IOException {
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(this.targetTestRoot, "user"), (Object)this.fcView.resolvePath(new Path("/user")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(this.targetTestRoot, "data"), (Object)this.fcView.resolvePath(new Path("/data")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(this.targetTestRoot, "dir2"), (Object)this.fcView.resolvePath(new Path("/internalDir/linkToDir2")));
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(this.targetTestRoot, "dir3"), (Object)this.fcView.resolvePath(new Path("/internalDir/internalDir2/linkToDir3")));
    }

    @Test
    public void testResolvePathThroughMountPoints() throws IOException {
        this.fileContextTestHelper.createFile(this.fcView, "/user/foo");
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(this.targetTestRoot, "user/foo"), (Object)this.fcView.resolvePath(new Path("/user/foo")));
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX"), FileContext.DEFAULT_PERM, false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(this.targetTestRoot, "user/dirX"), (Object)this.fcView.resolvePath(new Path("/user/dirX")));
        this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX/dirY"), FileContext.DEFAULT_PERM, false);
        org.junit.jupiter.api.Assertions.assertEquals((Object)new Path(this.targetTestRoot, "user/dirX/dirY"), (Object)this.fcView.resolvePath(new Path("/user/dirX/dirY")));
    }

    @Test
    public void testResolvePathDanglingLink() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> this.fcView.resolvePath(new Path("/danglingLink")));
    }

    @Test
    public void testResolvePathMissingThroughMountPoints() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> this.fcView.resolvePath(new Path("/user/nonExisting")));
    }

    @Test
    public void testResolvePathMissingThroughMountPoints2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> {
            this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/user/dirX"), FileContext.DEFAULT_PERM, false);
            this.fcView.resolvePath(new Path("/user/dirX/nonExisting"));
        });
    }

    @Test
    public void testInternalMkdirSlash() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/"), FileContext.DEFAULT_PERM, false));
    }

    @Test
    public void testInternalMkdirExisting1() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/internalDir"), FileContext.DEFAULT_PERM, false));
    }

    @Test
    public void testInternalMkdirExisting2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/internalDir/linkToDir2"), FileContext.DEFAULT_PERM, false));
    }

    @Test
    public void testInternalMkdirNew() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/dirNew"), FileContext.DEFAULT_PERM, false));
    }

    @Test
    public void testInternalMkdirNew2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.mkdir(this.fileContextTestHelper.getTestRootPath(this.fcView, "/internalDir/dirNew"), FileContext.DEFAULT_PERM, false));
    }

    @Test
    public void testInternalCreate1() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/foo"));
    }

    @Test
    public void testInternalCreate2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fileContextTestHelper.createFileNonRecursive(this.fcView, "/internalDir/foo"));
    }

    @Test
    public void testInternalCreateMissingDir() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fileContextTestHelper.createFile(this.fcView, "/missingDir/foo"));
    }

    @Test
    public void testInternalCreateMissingDir2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fileContextTestHelper.createFile(this.fcView, "/missingDir/miss2/foo"));
    }

    @Test
    public void testInternalCreateMissingDir3() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fileContextTestHelper.createFile(this.fcView, "/internalDir/miss2/foo"));
    }

    @Test
    public void testInternalDeleteNonExisting() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> this.fcView.delete(new Path("/NonExisting"), false));
    }

    @Test
    public void testInternalDeleteNonExisting2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(FileNotFoundException.class, () -> this.fcView.delete(new Path("/internalDir/NonExisting"), false));
    }

    @Test
    public void testInternalDeleteExisting() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.delete(new Path("/internalDir"), false));
    }

    @Test
    public void testInternalDeleteExisting2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory(), (String)"Delete of link to dir should succeed");
            this.fcView.delete(new Path("/internalDir/linkToDir2"), false);
        });
    }

    @Test
    public void testInternalRename1() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.rename(new Path("/internalDir"), new Path("/newDir"), new Options.Rename[0]));
    }

    @Test
    public void testInternalRename2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)this.fcView.getFileStatus(new Path("/internalDir/linkToDir2")).isDirectory(), (String)"linkTODir2 should be a dir");
            this.fcView.rename(new Path("/internalDir/linkToDir2"), new Path("/internalDir/dir1"), new Options.Rename[0]);
        });
    }

    @Test
    public void testInternalRename3() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.rename(new Path("/user"), new Path("/internalDir/linkToDir2"), new Options.Rename[0]));
    }

    @Test
    public void testInternalRenameToSlash() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.rename(new Path("/internalDir/linkToDir2/foo"), new Path("/"), new Options.Rename[0]));
    }

    @Test
    public void testInternalRenameFromSlash() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.rename(new Path("/"), new Path("/bar"), new Options.Rename[0]));
    }

    @Test
    public void testInternalSetOwner() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.setOwner(new Path("/internalDir"), "foo", "bar"));
    }

    @Test
    public void testInternalModifyAclEntries() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.modifyAclEntries(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalRemoveAclEntries() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.removeAclEntries(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalRemoveDefaultAcl() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.removeDefaultAcl(new Path("/internalDir")));
    }

    @Test
    public void testInternalRemoveAcl() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.removeAcl(new Path("/internalDir")));
    }

    @Test
    public void testInternalSetAcl() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.setAcl(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalGetAclStatus() throws IOException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        AclStatus aclStatus = this.fcView.getAclStatus(new Path("/internalDir"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)aclStatus.getOwner(), (Object)currentUser.getUserName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)aclStatus.getGroup(), (Object)currentUser.getGroupNames()[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)aclStatus.getEntries(), (Object)AclUtil.getMinimalAcl((FsPermission)Constants.PERMISSION_555));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)aclStatus.isStickyBit());
    }

    @Test
    public void testInternalSetXAttr() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.setXAttr(new Path("/internalDir"), "xattrName", null));
    }

    @Test
    public void testInternalGetXAttr() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(NotInMountpointException.class, () -> this.fcView.getXAttr(new Path("/internalDir"), "xattrName"));
    }

    @Test
    public void testInternalGetXAttrs() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(NotInMountpointException.class, () -> this.fcView.getXAttrs(new Path("/internalDir")));
    }

    @Test
    public void testInternalGetXAttrsWithNames() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(NotInMountpointException.class, () -> this.fcView.getXAttrs(new Path("/internalDir"), new ArrayList()));
    }

    @Test
    public void testInternalListXAttr() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(NotInMountpointException.class, () -> this.fcView.listXAttrs(new Path("/internalDir")));
    }

    @Test
    public void testInternalRemoveXAttr() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.removeXAttr(new Path("/internalDir"), "xattrName"));
    }

    @Test
    public void testInternalCreateSnapshot1() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.createSnapshot(new Path("/internalDir")));
    }

    @Test
    public void testInternalCreateSnapshot2() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.createSnapshot(new Path("/internalDir"), "snap1"));
    }

    @Test
    public void testInternalRenameSnapshot() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.renameSnapshot(new Path("/internalDir"), "snapOldName", "snapNewName"));
    }

    @Test
    public void testInternalDeleteSnapshot() throws IOException {
        org.junit.jupiter.api.Assertions.assertThrows(AccessControlException.class, () -> this.fcView.deleteSnapshot(new Path("/internalDir"), "snap1"));
    }

    @Test
    public void testOwnerForInternalDir() throws IOException, InterruptedException, URISyntaxException {
        final UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"user@HADOOP.COM", (String[])new String[]{"hadoop"});
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException, URISyntaxException {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                String doAsUserName = ugi.getUserName();
                org.junit.jupiter.api.Assertions.assertEquals((Object)doAsUserName, (Object)"user@HADOOP.COM");
                FileContext viewFS = FileContext.getFileContext((URI)FsConstants.VIEWFS_URI, (Configuration)ViewFsBaseTest.this.conf);
                FileStatus stat = viewFS.getFileStatus(new Path("/internalDir"));
                org.junit.jupiter.api.Assertions.assertEquals((Object)userUgi.getShortUserName(), (Object)stat.getOwner());
                return null;
            }
        });
    }

    @Test
    public void testRespectsServerDefaults() throws Exception {
        FsServerDefaults targetDefs = this.fcTarget.getDefaultFileSystem().getServerDefaults(new Path("/"));
        FsServerDefaults viewDefs = this.fcView.getDefaultFileSystem().getServerDefaults(new Path("/data"));
        org.junit.jupiter.api.Assertions.assertEquals((short)targetDefs.getReplication(), (short)viewDefs.getReplication());
        org.junit.jupiter.api.Assertions.assertEquals((long)targetDefs.getBlockSize(), (long)viewDefs.getBlockSize());
        org.junit.jupiter.api.Assertions.assertEquals((int)targetDefs.getBytesPerChecksum(), (int)viewDefs.getBytesPerChecksum());
        org.junit.jupiter.api.Assertions.assertEquals((int)targetDefs.getFileBufferSize(), (int)viewDefs.getFileBufferSize());
        org.junit.jupiter.api.Assertions.assertEquals((int)targetDefs.getWritePacketSize(), (int)viewDefs.getWritePacketSize());
        org.junit.jupiter.api.Assertions.assertEquals((Object)targetDefs.getEncryptDataTransfer(), (Object)viewDefs.getEncryptDataTransfer());
        org.junit.jupiter.api.Assertions.assertEquals((long)targetDefs.getTrashInterval(), (long)viewDefs.getTrashInterval());
        org.junit.jupiter.api.Assertions.assertEquals((Object)targetDefs.getChecksumType(), (Object)viewDefs.getChecksumType());
        this.fcView.create(new Path("/data/file"), EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        FileStatus stat = this.fcTarget.getFileStatus(new Path(this.targetTestRoot, "data/file"));
        org.junit.jupiter.api.Assertions.assertEquals((short)targetDefs.getReplication(), (short)stat.getReplication());
    }

    @Test
    public void testServerDefaultsInternalDir() throws Exception {
        FsServerDefaults localDefs = LocalConfigKeys.getServerDefaults();
        FsServerDefaults viewDefs = this.fcView.getDefaultFileSystem().getServerDefaults(new Path("/internalDir"));
        org.junit.jupiter.api.Assertions.assertEquals((short)localDefs.getReplication(), (short)viewDefs.getReplication());
        org.junit.jupiter.api.Assertions.assertEquals((long)localDefs.getBlockSize(), (long)viewDefs.getBlockSize());
        org.junit.jupiter.api.Assertions.assertEquals((int)localDefs.getBytesPerChecksum(), (int)viewDefs.getBytesPerChecksum());
        org.junit.jupiter.api.Assertions.assertEquals((int)localDefs.getFileBufferSize(), (int)viewDefs.getFileBufferSize());
        org.junit.jupiter.api.Assertions.assertEquals((int)localDefs.getWritePacketSize(), (int)viewDefs.getWritePacketSize());
        org.junit.jupiter.api.Assertions.assertEquals((Object)localDefs.getEncryptDataTransfer(), (Object)viewDefs.getEncryptDataTransfer());
        org.junit.jupiter.api.Assertions.assertEquals((long)localDefs.getTrashInterval(), (long)viewDefs.getTrashInterval());
        org.junit.jupiter.api.Assertions.assertEquals((Object)localDefs.getChecksumType(), (Object)viewDefs.getChecksumType());
    }

    @Test
    public void testListLocatedStatus() throws IOException {
        Path mockTarget = new Path("mockfs://listLocatedStatus/foo");
        Path mountPoint = new Path("/fooMount");
        Configuration newConf = new Configuration();
        newConf.setClass("fs.AbstractFileSystem.mockfs.impl", MockFs.class, AbstractFileSystem.class);
        ConfigUtil.addLink((Configuration)newConf, (String)mountPoint.toString(), (URI)mockTarget.toUri());
        FileContext.getFileContext((URI)URI.create("viewfs:///"), (Configuration)newConf).listLocatedStatus(mountPoint);
        AbstractFileSystem mockFs = MockFs.getMockFs(mockTarget.toUri());
        ((AbstractFileSystem)Mockito.verify((Object)mockFs)).listLocatedStatus(new Path(mockTarget.toUri().getPath()));
        ((AbstractFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).listStatus((Path)ArgumentMatchers.any(Path.class));
        ((AbstractFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).listStatusIterator((Path)ArgumentMatchers.any(Path.class));
    }

    @Test
    public void testListStatusIterator() throws IOException {
        Path mockTarget = new Path("mockfs://listStatusIterator/foo");
        Path mountPoint = new Path("/fooMount");
        Configuration newConf = new Configuration();
        newConf.setClass("fs.AbstractFileSystem.mockfs.impl", MockFs.class, AbstractFileSystem.class);
        ConfigUtil.addLink((Configuration)newConf, (String)mountPoint.toString(), (URI)mockTarget.toUri());
        FileContext.getFileContext((URI)URI.create("viewfs:///"), (Configuration)newConf).listStatus(mountPoint);
        AbstractFileSystem mockFs = MockFs.getMockFs(mockTarget.toUri());
        ((AbstractFileSystem)Mockito.verify((Object)mockFs)).listStatusIterator(new Path(mockTarget.toUri().getPath()));
        ((AbstractFileSystem)Mockito.verify((Object)mockFs, (VerificationMode)Mockito.never())).listStatus((Path)ArgumentMatchers.any(Path.class));
    }

    @Test
    public void testListStatusWithNoGroups() throws Exception {
        UserGroupInformation userUgi = UserGroupInformation.createUserForTesting((String)"user@HADOOP.COM", (String[])new String[0]);
        userUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                URI viewFsUri = new URI("viewfs", ViewFsBaseTest.MOUNT_TABLE_NAME, "/", null, null);
                FileSystem vfs = FileSystem.get((URI)viewFsUri, (Configuration)ViewFsBaseTest.this.conf);
                LambdaTestUtils.intercept(IOException.class, "There is no primary group for UGI", () -> vfs.listStatus(new Path(viewFsUri.toString() + "internalDir")));
                return null;
            }
        });
    }

    static class MockFs
    extends ChRootedFs {
        private static Map<String, AbstractFileSystem> fsCache = new HashMap<String, AbstractFileSystem>();

        MockFs(URI uri, Configuration conf) throws URISyntaxException {
            super(MockFs.getMockFs(uri), new Path("/"));
        }

        static AbstractFileSystem getMockFs(URI uri) {
            AbstractFileSystem mockFs = fsCache.get(uri.getAuthority());
            if (mockFs == null) {
                mockFs = (AbstractFileSystem)Mockito.mock(AbstractFileSystem.class);
                Mockito.when((Object)mockFs.getUri()).thenReturn((Object)uri);
                Mockito.when((Object)mockFs.getUriDefaultPort()).thenReturn((Object)1);
                Mockito.when((Object)mockFs.getUriPath((Path)ArgumentMatchers.any(Path.class))).thenCallRealMethod();
                Mockito.when((Object)mockFs.isValidName(ArgumentMatchers.anyString())).thenReturn((Object)true);
                fsCache.put(uri.getAuthority(), mockFs);
            }
            return mockFs;
        }
    }
}

