/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestViewFileSystemWithAuthorityLocalFileSystem
extends ViewFileSystemBaseTest {
    URI schemeWithAuthority;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.fsTarget = FileSystem.getLocal((Configuration)new Configuration());
        super.setUp();
        this.schemeWithAuthority = new URI("viewfs", "default", "/", null, null);
        this.fsView = FileSystem.get((URI)this.schemeWithAuthority, (Configuration)this.conf);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
        super.tearDown();
    }

    @Override
    Path getTrashRootInFallBackFS() throws IOException {
        return new Path("/.Trash/" + UserGroupInformation.getCurrentUser().getShortUserName());
    }

    @Override
    @Test
    public void testBasicPaths() {
        Assertions.assertEquals((Object)this.schemeWithAuthority, (Object)this.fsView.getUri());
        Assertions.assertEquals((Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fsView.getWorkingDirectory());
        Assertions.assertEquals((Object)this.fsView.makeQualified(new Path("/user/" + System.getProperty("user.name"))), (Object)this.fsView.getHomeDirectory());
        Assertions.assertEquals((Object)new Path("/foo/bar").makeQualified(this.schemeWithAuthority, null), (Object)this.fsView.makeQualified(new Path("/foo/bar")));
    }
}

