/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.ViewFileSystemBaseTest;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestViewFileSystemLocalFileSystem
extends ViewFileSystemBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestViewFileSystemLocalFileSystem.class);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.fsTarget = FileSystem.getLocal((Configuration)new Configuration());
        super.setUp();
    }

    @Override
    Path getTrashRootInFallBackFS() throws IOException {
        return new Path("/.Trash/" + UserGroupInformation.getCurrentUser().getShortUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNflyWriteSimple() throws IOException {
        LOG.info("Starting testNflyWriteSimple");
        URI[] testUris = new URI[]{URI.create(this.targetTestRoot + "/nfwd1"), URI.create(this.targetTestRoot + "/nfwd2")};
        String testFileName = "test.txt";
        Configuration testConf = new Configuration(this.conf);
        String testString = "Hello Nfly!";
        Path nflyRoot = new Path("/nflyroot");
        ConfigUtil.addLinkNfly((Configuration)testConf, (String)nflyRoot.toString(), (URI[])testUris);
        FileSystem nfly = FileSystem.get((URI)URI.create("viewfs:///"), (Configuration)testConf);
        try (FSDataOutputStream fsDos = nfly.create(new Path(nflyRoot, "test.txt"));){
            fsDos.writeUTF("Hello Nfly!");
        }
        FileStatus[] statuses = nfly.listStatus(nflyRoot);
        LocalFileSystem lfs = FileSystem.getLocal((Configuration)testConf);
        for (URI testUri : testUris) {
            Path testFile = new Path(new Path(testUri), "test.txt");
            Assertions.assertTrue((boolean)lfs.exists(testFile), (String)(testFile + " should exist!"));
            try (FSDataInputStream fsdis = lfs.open(testFile);){
                Assertions.assertEquals((Object)fsdis.readUTF(), (Object)"Hello Nfly!", (String)"Wrong file content");
            }
        }
    }

    @Test
    public void testNflyInvalidMinReplication() throws Exception {
        LOG.info("Starting testNflyInvalidMinReplication");
        URI[] testUris = new URI[]{URI.create(this.targetTestRoot + "/nfwd1"), URI.create(this.targetTestRoot + "/nfwd2")};
        Configuration conf = new Configuration();
        ConfigUtil.addLinkNfly((Configuration)conf, (String)"mt", (String)"/nflyroot", (String)"minReplication=4", (URI[])testUris);
        try {
            FileSystem.get((URI)URI.create("viewfs://mt/"), (Configuration)conf);
            Assertions.fail((String)"Expected bad minReplication exception.");
        }
        catch (IOException ioe) {
            Assertions.assertTrue((boolean)ioe.getMessage().contains("Minimum replication"), (String)"No minReplication message");
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.fsTarget.delete(this.fileSystemTestHelper.getTestRootPath(this.fsTarget), true);
        super.tearDown();
    }
}

