/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.fs.viewfs.ConfigUtil;
import org.apache.hadoop.fs.viewfs.TestChRootedFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.fs.viewfs.ViewFileSystemTestSetup;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestViewFileSystemDelegationTokenSupport {
    private static final String MOUNT_TABLE_NAME = "vfs-cluster";
    static Configuration conf;
    static FileSystem viewFs;
    static FakeFileSystem fs1;
    static FakeFileSystem fs2;

    @BeforeAll
    public static void setup() throws Exception {
        conf = ViewFileSystemTestSetup.createConfig();
        TestViewFileSystemDelegationTokenSupport.setupFileSystem(new URI("fs1:///"), FakeFileSystem.class);
        TestViewFileSystemDelegationTokenSupport.setupFileSystem(new URI("fs2:///"), FakeFileSystem.class);
        viewFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        fs1 = (FakeFileSystem)TestChRootedFileSystem.getChildFileSystem((ViewFileSystem)viewFs, new URI("fs1:///"));
        fs2 = (FakeFileSystem)TestChRootedFileSystem.getChildFileSystem((ViewFileSystem)viewFs, new URI("fs2:///"));
    }

    static void setupFileSystem(URI uri, Class<? extends FileSystem> clazz) throws Exception {
        String scheme = uri.getScheme();
        conf.set("fs." + scheme + ".impl", clazz.getName());
        FakeFileSystem fs = (FakeFileSystem)FileSystem.get((URI)uri, (Configuration)conf);
        ConfigUtil.addLink((Configuration)conf, (String)("/mounts/" + scheme + "-one"), (URI)fs.getUri());
        ConfigUtil.addLink((Configuration)conf, (String)("/mounts/" + scheme + "-two"), (URI)fs.getUri());
    }

    @Test
    public void testGetCanonicalServiceNameWithNonDefaultMountTable() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)MOUNT_TABLE_NAME, (String)"/user", (URI)new URI("file:///"));
        FileSystem viewFs = FileSystem.get((URI)new URI("viewfs://vfs-cluster"), (Configuration)conf);
        String serviceName = viewFs.getCanonicalServiceName();
        Assertions.assertNull((Object)serviceName);
    }

    @Test
    public void testGetCanonicalServiceNameWithDefaultMountTable() throws URISyntaxException, IOException {
        Configuration conf = new Configuration();
        ConfigUtil.addLink((Configuration)conf, (String)"/user", (URI)new URI("file:///"));
        FileSystem viewFs = FileSystem.get((URI)FsConstants.VIEWFS_URI, (Configuration)conf);
        String serviceName = viewFs.getCanonicalServiceName();
        Assertions.assertNull((Object)serviceName);
    }

    @Test
    public void testGetChildFileSystems() throws Exception {
        Assertions.assertNull((Object)fs1.getChildFileSystems());
        Assertions.assertNull((Object)fs2.getChildFileSystems());
        List<FileSystem> children = Arrays.asList(viewFs.getChildFileSystems());
        Assertions.assertEquals((int)2, (int)children.size());
        Assertions.assertTrue((boolean)children.contains((Object)fs1));
        Assertions.assertTrue((boolean)children.contains((Object)fs2));
    }

    @Test
    public void testAddDelegationTokens() throws Exception {
        Credentials creds = new Credentials();
        Token<?>[] fs1Tokens = this.addTokensWithCreds((FileSystem)fs1, creds);
        Assertions.assertEquals((int)1, (int)fs1Tokens.length);
        Assertions.assertEquals((int)1, (int)creds.numberOfTokens());
        Token<?>[] fs2Tokens = this.addTokensWithCreds((FileSystem)fs2, creds);
        Assertions.assertEquals((int)1, (int)fs2Tokens.length);
        Assertions.assertEquals((int)2, (int)creds.numberOfTokens());
        Credentials savedCreds = creds;
        creds = new Credentials();
        Token[] viewFsTokens = viewFs.addDelegationTokens("me", creds);
        Assertions.assertEquals((int)2, (int)viewFsTokens.length);
        Assertions.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assertions.assertEquals((int)savedCreds.numberOfTokens(), (int)creds.numberOfTokens());
        viewFsTokens = viewFs.addDelegationTokens("me", creds);
        Assertions.assertEquals((int)0, (int)viewFsTokens.length);
        Assertions.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assertions.assertEquals((int)savedCreds.numberOfTokens(), (int)creds.numberOfTokens());
    }

    Token<?>[] addTokensWithCreds(FileSystem fs, Credentials creds) throws Exception {
        Credentials savedCreds = new Credentials(creds);
        Token[] tokens = fs.addDelegationTokens("me", creds);
        Assertions.assertEquals((int)1, (int)tokens.length);
        Assertions.assertEquals((Object)fs.getCanonicalServiceName(), (Object)tokens[0].getService().toString());
        Assertions.assertTrue((boolean)creds.getAllTokens().contains(tokens[0]));
        Assertions.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assertions.assertEquals((int)(savedCreds.numberOfTokens() + 1), (int)creds.numberOfTokens());
        savedCreds = new Credentials(creds);
        Token[] tokenRefetch = fs.addDelegationTokens("me", creds);
        Assertions.assertEquals((int)0, (int)tokenRefetch.length);
        Assertions.assertTrue((boolean)creds.getAllTokens().containsAll(savedCreds.getAllTokens()));
        Assertions.assertEquals((int)savedCreds.numberOfTokens(), (int)creds.numberOfTokens());
        return tokens;
    }

    static class FakeFileSystem
    extends RawLocalFileSystem {
        URI uri;

        FakeFileSystem() {
        }

        public void initialize(URI name, Configuration conf) throws IOException {
            this.uri = name;
        }

        public Path getInitialWorkingDirectory() {
            return new Path("/");
        }

        public URI getUri() {
            return this.uri;
        }

        public String getCanonicalServiceName() {
            return String.valueOf(this.getUri() + "/" + ((Object)((Object)this)).hashCode());
        }

        public Token<?> getDelegationToken(String renewer) throws IOException {
            Token token = new Token();
            token.setService(new Text(this.getCanonicalServiceName()));
            return token;
        }

        public void close() {
        }
    }
}

