/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.viewfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileContextTestHelper;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsConstants;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.viewfs.ChRootedFs;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

public class TestChRootedFs {
    FileContextTestHelper fileContextTestHelper = new FileContextTestHelper();
    FileContext fc;
    FileContext fcTarget;
    Path chrootedTo;

    @BeforeEach
    public void setUp() throws Exception {
        this.fcTarget = FileContext.getLocalFSFileContext();
        this.chrootedTo = this.fileContextTestHelper.getAbsoluteTestRootPath(this.fcTarget);
        this.fcTarget.delete(this.chrootedTo, true);
        this.fcTarget.mkdir(this.chrootedTo, FileContext.DEFAULT_PERM, true);
        Configuration conf = new Configuration();
        this.fc = FileContext.getFileContext((AbstractFileSystem)new ChRootedFs(this.fcTarget.getDefaultFileSystem(), this.chrootedTo), (Configuration)conf);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.fcTarget.delete(this.chrootedTo, true);
    }

    @Test
    public void testBasicPaths() {
        URI uri = this.fc.getDefaultFileSystem().getUri();
        Assertions.assertEquals((Object)this.chrootedTo.toUri(), (Object)uri);
        Assertions.assertEquals((Object)this.fc.makeQualified(new Path(System.getProperty("user.home"))), (Object)this.fc.getWorkingDirectory());
        Assertions.assertEquals((Object)this.fc.makeQualified(new Path(System.getProperty("user.home"))), (Object)this.fc.getHomeDirectory());
        Assertions.assertEquals((Object)new Path("/foo/bar").makeQualified(FsConstants.LOCAL_FS_URI, null), (Object)this.fc.makeQualified(new Path("/foo/bar")));
    }

    @Test
    public void testCreateDelete() throws IOException {
        this.fileContextTestHelper.createFileNonRecursive(this.fc, "/foo");
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, new Path("/foo")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "foo")));
        this.fileContextTestHelper.createFile(this.fc, "/newDir/foo");
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, new Path("/newDir/foo")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "newDir/foo")));
        Assertions.assertTrue((boolean)this.fc.delete(new Path("/newDir/foo"), false));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/foo")));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/foo")));
        this.fileContextTestHelper.createFile(this.fc, "/newDir/newDir2/foo");
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, new Path("/newDir/newDir2/foo")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "newDir/newDir2/foo")));
        Assertions.assertTrue((boolean)this.fc.delete(new Path("/newDir/newDir2/foo"), false));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/newDir2/foo")));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/newDir2/foo")));
    }

    @Test
    public void testMkdirDelete() throws IOException {
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc, "/dirX"), FileContext.DEFAULT_PERM, false);
        Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, new Path("/dirX")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.chrootedTo, "dirX")));
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc, "/dirX/dirY"), FileContext.DEFAULT_PERM, false);
        Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, new Path("/dirX/dirY")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.chrootedTo, "dirX/dirY")));
        Assertions.assertTrue((boolean)this.fc.delete(new Path("/dirX/dirY"), false));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/dirX/dirY")));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "dirX/dirY")));
        Assertions.assertTrue((boolean)this.fc.delete(new Path("/dirX"), false));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/dirX")));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "dirX")));
    }

    @Test
    public void testRename() throws IOException {
        this.fileContextTestHelper.createFile(this.fc, "/newDir/foo");
        this.fc.rename(new Path("/newDir/foo"), new Path("/newDir/fooBar"), new Options.Rename[0]);
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/foo")));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/foo")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fc, this.fileContextTestHelper.getTestRootPath(this.fc, "/newDir/fooBar")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isFile(this.fcTarget, new Path(this.chrootedTo, "newDir/fooBar")));
        this.fc.mkdir(new Path("/newDir/dirFoo"), FileContext.DEFAULT_PERM, false);
        this.fc.rename(new Path("/newDir/dirFoo"), new Path("/newDir/dirFooBar"), new Options.Rename[0]);
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fc, new Path("/newDir/dirFoo")));
        Assertions.assertFalse((boolean)FileContextTestHelper.exists(this.fcTarget, new Path(this.chrootedTo, "newDir/dirFoo")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, this.fileContextTestHelper.getTestRootPath(this.fc, "/newDir/dirFooBar")));
        Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fcTarget, new Path(this.chrootedTo, "newDir/dirFooBar")));
    }

    @Test
    public void testRenameAcrossFs() throws IOException {
        this.fc.mkdir(new Path("/newDir/dirFoo"), FileContext.DEFAULT_PERM, true);
        this.fc.rename(new Path("/newDir/dirFoo"), new Path("file:///dirFooBar"), new Options.Rename[0]);
        FileContextTestHelper.isDir(this.fc, new Path("/dirFooBar"));
    }

    @Test
    public void testList() throws IOException {
        FileStatus fs = this.fc.getFileStatus(new Path("/"));
        Assertions.assertTrue((boolean)fs.isDirectory());
        Assertions.assertEquals((Object)fs.getPath(), (Object)this.chrootedTo);
        FileStatus[] dirPaths = this.fc.util().listStatus(new Path("/"));
        Assertions.assertEquals((int)0, (int)dirPaths.length);
        this.fileContextTestHelper.createFileNonRecursive(this.fc, "/foo");
        this.fileContextTestHelper.createFileNonRecursive(this.fc, "/bar");
        this.fc.mkdir(new Path("/dirX"), FileContext.DEFAULT_PERM, false);
        this.fc.mkdir(this.fileContextTestHelper.getTestRootPath(this.fc, "/dirY"), FileContext.DEFAULT_PERM, false);
        this.fc.mkdir(new Path("/dirX/dirXX"), FileContext.DEFAULT_PERM, false);
        dirPaths = this.fc.util().listStatus(new Path("/"));
        Assertions.assertEquals((int)4, (int)dirPaths.length);
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "foo", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isFile());
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "bar", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isFile());
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "dirX", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isDirectory());
        fs = this.fileContextTestHelper.containsPath(this.fcTarget, "dirY", dirPaths);
        Assertions.assertNotNull((Object)fs);
        Assertions.assertTrue((boolean)fs.isDirectory());
    }

    @Test
    public void testWorkingDirectory() throws Exception {
        this.fc.mkdir(new Path("/testWd"), FileContext.DEFAULT_PERM, false);
        Path workDir = new Path("/testWd");
        Path fqWd = this.fc.makeQualified(workDir);
        this.fc.setWorkingDirectory(workDir);
        Assertions.assertEquals((Object)fqWd, (Object)this.fc.getWorkingDirectory());
        this.fc.setWorkingDirectory(new Path("."));
        Assertions.assertEquals((Object)fqWd, (Object)this.fc.getWorkingDirectory());
        this.fc.setWorkingDirectory(new Path(".."));
        Assertions.assertEquals((Object)fqWd.getParent(), (Object)this.fc.getWorkingDirectory());
        workDir = new Path("/testWd");
        fqWd = this.fc.makeQualified(workDir);
        this.fc.setWorkingDirectory(workDir);
        Assertions.assertEquals((Object)fqWd, (Object)this.fc.getWorkingDirectory());
        Path relativeDir = new Path("existingDir1");
        Path absoluteDir = new Path(workDir, "existingDir1");
        this.fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        Path fqAbsoluteDir = this.fc.makeQualified(absoluteDir);
        this.fc.setWorkingDirectory(relativeDir);
        Assertions.assertEquals((Object)fqAbsoluteDir, (Object)this.fc.getWorkingDirectory());
        absoluteDir = new Path("/test/existingDir2");
        fqAbsoluteDir = this.fc.makeQualified(absoluteDir);
        this.fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        this.fc.setWorkingDirectory(absoluteDir);
        Assertions.assertEquals((Object)fqAbsoluteDir, (Object)this.fc.getWorkingDirectory());
        Path absolutePath = new Path(absoluteDir, "foo");
        this.fc.create(absolutePath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[0]).close();
        this.fc.open(new Path("foo")).close();
        this.fc.mkdir(new Path("newDir"), FileContext.DEFAULT_PERM, true);
        Assertions.assertTrue((boolean)FileContextTestHelper.isDir(this.fc, new Path(absoluteDir, "newDir")));
        absoluteDir = this.fileContextTestHelper.getTestRootPath(this.fc, "nonexistingPath");
        try {
            this.fc.setWorkingDirectory(absoluteDir);
            Assertions.fail((String)"cd to non existing dir should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String LOCAL_FS_ROOT_URI = "file:///tmp/test";
        absoluteDir = new Path("file:///tmp/test/existingDir");
        this.fc.mkdir(absoluteDir, FileContext.DEFAULT_PERM, true);
        this.fc.setWorkingDirectory(absoluteDir);
        Assertions.assertEquals((Object)absoluteDir, (Object)this.fc.getWorkingDirectory());
    }

    @Test
    public void testResolvePath() throws IOException {
        Assertions.assertEquals((Object)this.chrootedTo, (Object)this.fc.getDefaultFileSystem().resolvePath(new Path("/")));
        this.fileContextTestHelper.createFile(this.fc, "/foo");
        Assertions.assertEquals((Object)new Path(this.chrootedTo, "foo"), (Object)this.fc.getDefaultFileSystem().resolvePath(new Path("/foo")));
    }

    @Test
    public void testResolvePathNonExisting() throws IOException {
        Assertions.assertThrows(FileNotFoundException.class, () -> this.fc.getDefaultFileSystem().resolvePath(new Path("/nonExisting")));
    }

    @Test
    public void testIsValidNameValidInBaseFs() throws Exception {
        AbstractFileSystem baseFs = (AbstractFileSystem)Mockito.spy((Object)this.fc.getDefaultFileSystem());
        ChRootedFs chRootedFs = new ChRootedFs(baseFs, new Path("/chroot"));
        ((AbstractFileSystem)Mockito.doReturn((Object)true).when((Object)baseFs)).isValidName(Mockito.anyString());
        Assertions.assertTrue((boolean)chRootedFs.isValidName("/test"));
        ((AbstractFileSystem)Mockito.verify((Object)baseFs)).isValidName("/chroot/test");
    }

    @Test
    public void testIsValidNameInvalidInBaseFs() throws Exception {
        AbstractFileSystem baseFs = (AbstractFileSystem)Mockito.spy((Object)this.fc.getDefaultFileSystem());
        ChRootedFs chRootedFs = new ChRootedFs(baseFs, new Path("/chroot"));
        ((AbstractFileSystem)Mockito.doReturn((Object)false).when((Object)baseFs)).isValidName(Mockito.anyString());
        Assertions.assertFalse((boolean)chRootedFs.isValidName("/test"));
        ((AbstractFileSystem)Mockito.verify((Object)baseFs)).isValidName("/chroot/test");
    }

    @Test
    @Timeout(value=30L)
    public void testCreateSnapshot() throws Exception {
        Path snapRootPath = new Path("/snapPath");
        Path chRootedSnapRootPath = new Path(Path.getPathWithoutSchemeAndAuthority((Path)this.chrootedTo), "snapPath");
        AbstractFileSystem baseFs = (AbstractFileSystem)Mockito.spy((Object)this.fc.getDefaultFileSystem());
        ChRootedFs chRootedFs = new ChRootedFs(baseFs, this.chrootedTo);
        ((AbstractFileSystem)Mockito.doReturn((Object)snapRootPath).when((Object)baseFs)).createSnapshot(chRootedSnapRootPath, "snap1");
        Assertions.assertEquals((Object)snapRootPath, (Object)chRootedFs.createSnapshot(snapRootPath, "snap1"));
        ((AbstractFileSystem)Mockito.verify((Object)baseFs)).createSnapshot(chRootedSnapRootPath, "snap1");
    }

    @Test
    @Timeout(value=30L)
    public void testDeleteSnapshot() throws Exception {
        Path snapRootPath = new Path("/snapPath");
        Path chRootedSnapRootPath = new Path(Path.getPathWithoutSchemeAndAuthority((Path)this.chrootedTo), "snapPath");
        AbstractFileSystem baseFs = (AbstractFileSystem)Mockito.spy((Object)this.fc.getDefaultFileSystem());
        ChRootedFs chRootedFs = new ChRootedFs(baseFs, this.chrootedTo);
        ((AbstractFileSystem)Mockito.doNothing().when((Object)baseFs)).deleteSnapshot(chRootedSnapRootPath, "snap1");
        chRootedFs.deleteSnapshot(snapRootPath, "snap1");
        ((AbstractFileSystem)Mockito.verify((Object)baseFs)).deleteSnapshot(chRootedSnapRootPath, "snap1");
    }

    @Test
    @Timeout(value=30L)
    public void testRenameSnapshot() throws Exception {
        Path snapRootPath = new Path("/snapPath");
        Path chRootedSnapRootPath = new Path(Path.getPathWithoutSchemeAndAuthority((Path)this.chrootedTo), "snapPath");
        AbstractFileSystem baseFs = (AbstractFileSystem)Mockito.spy((Object)this.fc.getDefaultFileSystem());
        ChRootedFs chRootedFs = new ChRootedFs(baseFs, this.chrootedTo);
        ((AbstractFileSystem)Mockito.doNothing().when((Object)baseFs)).renameSnapshot(chRootedSnapRootPath, "snapOldName", "snapNewName");
        chRootedFs.renameSnapshot(snapRootPath, "snapOldName", "snapNewName");
        ((AbstractFileSystem)Mockito.verify((Object)baseFs)).renameSnapshot(chRootedSnapRootPath, "snapOldName", "snapNewName");
    }
}

