/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.store;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSBuilder;
import org.apache.hadoop.fs.impl.FSBuilderSupport;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFSBuilderSupport
extends AbstractHadoopTestBase {
    @Test
    public void testOptFloatDoubleForwardsToLong() throws Throwable {
        FSBuilderSupport c = (FSBuilderSupport)((SimpleBuilder)((SimpleBuilder)this.builder().opt("f", 1.8f)).opt("d", 2000.0)).build();
        Assertions.assertThat((long)c.getLong("f", 2L)).isEqualTo(1L);
        Assertions.assertThat((long)c.getLong("d", 2L)).isEqualTo(2000L);
    }

    @Test
    public void testMustFloatDoubleForwardsToLong() throws Throwable {
        FSBuilderSupport c = (FSBuilderSupport)((SimpleBuilder)((SimpleBuilder)this.builder().must("f", 1.8f)).must("d", 2000.0)).build();
        Assertions.assertThat((long)c.getLong("f", 2L)).isEqualTo(1L);
        Assertions.assertThat((long)c.getLong("d", 2L)).isEqualTo(2000L);
    }

    @Test
    public void testLongOptStillWorks() throws Throwable {
        FSBuilderSupport c = (FSBuilderSupport)((SimpleBuilder)((SimpleBuilder)this.builder().opt("o", 1L)).must("m", 1L)).build();
        Assertions.assertThat((long)c.getLong("o", 2L)).isEqualTo(1L);
        Assertions.assertThat((long)c.getLong("m", 2L)).isEqualTo(1L);
    }

    @Test
    public void testFloatParseFallback() throws Throwable {
        FSBuilderSupport c = (FSBuilderSupport)((SimpleBuilder)((SimpleBuilder)this.builder().opt("f", "1.8f")).opt("d", "1.8e20")).build();
        Assertions.assertThat((long)c.getLong("f", 2L)).isEqualTo(2L);
        Assertions.assertThat((long)c.getLong("d", 2L)).isEqualTo(2L);
    }

    @Test
    public void testNegatives() throws Throwable {
        FSBuilderSupport c = (FSBuilderSupport)((SimpleBuilder)((SimpleBuilder)this.builder().optLong("-1", -1L)).mustLong("-2", -2L)).build();
        Assertions.assertThat((long)c.getLong("-1", 2L)).isEqualTo(-1L);
        Assertions.assertThat((long)c.getPositiveLong("-1", 2L)).isEqualTo(2L);
    }

    @Test
    public void testBoolean() throws Throwable {
        FSBuilderSupport c = (FSBuilderSupport)((SimpleBuilder)((SimpleBuilder)((SimpleBuilder)this.builder().opt("f", false)).opt("t", true)).opt("o", "other")).build();
        Assertions.assertThat((boolean)c.getOptions().getBoolean("f", true)).isEqualTo(false);
        Assertions.assertThat((boolean)c.getOptions().getBoolean("t", false)).isEqualTo(true);
        Assertions.assertThat((boolean)c.getOptions().getBoolean("o", true)).isEqualTo(true);
    }

    private SimpleBuilder builder() {
        return new BuilderImpl();
    }

    private static final class BuilderImpl
    implements SimpleBuilder {
        private final Configuration options = new Configuration(false);

        private BuilderImpl() {
        }

        public SimpleBuilder opt(@Nonnull String key, @Nonnull String value) {
            this.options.set(key, value);
            return this;
        }

        public SimpleBuilder opt(@Nonnull String key, String ... values) {
            this.options.setStrings(key, values);
            return this;
        }

        public SimpleBuilder must(@Nonnull String key, @Nonnull String value) {
            return this.opt(key, value);
        }

        public SimpleBuilder must(@Nonnull String key, String ... values) {
            return this.opt(key, values);
        }

        public FSBuilderSupport build() throws IllegalArgumentException, UnsupportedOperationException, IOException {
            return new FSBuilderSupport(this.options);
        }
    }

    private static interface SimpleBuilder
    extends FSBuilder<FSBuilderSupport, SimpleBuilder> {
    }
}

