/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.store;

import java.io.IOException;
import org.apache.hadoop.fs.store.EtagChecksum;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEtagChecksum
extends Assertions {
    private final EtagChecksum empty1 = this.tag("");
    private final EtagChecksum empty2 = this.tag("");
    private final EtagChecksum valid1 = this.tag("valid");
    private final EtagChecksum valid2 = this.tag("valid");

    @Test
    public void testEmptyTagsEqual() {
        TestEtagChecksum.assertEquals((Object)this.empty1, (Object)this.empty2);
    }

    @Test
    public void testEmptyTagRoundTrip() throws Throwable {
        TestEtagChecksum.assertEquals((Object)this.empty1, (Object)this.roundTrip(this.empty1));
    }

    @Test
    public void testValidTagsEqual() {
        TestEtagChecksum.assertEquals((Object)this.valid1, (Object)this.valid2);
    }

    @Test
    public void testValidTagRoundTrip() throws Throwable {
        TestEtagChecksum.assertEquals((Object)this.valid1, (Object)this.roundTrip(this.valid1));
    }

    @Test
    public void testValidAndEmptyTagsDontMatch() {
        TestEtagChecksum.assertNotEquals((Object)this.valid1, (Object)this.empty1);
        TestEtagChecksum.assertNotEquals((Object)this.valid1, (Object)this.tag("other valid one"));
    }

    @Test
    public void testDifferentTagsDontMatch() {
        TestEtagChecksum.assertNotEquals((Object)this.valid1, (Object)this.tag("other valid one"));
    }

    private EtagChecksum tag(String t) {
        return new EtagChecksum(t);
    }

    /*
     * Exception decompiling
     */
    private EtagChecksum roundTrip(EtagChecksum tag) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

