/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.statistics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.fs.statistics.IOStatisticAssertions;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSetters;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.MeanStatistic;
import org.apache.hadoop.fs.statistics.impl.ForwardingIOStatisticsStore;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestIOStatisticsSetters
extends AbstractHadoopTestBase {
    public static final String COUNTER = "counter";
    public static final String GAUGE = "gauge";
    public static final String MAXIMUM = "max";
    public static final String MINIMUM = "min";
    public static final String MEAN = "mean";
    private IOStatisticsSetters ioStatistics;
    private boolean createsNewEntries;

    public static Collection<Object[]> params() {
        return Arrays.asList({"IOStatisticsSnapshot", new IOStatisticsSnapshot(), true}, {"IOStatisticsStore", TestIOStatisticsSetters.createTestStore(), false}, {"ForwardingIOStatisticsStore", new ForwardingIOStatisticsStore(TestIOStatisticsSetters.createTestStore()), false});
    }

    private static IOStatisticsStore createTestStore() {
        return IOStatisticsBinding.iostatisticsStore().withCounters(new String[]{COUNTER}).withGauges(new String[]{GAUGE}).withMaximums(new String[]{MAXIMUM}).withMinimums(new String[]{MINIMUM}).withMeanStatistics(new String[]{MEAN}).build();
    }

    public void initTestIOStatisticsSetters(String source, IOStatisticsSetters pIoStatisticsSetters, boolean pCreatesNewEntries) {
        this.ioStatistics = pIoStatisticsSetters;
        this.createsNewEntries = pCreatesNewEntries;
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"params"})
    public void testCounter(String source, IOStatisticsSetters pIoStatisticsSetters, boolean pCreatesNewEntries) throws Throwable {
        this.initTestIOStatisticsSetters(source, pIoStatisticsSetters, pCreatesNewEntries);
        this.ioStatistics.setCounter(COUNTER, 1L);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)this.ioStatistics, COUNTER).isEqualTo(1L);
        this.ioStatistics.setCounter(COUNTER, 2L);
        IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)this.ioStatistics, COUNTER).isEqualTo(2L);
        String unknown = "unknown";
        this.ioStatistics.setCounter("unknown", 3L);
        if (this.createsNewEntries) {
            IOStatisticAssertions.assertThatStatisticCounter((IOStatistics)this.ioStatistics, "unknown").isEqualTo(3L);
        } else {
            ((MapAssert)Assertions.assertThat((Map)this.ioStatistics.counters()).describedAs("Counter map in {}", new Object[]{this.ioStatistics})).doesNotContainKey((Object)"unknown");
        }
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"params"})
    public void testMaximum(String source, IOStatisticsSetters pIoStatisticsSetters, boolean pCreatesNewEntries) throws Throwable {
        this.initTestIOStatisticsSetters(source, pIoStatisticsSetters, pCreatesNewEntries);
        this.ioStatistics.setMaximum(MAXIMUM, 1L);
        IOStatisticAssertions.assertThatStatisticMaximum((IOStatistics)this.ioStatistics, MAXIMUM).isEqualTo(1L);
        this.ioStatistics.setMaximum(MAXIMUM, 2L);
        IOStatisticAssertions.assertThatStatisticMaximum((IOStatistics)this.ioStatistics, MAXIMUM).isEqualTo(2L);
        this.ioStatistics.setMaximum("mm2", 3L);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"params"})
    public void testMinimum(String source, IOStatisticsSetters pIoStatisticsSetters, boolean pCreatesNewEntries) throws Throwable {
        this.initTestIOStatisticsSetters(source, pIoStatisticsSetters, pCreatesNewEntries);
        this.ioStatistics.setMinimum(MINIMUM, 1L);
        IOStatisticAssertions.assertThatStatisticMinimum((IOStatistics)this.ioStatistics, MINIMUM).isEqualTo(1L);
        this.ioStatistics.setMinimum(MINIMUM, 2L);
        IOStatisticAssertions.assertThatStatisticMinimum((IOStatistics)this.ioStatistics, MINIMUM).isEqualTo(2L);
        this.ioStatistics.setMinimum("c2", 3L);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"params"})
    public void testGauge(String source, IOStatisticsSetters pIoStatisticsSetters, boolean pCreatesNewEntries) throws Throwable {
        this.initTestIOStatisticsSetters(source, pIoStatisticsSetters, pCreatesNewEntries);
        this.ioStatistics.setGauge(GAUGE, 1L);
        IOStatisticAssertions.assertThatStatisticGauge((IOStatistics)this.ioStatistics, GAUGE).isEqualTo(1L);
        this.ioStatistics.setGauge(GAUGE, 2L);
        IOStatisticAssertions.assertThatStatisticGauge((IOStatistics)this.ioStatistics, GAUGE).isEqualTo(2L);
        this.ioStatistics.setGauge("g2", 3L);
    }

    @ParameterizedTest(name="{0}")
    @MethodSource(value={"params"})
    public void testMean(String source, IOStatisticsSetters pIoStatisticsSetters, boolean pCreatesNewEntries) throws Throwable {
        this.initTestIOStatisticsSetters(source, pIoStatisticsSetters, pCreatesNewEntries);
        MeanStatistic mean11 = new MeanStatistic(1L, 1L);
        this.ioStatistics.setMeanStatistic(MEAN, mean11);
        IOStatisticAssertions.assertThatStatisticMean((IOStatistics)this.ioStatistics, MEAN).isEqualTo((Object)mean11);
        MeanStatistic mean22 = new MeanStatistic(2L, 2L);
        this.ioStatistics.setMeanStatistic(MEAN, mean22);
        IOStatisticAssertions.assertThatStatisticMean((IOStatistics)this.ioStatistics, MEAN).isEqualTo((Object)mean22);
        this.ioStatistics.setMeanStatistic("m2", mean11);
    }
}

