/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestXAttrCommands {
    private final ByteArrayOutputStream errContent = new ByteArrayOutputStream();
    private Configuration conf = null;
    private PrintStream initialStdErr;

    @BeforeEach
    public void setup() throws IOException {
        this.errContent.reset();
        this.initialStdErr = System.err;
        System.setErr(new PrintStream(this.errContent));
        this.conf = new Configuration();
    }

    @AfterEach
    public void cleanUp() throws Exception {
        this.errContent.reset();
        System.setErr(this.initialStdErr);
    }

    @Test
    public void testGetfattrValidations() throws Exception {
        this.errContent.reset();
        Assertions.assertFalse((0 == this.runCommand(new String[]{"-getfattr", "-d"}) ? 1 : 0) != 0, (String)"getfattr should fail without path");
        Assertions.assertTrue((boolean)this.errContent.toString().contains("<path> is missing"));
        this.errContent.reset();
        Assertions.assertFalse((0 == this.runCommand(new String[]{"-getfattr", "extra", "-d", "/test"}) ? 1 : 0) != 0, (String)"getfattr should fail with extra argument");
        Assertions.assertTrue((boolean)this.errContent.toString().contains("Too many arguments"));
        this.errContent.reset();
        Assertions.assertFalse((0 == this.runCommand(new String[]{"-getfattr", "/test"}) ? 1 : 0) != 0, (String)"getfattr should fail without \"-n name\" or \"-d\"");
        Assertions.assertTrue((boolean)this.errContent.toString().contains("Must specify '-n name' or '-d' option"));
        this.errContent.reset();
        Assertions.assertFalse((0 == this.runCommand(new String[]{"-getfattr", "-d", "-e", "aaa", "/test"}) ? 1 : 0) != 0, (String)"getfattr should fail with invalid encoding");
        Assertions.assertTrue((boolean)this.errContent.toString().contains("Invalid/unsupported encoding option specified: aaa"));
    }

    @Test
    public void testSetfattrValidations() throws Exception {
        this.errContent.reset();
        Assertions.assertFalse((0 == this.runCommand(new String[]{"-setfattr", "-n", "user.a1"}) ? 1 : 0) != 0, (String)"setfattr should fail without path");
        Assertions.assertTrue((boolean)this.errContent.toString().contains("<path> is missing"));
        this.errContent.reset();
        Assertions.assertFalse((0 == this.runCommand(new String[]{"-setfattr", "extra", "-n", "user.a1", "/test"}) ? 1 : 0) != 0, (String)"setfattr should fail with extra arguments");
        Assertions.assertTrue((boolean)this.errContent.toString().contains("Too many arguments"));
        this.errContent.reset();
        Assertions.assertFalse((0 == this.runCommand(new String[]{"-setfattr", "/test"}) ? 1 : 0) != 0, (String)"setfattr should fail without \"-n name\" or \"-x name\"");
        Assertions.assertTrue((boolean)this.errContent.toString().contains("Must specify '-n name' or '-x name' option"));
    }

    private int runCommand(String[] commands) throws Exception {
        return ToolRunner.run((Configuration)this.conf, (Tool)new FsShell(), (String[])commands);
    }
}

