/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.shell;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.ipc.RemoteException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPathExceptions {
    protected String path = "some/file";
    protected String error = "KABOOM";

    @Test
    public void testWithDefaultString() throws Exception {
        PathIOException pe = new PathIOException(this.path);
        Assertions.assertEquals((Object)new Path(this.path), (Object)pe.getPath());
        Assertions.assertEquals((Object)("`" + this.path + "': Input/output error"), (Object)pe.getMessage());
    }

    @Test
    public void testWithThrowable() throws Exception {
        IOException ioe = new IOException("KABOOM");
        PathIOException pe = new PathIOException(this.path, (Throwable)ioe);
        Assertions.assertEquals((Object)new Path(this.path), (Object)pe.getPath());
        Assertions.assertEquals((Object)("`" + this.path + "': Input/output error: " + this.error), (Object)pe.getMessage());
    }

    @Test
    public void testWithCustomString() throws Exception {
        PathIOException pe = new PathIOException(this.path, this.error);
        Assertions.assertEquals((Object)new Path(this.path), (Object)pe.getPath());
        Assertions.assertEquals((Object)("`" + this.path + "': " + this.error), (Object)pe.getMessage());
    }

    @Test
    public void testRemoteExceptionUnwrap() throws Exception {
        PathIOException pe = new PathIOException(this.path);
        RemoteException re = new RemoteException(PathIOException.class.getName(), "test constructor1");
        IOException ie = re.unwrapRemoteException();
        Assertions.assertTrue((boolean)(ie instanceof PathIOException));
        ie = re.unwrapRemoteException(new Class[]{PathIOException.class});
        Assertions.assertTrue((boolean)(ie instanceof PathIOException));
        pe = new PathIOException(this.path, "constructor2");
        re = new RemoteException(PathIOException.class.getName(), "test constructor2");
        ie = re.unwrapRemoteException();
        Assertions.assertTrue((boolean)(ie instanceof PathIOException));
        ie = re.unwrapRemoteException(new Class[]{PathIOException.class});
        Assertions.assertTrue((boolean)(ie instanceof PathIOException));
    }
}

