/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.sftp;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.sftp.SFTPFileSystem;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class TestSFTPFileSystem {
    private static final String TEST_SFTP_DIR = "testsftp";
    private static final String TEST_ROOT_DIR = GenericTestUtils.getTestDir().getAbsolutePath();
    private static final String connection = "sftp://user:password@localhost";
    private static Path localDir = null;
    private static FileSystem localFs = null;
    private FileSystem sftpFs = null;
    private static SshServer sshd = null;
    private static Configuration conf = null;
    private static int port;

    private static void startSshdServer() throws IOException {
        sshd = SshServer.setUpDefaultServer();
        sshd.setPort(0);
        sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
        ArrayList<UserAuthPasswordFactory> userAuthFactories = new ArrayList<UserAuthPasswordFactory>();
        userAuthFactories.add(new UserAuthPasswordFactory());
        sshd.setUserAuthFactories(userAuthFactories);
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public boolean authenticate(String username, String password, ServerSession session) {
                return username.equals("user") && password.equals("password");
            }
        });
        sshd.setSubsystemFactories(Collections.singletonList(new SftpSubsystemFactory()));
        sshd.start();
        port = sshd.getPort();
    }

    @BeforeEach
    public void init() throws Exception {
        this.sftpFs = FileSystem.get((URI)URI.create(connection), (Configuration)conf);
    }

    @AfterEach
    public void cleanUp() throws Exception {
        if (this.sftpFs != null) {
            try {
                this.sftpFs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @BeforeAll
    public static void setUp() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        TestSFTPFileSystem.startSshdServer();
        conf = new Configuration();
        conf.setClass("fs.sftp.impl", SFTPFileSystem.class, FileSystem.class);
        conf.setInt("fs.sftp.host.port", port);
        conf.setBoolean("fs.sftp.impl.disable.cache", true);
        localFs = FileSystem.getLocal((Configuration)conf);
        localDir = localFs.makeQualified(new Path(TEST_ROOT_DIR, TEST_SFTP_DIR));
        if (localFs.exists(localDir)) {
            localFs.delete(localDir, true);
        }
        localFs.mkdirs(localDir);
    }

    @AfterAll
    public static void tearDown() {
        if (localFs != null) {
            try {
                localFs.delete(localDir, true);
                localFs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (sshd != null) {
            try {
                sshd.stop(true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final Path touch(FileSystem fs, String filename) throws IOException {
        return TestSFTPFileSystem.touch(fs, filename, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Path touch(FileSystem fs, String filename, byte[] data) throws IOException {
        Path lPath = new Path(localDir.toUri().getPath(), filename);
        try (FSDataOutputStream out = null;){
            out = fs.create(lPath);
            if (data != null) {
                out.write(data);
            }
        }
        return lPath;
    }

    @Test
    public void testCreateFile(TestInfo testInfo) throws Exception {
        Path file = TestSFTPFileSystem.touch(this.sftpFs, testInfo.getDisplayName().toLowerCase());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.exists(file));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.delete(file, false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)localFs.exists(file));
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testFileExists(TestInfo testInfo) throws Exception {
        Path file = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.exists(file));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.exists(file));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.delete(file, false));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.sftpFs.exists(file));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)localFs.exists(file));
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadFile(TestInfo testInfo) throws Exception {
        byte[] data = "yaks".getBytes();
        Path file = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase(), data);
        try (FSDataInputStream is = null;){
            is = this.sftpFs.open(file);
            byte[] b = new byte[data.length];
            is.read(b);
            org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])data, (byte[])b);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.delete(file, false));
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testStatFile(TestInfo testInfo) throws Exception {
        byte[] data = "yaks".getBytes();
        Path file = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase(), data);
        FileStatus lstat = localFs.getFileStatus(file);
        FileStatus sstat = this.sftpFs.getFileStatus(file);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)sstat);
        org.junit.jupiter.api.Assertions.assertEquals((Object)lstat.getPath().toUri().getPath(), (Object)sstat.getPath().toUri().getPath());
        org.junit.jupiter.api.Assertions.assertEquals((long)data.length, (long)sstat.getLen());
        org.junit.jupiter.api.Assertions.assertEquals((long)lstat.getLen(), (long)sstat.getLen());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.delete(file, false));
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testDeleteNonEmptyDir(TestInfo testInfo) throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
            Path file = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase());
            this.sftpFs.delete(localDir, false);
            Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
        });
    }

    @Test
    public void testDeleteNonExistFile(TestInfo testInfo) throws Exception {
        Path file = new Path(localDir, testInfo.getDisplayName().toLowerCase());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.sftpFs.delete(file, false));
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testRenameFile(TestInfo testInfo) throws Exception {
        byte[] data = "dingos".getBytes();
        Path file1 = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase() + "1");
        Path file2 = new Path(localDir, testInfo.getDisplayName().toLowerCase() + "2");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.rename(file1, file2));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.exists(file2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.sftpFs.exists(file1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.exists(file2));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)localFs.exists(file1));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.sftpFs.delete(file2, false));
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testRenameNonExistFile(TestInfo testInfo) throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
            Path file1 = new Path(localDir, testInfo.getDisplayName().toLowerCase() + "1");
            Path file2 = new Path(localDir, testInfo.getDisplayName().toLowerCase() + "2");
            this.sftpFs.rename(file1, file2);
        });
    }

    @Test
    public void testRenamingFileOntoExistingFile(TestInfo testInfo) throws Exception {
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> {
            Path file1 = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase() + "1");
            Path file2 = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase() + "2");
            this.sftpFs.rename(file1, file2);
        });
    }

    @Test
    public void testGetAccessTime(TestInfo testInfo) throws IOException {
        Path file = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase());
        LocalFileSystem local = (LocalFileSystem)localFs;
        java.nio.file.Path path = local.pathToFile(file).toPath();
        long accessTime1 = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime().toMillis();
        accessTime1 = accessTime1 / 1000L * 1000L;
        long accessTime2 = this.sftpFs.getFileStatus(file).getAccessTime();
        org.junit.jupiter.api.Assertions.assertEquals((long)accessTime1, (long)accessTime2);
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testGetModifyTime(TestInfo testInfo) throws IOException {
        Path file = TestSFTPFileSystem.touch(localFs, testInfo.getDisplayName().toLowerCase() + "1");
        File localFile = ((LocalFileSystem)localFs).pathToFile(file);
        long modifyTime1 = localFile.lastModified();
        modifyTime1 = modifyTime1 / 1000L * 1000L;
        long modifyTime2 = this.sftpFs.getFileStatus(file).getModificationTime();
        org.junit.jupiter.api.Assertions.assertEquals((long)modifyTime1, (long)modifyTime2);
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testMkDirs(TestInfo testInfo) throws IOException {
        Path path = new Path(localDir.toUri().getPath(), new Path(testInfo.getDisplayName(), "subdirectory"));
        this.sftpFs.mkdirs(path);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.exists(path));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)localFs.getFileStatus(path).isDirectory());
        Assertions.assertThat((int)((SFTPFileSystem)this.sftpFs).getConnectionPool().getLiveConnCount()).isEqualTo(1);
    }

    @Test
    public void testCloseFileSystemClosesConnectionPool() throws Exception {
        SFTPFileSystem fs = (SFTPFileSystem)this.sftpFs;
        fs.getHomeDirectory();
        Assertions.assertThat((int)fs.getConnectionPool().getLiveConnCount()).isEqualTo(1);
        fs.close();
        Assertions.assertThat((int)fs.getConnectionPool().getLiveConnCount()).isEqualTo(0);
        fs.close();
    }
}

