/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.apache.hadoop.fs.impl.prefetch.ExceptionAsserts;
import org.apache.hadoop.fs.impl.prefetch.SampleDataForTests;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Test;

public class TestValidate
extends AbstractHadoopTestBase {
    @Test
    public void testCheckNotNull() throws Exception {
        String nonNullArg = "nonNullArg";
        String nullArg = null;
        Validate.checkNotNull((Object)nonNullArg, (String)"nonNullArg");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'nullArg' must not be null", () -> Validate.checkNotNull((Object)nullArg, (String)"nullArg"));
    }

    @Test
    public void testCheckPositiveInteger() throws Exception {
        int positiveArg = 1;
        int zero = 0;
        int negativeArg = -1;
        Validate.checkPositiveInteger((long)positiveArg, (String)"positiveArg");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'negativeArg' must be a positive integer", () -> Validate.checkPositiveInteger((long)negativeArg, (String)"negativeArg"));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'zero' must be a positive integer", () -> Validate.checkPositiveInteger((long)zero, (String)"zero"));
    }

    @Test
    public void testCheckNotNegative() throws Exception {
        int positiveArg = 1;
        int zero = 0;
        int negativeArg = -1;
        Validate.checkNotNegative((long)zero, (String)"zeroArg");
        Validate.checkNotNegative((long)positiveArg, (String)"positiveArg");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'negativeArg' must not be negative", () -> Validate.checkNotNegative((long)negativeArg, (String)"negativeArg"));
    }

    @Test
    public void testCheckRequired() throws Exception {
        Validate.checkRequired((boolean)true, (String)"arg");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg' is required", () -> Validate.checkRequired((boolean)false, (String)"arg"));
    }

    @Test
    public void testCheckValid() throws Exception {
        Validate.checkValid((boolean)true, (String)"arg");
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'arg' is invalid", () -> Validate.checkValid((boolean)false, (String)"arg"));
    }

    @Test
    public void testCheckValidWithValues() throws Exception {
        String validValues = "foo, bar";
        Validate.checkValid((boolean)true, (String)"arg", (String)validValues);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg' is invalid. Valid values are: foo, bar", () -> Validate.checkValid((boolean)false, (String)"arg", (String)validValues));
    }

    @Test
    public void testCheckNotNullAndNotEmpty() throws Exception {
        Validate.checkNotNullAndNotEmpty((Object[])SampleDataForTests.NON_EMPTY_ARRAY, (String)"array");
        Validate.checkNotNullAndNotEmpty((byte[])SampleDataForTests.NON_EMPTY_BYTE_ARRAY, (String)"array");
        Validate.checkNotNullAndNotEmpty((short[])SampleDataForTests.NON_EMPTY_SHORT_ARRAY, (String)"array");
        Validate.checkNotNullAndNotEmpty((int[])SampleDataForTests.NON_EMPTY_INT_ARRAY, (String)"array");
        Validate.checkNotNullAndNotEmpty((long[])SampleDataForTests.NON_EMPTY_LONG_ARRAY, (String)"array");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'string' must not be empty", () -> Validate.checkNotNullAndNotEmpty((String)"", (String)"string"));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'array' must not be null", () -> Validate.checkNotNullAndNotEmpty((Object[])SampleDataForTests.NULL_ARRAY, (String)"array"));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'array' must have at least one element", () -> Validate.checkNotNullAndNotEmpty((Object[])SampleDataForTests.EMPTY_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must not be null", () -> Validate.checkNotNullAndNotEmpty((byte[])SampleDataForTests.NULL_BYTE_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must have at least one element", () -> Validate.checkNotNullAndNotEmpty((byte[])SampleDataForTests.EMPTY_BYTE_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must not be null", () -> Validate.checkNotNullAndNotEmpty((short[])SampleDataForTests.NULL_SHORT_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must have at least one element", () -> Validate.checkNotNullAndNotEmpty((short[])SampleDataForTests.EMPTY_SHORT_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must not be null", () -> Validate.checkNotNullAndNotEmpty((int[])SampleDataForTests.NULL_INT_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must have at least one element", () -> Validate.checkNotNullAndNotEmpty((int[])SampleDataForTests.EMPTY_INT_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must not be null", () -> Validate.checkNotNullAndNotEmpty((long[])SampleDataForTests.NULL_LONG_ARRAY, (String)"array"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'array' must have at least one element", () -> Validate.checkNotNullAndNotEmpty((long[])SampleDataForTests.EMPTY_LONG_ARRAY, (String)"array"));
    }

    @Test
    public void testCheckListNotNullAndNotEmpty() throws Exception {
        Validate.checkNotNullAndNotEmpty(SampleDataForTests.VALID_LIST, (String)"list");
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'list' must not be null", () -> Validate.checkNotNullAndNotEmpty(SampleDataForTests.NULL_LIST, (String)"list"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'list' must have at least one element", () -> Validate.checkNotNullAndNotEmpty(SampleDataForTests.EMPTY_LIST, (String)"list"));
    }

    @Test
    public void testCheckNotNullAndNumberOfElements() throws Exception {
        Validate.checkNotNullAndNumberOfElements(Arrays.asList(1, 2, 3), (int)3, (String)"arg");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg' must not be null", () -> Validate.checkNotNullAndNumberOfElements(null, (int)3, (String)"arg"));
        ExceptionAsserts.assertThrows(IllegalArgumentException.class, "Number of elements in 'arg' must be exactly 3, 2 given.", () -> Validate.checkNotNullAndNumberOfElements(Arrays.asList(1, 2), (int)3, (String)"arg"));
    }

    @Test
    public void testCheckValuesEqual() throws Exception {
        Validate.checkValuesEqual((long)1L, (String)"arg1", (long)1L, (String)"arg2");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg1' (1) must equal 'arg2' (2)", () -> Validate.checkValuesEqual((long)1L, (String)"arg1", (long)2L, (String)"arg2"));
    }

    @Test
    public void testCheckIntegerMultiple() throws Exception {
        Validate.checkIntegerMultiple((long)10L, (String)"arg1", (long)5L, (String)"arg2");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg1' (10) must be an integer multiple of 'arg2' (3)", () -> Validate.checkIntegerMultiple((long)10L, (String)"arg1", (long)3L, (String)"arg2"));
    }

    @Test
    public void testCheckGreater() throws Exception {
        Validate.checkGreater((long)10L, (String)"arg1", (long)5L, (String)"arg2");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg1' (5) must be greater than 'arg2' (10)", () -> Validate.checkGreater((long)5L, (String)"arg1", (long)10L, (String)"arg2"));
    }

    @Test
    public void testCheckGreaterOrEqual() throws Exception {
        Validate.checkGreaterOrEqual((long)10L, (String)"arg1", (long)5L, (String)"arg2");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg1' (5) must be greater than or equal to 'arg2' (10)", () -> Validate.checkGreaterOrEqual((long)5L, (String)"arg1", (long)10L, (String)"arg2"));
    }

    @Test
    public void testCheckWithinRange() throws Exception {
        Validate.checkWithinRange((long)10L, (String)"arg", (long)5L, (long)15L);
        Validate.checkWithinRange((double)10.0, (String)"arg", (double)5.0, (double)15.0);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg' (5) must be within the range [10, 20]", () -> Validate.checkWithinRange((long)5L, (String)"arg", (long)10L, (long)20L));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'arg' (5.0) must be within the range [10.0, 20.0]", () -> Validate.checkWithinRange((double)5.0, (String)"arg", (double)10.0, (double)20.0));
    }

    @Test
    public void testCheckPathExists() throws Exception {
        Path tempFile = Files.createTempFile("foo", "bar", new FileAttribute[0]);
        Path tempDir = tempFile.getParent();
        Path notFound = Paths.get("<not-found>", new String[0]);
        Validate.checkPathExists((Path)tempFile, (String)"tempFile");
        Validate.checkPathExists((Path)tempDir, (String)"tempDir");
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'nullArg' must not be null", () -> Validate.checkPathExists(null, (String)"nullArg"));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "Path notFound (<not-found>) does not exist", () -> Validate.checkPathExists((Path)notFound, (String)"notFound"));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "must point to a directory", () -> Validate.checkPathExistsAsDir((Path)tempFile, (String)"tempFile"));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "must point to a file", () -> Validate.checkPathExistsAsFile((Path)tempDir, (String)"tempDir"));
    }
}

