/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import org.apache.hadoop.fs.impl.prefetch.Retryer;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRetryer
extends AbstractHadoopTestBase {
    @Test
    public void testArgChecks() throws Exception {
        new Retryer(10, 50, 500);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'perRetryDelay' must be a positive integer", () -> new Retryer(-1, 50, 500));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'perRetryDelay' must be a positive integer", () -> new Retryer(0, 50, 500));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'maxDelay' (5) must be greater than 'perRetryDelay' (10)", () -> new Retryer(10, 5, 500));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'statusUpdateInterval' must be a positive integer", () -> new Retryer(10, 50, -1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'statusUpdateInterval' must be a positive integer", () -> new Retryer(10, 50, 0));
    }

    @Test
    public void testRetry() {
        int perRetryDelay = 1;
        int statusUpdateInterval = 3;
        int maxDelay = 10;
        Retryer retryer = new Retryer(perRetryDelay, maxDelay, statusUpdateInterval);
        for (int t = 1; t <= maxDelay; ++t) {
            Assertions.assertTrue((boolean)retryer.continueRetry());
            if (t % statusUpdateInterval == 0) {
                Assertions.assertTrue((boolean)retryer.updateStatus());
                continue;
            }
            Assertions.assertFalse((boolean)retryer.updateStatus());
        }
        Assertions.assertFalse((boolean)retryer.continueRetry());
    }
}

