/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.hadoop.fs.impl.prefetch.BoundedResourcePool;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBoundedResourcePool
extends AbstractHadoopTestBase {
    @Test
    public void testArgChecks() throws Exception {
        BufferPool pool = new BufferPool(5);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'size' must be a positive integer", () -> new BufferPool(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'size' must be a positive integer", () -> new BufferPool(0));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'item' must not be null", () -> pool.release(null));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "This item is not a part of this pool", () -> pool.release(ByteBuffer.allocate(4)));
    }

    @Test
    public void testAcquireReleaseSingle() {
        int numBuffers = 5;
        BufferPool pool = new BufferPool(5);
        Assertions.assertEquals((int)0, (int)pool.numCreated());
        Assertions.assertEquals((int)5, (int)pool.numAvailable());
        ByteBuffer buffer1 = (ByteBuffer)pool.acquire();
        Assertions.assertNotNull((Object)buffer1);
        Assertions.assertEquals((int)1, (int)pool.numCreated());
        Assertions.assertEquals((int)4, (int)pool.numAvailable());
        pool.release(buffer1);
        Assertions.assertEquals((int)1, (int)pool.numCreated());
        ByteBuffer buffer2 = (ByteBuffer)pool.acquire();
        Assertions.assertNotNull((Object)buffer2);
        Assertions.assertSame((Object)buffer1, (Object)buffer2);
        Assertions.assertEquals((int)1, (int)pool.numCreated());
    }

    @Test
    public void testAcquireReleaseMultiple() {
        int numBuffers = 5;
        BufferPool pool = new BufferPool(5);
        Set<ByteBuffer> buffers = Collections.newSetFromMap(new IdentityHashMap());
        Assertions.assertEquals((int)0, (int)pool.numCreated());
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)(5 - i), (int)pool.numAvailable());
            ByteBuffer buffer = (ByteBuffer)pool.acquire();
            Assertions.assertNotNull((Object)buffer);
            Assertions.assertFalse((boolean)buffers.contains(buffer));
            buffers.add(buffer);
            Assertions.assertEquals((int)(i + 1), (int)pool.numCreated());
        }
        Assertions.assertEquals((int)5, (int)pool.numCreated());
        Assertions.assertEquals((int)0, (int)pool.numAvailable());
        int releaseCount = 0;
        for (ByteBuffer buffer : buffers) {
            Assertions.assertEquals((int)releaseCount, (int)pool.numAvailable());
            pool.release(buffer);
            Assertions.assertEquals((int)(++releaseCount), (int)pool.numAvailable());
            pool.release(buffer);
            Assertions.assertEquals((int)releaseCount, (int)pool.numAvailable());
            pool.release(buffer);
            Assertions.assertEquals((int)releaseCount, (int)pool.numAvailable());
        }
        for (int i = 0; i < 5; ++i) {
            ByteBuffer buffer;
            buffer = (ByteBuffer)pool.acquire();
            Assertions.assertTrue((boolean)buffers.contains(buffer));
        }
        Assertions.assertEquals((int)5, (int)pool.numCreated());
        Assertions.assertEquals((int)0, (int)pool.numAvailable());
    }

    static class BufferPool
    extends BoundedResourcePool<ByteBuffer> {
        BufferPool(int size) {
            super(size);
        }

        protected ByteBuffer createNew() {
            return ByteBuffer.allocate(10);
        }
    }
}

