/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import org.apache.hadoop.fs.impl.prefetch.BlockData;
import org.apache.hadoop.fs.impl.prefetch.ExceptionAsserts;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBlockData
extends AbstractHadoopTestBase {
    @Test
    public void testArgChecks() throws Exception {
        new BlockData(10L, 5);
        new BlockData(5L, 10);
        new BlockData(0L, 10);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'fileSize' must not be negative", () -> new BlockData(-1L, 2));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockSize' must be a positive integer", () -> new BlockData(10L, 0));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockSize' must be a positive integer", () -> new BlockData(10L, -2));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' (-1) must be within the range [0, 3]", () -> new BlockData(10L, 3).isLastBlock(-1));
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'blockNumber' (11) must be within the range [0, 3]", () -> new BlockData(10L, 3).isLastBlock(11));
    }

    @Test
    public void testComputedFields() throws Exception {
        this.testComputedFieldsHelper(0L, 10);
        this.testComputedFieldsHelper(1L, 10);
        this.testComputedFieldsHelper(10L, 1);
        this.testComputedFieldsHelper(10L, 2);
        this.testComputedFieldsHelper(10L, 3);
    }

    private void testComputedFieldsHelper(long fileSize, int blockSize) throws Exception {
        BlockData bd = new BlockData(fileSize, blockSize);
        if (fileSize == 0L) {
            Assertions.assertFalse((boolean)bd.isLastBlock(0));
            Assertions.assertFalse((boolean)bd.isLastBlock(1));
            Assertions.assertFalse((boolean)bd.isValidOffset(0L));
            Assertions.assertEquals((int)0, (int)bd.getSize(0));
            Assertions.assertEquals((Object)"", (Object)bd.getStateString());
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'offset' (0) must be within the range [0, -1]", () -> bd.getBlockNumber(0L));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'blockNumber' (0) must be within the range [0, -1]", () -> bd.getStartOffset(0));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'offset' (0) must be within the range [0, -1]", () -> bd.getRelativeOffset(0, 0L));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'blockNumber' (0) must be within the range [0, -1]", () -> bd.getState(0));
            ExceptionAsserts.assertThrows(IllegalArgumentException.class, "'blockNumber' (0) must be within the range [0, -1]", () -> bd.setState(0, BlockData.State.READY));
            return;
        }
        Assertions.assertEquals((long)fileSize, (long)bd.getFileSize());
        Assertions.assertEquals((int)blockSize, (int)bd.getBlockSize());
        int expectedNumBlocks = (int)(fileSize / (long)blockSize);
        if (fileSize % (long)blockSize > 0L) {
            ++expectedNumBlocks;
        }
        Assertions.assertEquals((int)expectedNumBlocks, (int)bd.getNumBlocks());
        int lastBlockNumber = expectedNumBlocks - 1;
        for (int b = 0; b < lastBlockNumber; ++b) {
            Assertions.assertFalse((boolean)bd.isLastBlock(b));
            Assertions.assertEquals((int)blockSize, (int)bd.getSize(b));
        }
        Assertions.assertTrue((boolean)bd.isLastBlock(lastBlockNumber));
        int lastBlockSize = (int)(fileSize - (long)(blockSize * (expectedNumBlocks - 1)));
        Assertions.assertEquals((int)lastBlockSize, (int)bd.getSize(lastBlockNumber));
        for (long offset = 0L; offset < fileSize; ++offset) {
            int expectedBlockNumber = (int)(offset / (long)blockSize);
            Assertions.assertEquals((int)expectedBlockNumber, (int)bd.getBlockNumber(offset));
            for (int b = 0; b < expectedNumBlocks - 1; ++b) {
                long expectedStartOffset = b * blockSize;
                Assertions.assertEquals((long)expectedStartOffset, (long)bd.getStartOffset(b));
                int expectedRelativeOffset = (int)(offset - expectedStartOffset);
                Assertions.assertEquals((int)expectedRelativeOffset, (int)bd.getRelativeOffset(b, offset));
            }
        }
        for (int b = 0; b < expectedNumBlocks; ++b) {
            Assertions.assertEquals((long)(b * blockSize), (long)bd.getStartOffset(b));
            Assertions.assertEquals((Object)BlockData.State.NOT_READY, (Object)bd.getState(b));
            bd.setState(b, BlockData.State.QUEUED);
            Assertions.assertEquals((Object)BlockData.State.QUEUED, (Object)bd.getState(b));
            bd.setState(b, BlockData.State.READY);
            Assertions.assertEquals((Object)BlockData.State.READY, (Object)bd.getState(b));
            bd.setState(b, BlockData.State.CACHED);
            Assertions.assertEquals((Object)BlockData.State.CACHED, (Object)bd.getState(b));
        }
    }
}

