/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl.prefetch;

import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.impl.prefetch.BlockCache;
import org.apache.hadoop.fs.impl.prefetch.EmptyPrefetchingStatistics;
import org.apache.hadoop.fs.impl.prefetch.PrefetchingStatistics;
import org.apache.hadoop.fs.impl.prefetch.SingleFilePerBlockCache;
import org.apache.hadoop.test.AbstractHadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBlockCache
extends AbstractHadoopTestBase {
    private static final int BUFFER_SIZE = 16;
    private static final Configuration CONF = new Configuration();

    @Test
    public void testArgChecks() throws Exception {
        SingleFilePerBlockCache cache = new SingleFilePerBlockCache((PrefetchingStatistics)EmptyPrefetchingStatistics.getInstance(), 2, null);
        ByteBuffer buffer = ByteBuffer.allocate(16);
        LambdaTestUtils.intercept(IllegalArgumentException.class, "'buffer' must not be null", () -> TestBlockCache.lambda$testArgChecks$0((BlockCache)cache));
        LambdaTestUtils.intercept(NullPointerException.class, () -> new SingleFilePerBlockCache(null, 2, null));
    }

    @Test
    public void testPutAndGet() throws Exception {
        SingleFilePerBlockCache cache = new SingleFilePerBlockCache((PrefetchingStatistics)EmptyPrefetchingStatistics.getInstance(), 2, null);
        ByteBuffer buffer1 = ByteBuffer.allocate(16);
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            buffer1.put(i);
        }
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertFalse((boolean)cache.containsBlock(0));
        cache.put(0, buffer1, CONF, new LocalDirAllocator("hadoop.tmp.dir"));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertTrue((boolean)cache.containsBlock(0));
        ByteBuffer buffer2 = ByteBuffer.allocate(16);
        cache.get(0, buffer2);
        Assertions.assertNotSame((Object)buffer1, (Object)buffer2);
        this.assertBuffersEqual(buffer1, buffer2);
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertFalse((boolean)cache.containsBlock(1));
        cache.put(1, buffer1, CONF, new LocalDirAllocator("hadoop.tmp.dir"));
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertTrue((boolean)cache.containsBlock(1));
        ByteBuffer buffer3 = ByteBuffer.allocate(16);
        cache.get(1, buffer3);
        Assertions.assertNotSame((Object)buffer1, (Object)buffer3);
        this.assertBuffersEqual(buffer1, buffer3);
    }

    private void assertBuffersEqual(ByteBuffer buffer1, ByteBuffer buffer2) {
        Assertions.assertNotNull((Object)buffer1);
        Assertions.assertNotNull((Object)buffer2);
        Assertions.assertEquals((int)buffer1.limit(), (int)buffer2.limit());
        Assertions.assertEquals((int)16, (int)buffer1.limit());
        for (int i = 0; i < 16; ++i) {
            Assertions.assertEquals((byte)buffer1.get(i), (byte)buffer2.get(i));
        }
    }

    private static /* synthetic */ void lambda$testArgChecks$0(BlockCache cache) throws Exception {
        cache.put(42, null, null, null);
    }
}

