/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.impl;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.hadoop.fs.ByteBufferPositionedReadable;
import org.apache.hadoop.fs.FileRange;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.VectoredReadUtils;
import org.apache.hadoop.fs.impl.CombinedFileRange;
import org.apache.hadoop.fs.impl.VectorIOBufferPool;
import org.apache.hadoop.io.ElasticByteBufferPool;
import org.apache.hadoop.test.HadoopTestBase;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.MoreAsserts;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestVectoredReadUtils
extends HadoopTestBase {
    @Test
    public void testSliceTo() {
        int size = 65536;
        ByteBuffer buffer = ByteBuffer.allocate(65536);
        IntBuffer intBuffer = buffer.asIntBuffer();
        for (int i = 0; i < 16384; ++i) {
            intBuffer.put(i);
        }
        ByteBuffer slice = VectoredReadUtils.sliceTo((ByteBuffer)buffer, (long)100L, (FileRange)FileRange.createFileRange((long)100L, (int)65536));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buffer).describedAs("Slicing on the same offset shouldn't create a new buffer", new Object[0])).isEqualTo((Object)slice);
        ((AbstractIntegerAssert)Assertions.assertThat((int)slice.position()).describedAs("Slicing should return buffers starting from position 0", new Object[0])).isEqualTo(0);
        int offset = 100;
        int sliceStart = 1024;
        int sliceLength = 16384;
        slice = VectoredReadUtils.sliceTo((ByteBuffer)buffer, (long)100L, (FileRange)FileRange.createFileRange((long)1124L, (int)16384));
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buffer).describedAs("Slicing on new offset should create a new buffer", new Object[0])).isNotEqualTo((Object)slice);
        ((AbstractByteArrayAssert)Assertions.assertThat((byte[])buffer.array()).describedAs("Slicing should use the same underlying data", new Object[0])).isEqualTo((Object)slice.array());
        ((AbstractIntegerAssert)Assertions.assertThat((int)slice.position()).describedAs("Slicing should return buffers starting from position 0", new Object[0])).isEqualTo(0);
        intBuffer = slice.asIntBuffer();
        for (int i = 0; i < 4096; ++i) {
            TestVectoredReadUtils.assertEquals((int)(i + 256), (int)intBuffer.get(), (String)("i = " + i));
        }
    }

    @Test
    public void testRounding() {
        for (int i = 5; i < 10; ++i) {
            TestVectoredReadUtils.assertEquals((long)5L, (long)VectoredReadUtils.roundDown((long)i, (int)5), (String)("i = " + i));
            TestVectoredReadUtils.assertEquals((long)10L, (long)VectoredReadUtils.roundUp((long)(i + 1), (int)5), (String)("i = " + i));
        }
        TestVectoredReadUtils.assertEquals((long)13L, (long)VectoredReadUtils.roundDown((long)13L, (int)1), (String)"Error while roundDown");
        TestVectoredReadUtils.assertEquals((long)13L, (long)VectoredReadUtils.roundUp((long)13L, (int)1), (String)"Error while roundUp");
    }

    @Test
    public void testMerge() {
        String tracker1 = "one";
        String tracker2 = "two";
        FileRange base = FileRange.createFileRange((long)2000L, (int)1000, (Object)tracker1);
        CombinedFileRange mergeBase = new CombinedFileRange(2000L, 3000L, base);
        TestVectoredReadUtils.assertFalse((boolean)mergeBase.merge(5000L, 6000L, FileRange.createFileRange((long)5000L, (int)1000), 2000, 4000), (String)"Large gap ranges shouldn't get merged");
        TestVectoredReadUtils.assertUnderlyingSize(mergeBase, "Number of ranges in merged range shouldn't increase", 1);
        TestVectoredReadUtils.assertFileRange(mergeBase, 2000L, 1000);
        TestVectoredReadUtils.assertFalse((boolean)mergeBase.merge(5000L, 6000L, FileRange.createFileRange((long)5000L, (int)1000), 2001, 3999), (String)"Large size ranges shouldn't get merged");
        TestVectoredReadUtils.assertEquals((int)1, (int)mergeBase.getUnderlying().size(), (String)"Number of ranges in merged range shouldn't increase");
        TestVectoredReadUtils.assertFileRange(mergeBase, 2000L, 1000);
        TestVectoredReadUtils.assertTrue((boolean)mergeBase.merge(5000L, 6000L, FileRange.createFileRange((long)5000L, (int)1000, (Object)tracker2), 2001, 4000), (String)"ranges should get merged ");
        TestVectoredReadUtils.assertUnderlyingSize(mergeBase, "merge list after merge", 2);
        TestVectoredReadUtils.assertFileRange(mergeBase, 2000L, 4000);
        ((ObjectAssert)Assertions.assertThat((Object)((FileRange)mergeBase.getUnderlying().get(0)).getReference()).describedAs("reference of range %s", new Object[]{mergeBase.getUnderlying().get(0)})).isSameAs((Object)tracker1);
        ((ObjectAssert)Assertions.assertThat((Object)((FileRange)mergeBase.getUnderlying().get(1)).getReference()).describedAs("reference of range %s", new Object[]{mergeBase.getUnderlying().get(1)})).isSameAs((Object)tracker2);
        mergeBase = new CombinedFileRange(200L, 300L, base);
        TestVectoredReadUtils.assertFileRange(mergeBase, 200L, 100);
        TestVectoredReadUtils.assertTrue((boolean)mergeBase.merge(500L, 600L, FileRange.createFileRange((long)5000L, (int)1000), 201, 400), (String)"ranges should get merged ");
        TestVectoredReadUtils.assertUnderlyingSize(mergeBase, "merge list after merge", 2);
        TestVectoredReadUtils.assertFileRange(mergeBase, 200L, 400);
    }

    private static ListAssert<FileRange> assertUnderlyingSize(CombinedFileRange combinedFileRange, String description, int expected) {
        return (ListAssert)((ListAssert)Assertions.assertThat((List)combinedFileRange.getUnderlying()).describedAs(description, new Object[0])).hasSize(expected);
    }

    @Test
    public void testSortAndMerge() {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)3000L, (int)100, (Object)"1"), FileRange.createFileRange((long)2100L, (int)100, null), FileRange.createFileRange((long)1000L, (int)100, (Object)"3"));
        TestVectoredReadUtils.assertIsNotOrderedDisjoint(input, 100, 800);
        List outputList = VectoredReadUtils.mergeSortedRanges((List)VectoredReadUtils.sortRangeList(input), (int)100, (int)1001, (int)2500);
        TestVectoredReadUtils.assertRangeListSize(outputList, 1);
        CombinedFileRange output = (CombinedFileRange)outputList.get(0);
        TestVectoredReadUtils.assertUnderlyingSize(output, "merged range underlying size", 3);
        TestVectoredReadUtils.assertFileRange(output, 1000L, 2100);
        TestVectoredReadUtils.assertOrderedDisjoint(outputList, 100, 800);
        TestVectoredReadUtils.assertIsNotOrderedDisjoint(input, 100, 100);
        List list2 = VectoredReadUtils.mergeSortedRanges((List)VectoredReadUtils.sortRangeList(input), (int)100, (int)1000, (int)2100);
        TestVectoredReadUtils.assertRangeListSize(list2, 2);
        TestVectoredReadUtils.assertRangeElement(list2, 0, 1000L, 100);
        TestVectoredReadUtils.assertRangeElement(list2, 1, 2100L, 1000);
        TestVectoredReadUtils.assertOrderedDisjoint(list2, 100, 1000);
        TestVectoredReadUtils.assertIsNotOrderedDisjoint(input, 100, 800);
        List list3 = VectoredReadUtils.mergeSortedRanges((List)VectoredReadUtils.sortRangeList(input), (int)100, (int)1001, (int)2099);
        TestVectoredReadUtils.assertRangeListSize(list3, 2);
        CombinedFileRange range0 = (CombinedFileRange)list3.get(0);
        TestVectoredReadUtils.assertFileRange(range0, 1000L, 1200);
        List underlying = range0.getUnderlying();
        TestVectoredReadUtils.assertFileRange((FileRange)underlying.get(0), 1000L, 100, "3");
        TestVectoredReadUtils.assertFileRange((FileRange)underlying.get(1), 2100L, 100, null);
        CombinedFileRange range1 = (CombinedFileRange)list3.get(1);
        TestVectoredReadUtils.assertFileRange(range1, 3000L, 100);
        TestVectoredReadUtils.assertFileRange((FileRange)range1.getUnderlying().get(0), 3000L, 100, "1");
        TestVectoredReadUtils.assertOrderedDisjoint(list3, 100, 800);
        TestVectoredReadUtils.assertIsNotOrderedDisjoint(input, 16, 700);
        List list4 = VectoredReadUtils.mergeSortedRanges((List)VectoredReadUtils.sortRangeList(input), (int)16, (int)1001, (int)100);
        TestVectoredReadUtils.assertRangeListSize(list4, 3);
        TestVectoredReadUtils.assertRangeElement(list4, 0, 992L, 112);
        TestVectoredReadUtils.assertRangeElement(list4, 1, 2096L, 112);
        TestVectoredReadUtils.assertRangeElement(list4, 2, 2992L, 112);
        TestVectoredReadUtils.assertOrderedDisjoint(list4, 16, 700);
    }

    private static <ELEMENT extends FileRange> void assertFileRange(ELEMENT range, long start, int length) {
        ((ObjectAssert)Assertions.assertThat(range).describedAs("file range %s", new Object[]{range})).isNotNull();
        ((AbstractLongAssert)Assertions.assertThat((long)range.getOffset()).describedAs("offset of %s", new Object[]{range})).isEqualTo(start);
        ((AbstractIntegerAssert)Assertions.assertThat((int)range.getLength()).describedAs("length of %s", new Object[]{range})).isEqualTo(length);
    }

    @Test
    public void testArraySortRange() throws Throwable {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)3000L, (int)100, (Object)"1"), FileRange.createFileRange((long)2100L, (int)100, null), FileRange.createFileRange((long)1000L, (int)100, (Object)"3"));
        Object[] rangeArray = VectoredReadUtils.sortRanges(input);
        List rangeList = VectoredReadUtils.sortRangeList(input);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])rangeArray).describedAs("range array from sortRanges()", new Object[0])).isSortedAccordingTo(Comparator.comparingLong(FileRange::getOffset));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])rangeList.toArray(new FileRange[0])).describedAs("range from sortRangeList()", new Object[0])).isEqualTo((Object)rangeArray);
    }

    private static <ELEMENT extends FileRange> void assertFileRange(ELEMENT range, long offset, int length, Object reference) {
        TestVectoredReadUtils.assertFileRange(range, offset, length);
        ((ObjectAssert)Assertions.assertThat((Object)range.getReference()).describedAs("reference field of file range %s", new Object[]{range})).isEqualTo(reference);
    }

    private static <ELEMENT extends FileRange> ObjectAssert<ELEMENT> assertIsSingleRange(List<ELEMENT> ranges, long start, int length) {
        TestVectoredReadUtils.assertRangeListSize(ranges, 1);
        return TestVectoredReadUtils.assertRangeElement(ranges, 0, start, length);
    }

    private static <ELEMENT extends FileRange> ListAssert<ELEMENT> assertRangeListSize(List<ELEMENT> ranges, int size) {
        return (ListAssert)((ListAssert)Assertions.assertThat(ranges).describedAs("coalesced ranges", new Object[0])).hasSize(size);
    }

    private static <ELEMENT extends FileRange> ListAssert<ELEMENT> assertRangesCountAtLeast(List<ELEMENT> ranges, int size) {
        return (ListAssert)((ListAssert)Assertions.assertThat(ranges).describedAs("coalesced ranges", new Object[0])).hasSizeGreaterThanOrEqualTo(size);
    }

    private static <ELEMENT extends FileRange> ObjectAssert<ELEMENT> assertRangeElement(List<ELEMENT> ranges, int index, long start, int length) {
        return (ObjectAssert)((ObjectAssert)((ObjectAssert)TestVectoredReadUtils.assertRangesCountAtLeast(ranges, index + 1).element(index)).describedAs("range", new Object[0])).satisfies(r -> TestVectoredReadUtils.assertFileRange(r, start, length));
    }

    private static void assertOrderedDisjoint(List<? extends FileRange> input, int chunkSize, int minimumSeek) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)VectoredReadUtils.isOrderedDisjoint(input, (int)chunkSize, (int)minimumSeek)).describedAs("ranges are ordered and disjoint", new Object[0])).isTrue();
    }

    private static <ELEMENT extends FileRange> void assertIsNotOrderedDisjoint(List<ELEMENT> input, int chunkSize, int minimumSeek) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)VectoredReadUtils.isOrderedDisjoint(input, (int)chunkSize, (int)minimumSeek)).describedAs("Ranges are non disjoint/ordered", new Object[0])).isFalse();
    }

    @Test
    public void testSortAndMergeMoreCases() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)3000L, (int)110), FileRange.createFileRange((long)3000L, (int)100), FileRange.createFileRange((long)2100L, (int)100), FileRange.createFileRange((long)1000L, (int)100));
        TestVectoredReadUtils.assertIsNotOrderedDisjoint(input, 100, 800);
        List outputList = VectoredReadUtils.mergeSortedRanges((List)VectoredReadUtils.sortRangeList(input), (int)1, (int)1001, (int)2500);
        ((ListAssert)Assertions.assertThat((List)outputList).describedAs("merged range size", new Object[0])).hasSize(1);
        CombinedFileRange output = (CombinedFileRange)outputList.get(0);
        TestVectoredReadUtils.assertUnderlyingSize(output, "merged range underlying size", 4);
        TestVectoredReadUtils.assertFileRange(output, 1000L, 2110);
        TestVectoredReadUtils.assertOrderedDisjoint(outputList, 1, 800);
        outputList = VectoredReadUtils.mergeSortedRanges((List)VectoredReadUtils.sortRangeList(input), (int)100, (int)1001, (int)2500);
        TestVectoredReadUtils.assertRangeListSize(outputList, 1);
        output = (CombinedFileRange)outputList.get(0);
        TestVectoredReadUtils.assertUnderlyingSize(output, "merged range underlying size", 4);
        TestVectoredReadUtils.assertFileRange(output, 1000L, 2200);
        TestVectoredReadUtils.assertOrderedDisjoint(outputList, 1, 800);
    }

    @Test
    public void testRejectOverlappingRanges() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)100L, (int)100), FileRange.createFileRange((long)200L, (int)100), FileRange.createFileRange((long)250L, (int)100));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> VectoredReadUtils.validateAndSortRanges((List)input, Optional.empty()));
    }

    @Test
    public void testDuplicateRangesRaisesIllegalArgument() throws Exception {
        List<FileRange> input1 = Arrays.asList(FileRange.createFileRange((long)100L, (int)100), FileRange.createFileRange((long)500L, (int)100), FileRange.createFileRange((long)1000L, (int)100), FileRange.createFileRange((long)1000L, (int)100));
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> VectoredReadUtils.validateAndSortRanges((List)input1, Optional.empty()));
    }

    @Test
    public void testConsecutiveRangesAreValid() throws Throwable {
        VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)100L, (int)100), FileRange.createFileRange((long)200L, (int)100), FileRange.createFileRange((long)300L, (int)100)), Optional.empty());
    }

    @Test
    public void testMaxSizeZeroDisablesMerging() {
        List<FileRange> randomRanges = Arrays.asList(FileRange.createFileRange((long)3000L, (int)110), FileRange.createFileRange((long)3000L, (int)100), FileRange.createFileRange((long)2100L, (int)100));
        TestVectoredReadUtils.assertEqualRangeCountsAfterMerging(randomRanges, 1, 1, 0);
        TestVectoredReadUtils.assertEqualRangeCountsAfterMerging(randomRanges, 1, 0, 0);
        TestVectoredReadUtils.assertEqualRangeCountsAfterMerging(randomRanges, 1, 100, 0);
    }

    private static void assertEqualRangeCountsAfterMerging(List<FileRange> inputRanges, int chunkSize, int minimumSeek, int maxSize) {
        List combinedFileRanges = VectoredReadUtils.mergeSortedRanges(inputRanges, (int)chunkSize, (int)minimumSeek, (int)maxSize);
        TestVectoredReadUtils.assertRangeListSize(combinedFileRanges, inputRanges.size());
    }

    private static void fillBuffer(ByteBuffer buffer) {
        byte b = 0;
        while (buffer.remaining() > 0) {
            byte by = b;
            b = (byte)(b + 1);
            buffer.put(by);
        }
    }

    @Test
    public void testReadSingleRange() throws Exception {
        Stream stream = TestVectoredReadUtils.mockStreamWithReadFully();
        CompletableFuture result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), ByteBuffer::allocate);
        MoreAsserts.assertFutureCompletedSuccessfully(result);
        ByteBuffer buffer = (ByteBuffer)result.get();
        TestVectoredReadUtils.assertEquals((int)100, (int)buffer.remaining(), (String)"Size of result buffer");
        byte b = 0;
        while (buffer.remaining() > 0) {
            byte by = b;
            b = (byte)(b + 1);
            TestVectoredReadUtils.assertEquals((byte)by, (byte)buffer.get(), (String)("remain = " + buffer.remaining()));
        }
    }

    @Test
    public void testReadWithIOE() throws Exception {
        Stream stream = TestVectoredReadUtils.mockStreamWithReadFully();
        ((Stream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("foo")}).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        CompletableFuture result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), ByteBuffer::allocate);
        MoreAsserts.assertFutureFailedExceptionally(result);
    }

    private static void runReadRangeFromPositionedReadable(IntFunction<ByteBuffer> allocate) throws Exception {
        PositionedReadable stream = (PositionedReadable)Mockito.mock(PositionedReadable.class);
        ((PositionedReadable)Mockito.doAnswer(invocation -> {
            int b = 0;
            byte[] buffer = (byte[])invocation.getArgument(1);
            for (int i = 0; i < buffer.length; ++i) {
                int n = b;
                b = (byte)(b + 1);
                buffer[i] = n;
            }
            return null;
        }).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        CompletableFuture result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), allocate);
        MoreAsserts.assertFutureCompletedSuccessfully(result);
        ByteBuffer buffer = (ByteBuffer)result.get();
        TestVectoredReadUtils.assertEquals((int)100, (int)buffer.remaining(), (String)"Size of result buffer");
        TestVectoredReadUtils.validateBuffer("buffer", buffer, 0);
        Mockito.reset((Object[])new PositionedReadable[]{stream});
        ((PositionedReadable)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("foo")}).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        result = VectoredReadUtils.readRangeFrom((PositionedReadable)stream, (FileRange)FileRange.createFileRange((long)1000L, (int)100), ByteBuffer::allocate);
        MoreAsserts.assertFutureFailedExceptionally(result);
    }

    @Test
    public void testReadRangeArray() throws Exception {
        TestVectoredReadUtils.runReadRangeFromPositionedReadable(ByteBuffer::allocate);
    }

    @Test
    public void testReadRangeDirect() throws Exception {
        TestVectoredReadUtils.runReadRangeFromPositionedReadable(ByteBuffer::allocateDirect);
    }

    private static void validateBuffer(String message, ByteBuffer buffer, int start) {
        byte expected = (byte)start;
        while (buffer.remaining() > 0) {
            TestVectoredReadUtils.assertEquals((byte)expected, (byte)buffer.get(), (String)(message + " remain: " + buffer.remaining()));
            expected = (byte)(expected + 1);
        }
    }

    @Test
    public void testReadVectored() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)0L, (int)100), FileRange.createFileRange((long)100000L, (int)100, (Object)"this"), FileRange.createFileRange((long)200000L, (int)100, (Object)"that"));
        this.runAndValidateVectoredRead(input);
    }

    @Test
    public void testReadVectoredZeroBytes() throws Exception {
        List<FileRange> input = Arrays.asList(FileRange.createFileRange((long)0L, (int)0, (Object)"1"), FileRange.createFileRange((long)100000L, (int)100, (Object)"2"), FileRange.createFileRange((long)200000L, (int)0, (Object)"3"));
        this.runAndValidateVectoredRead(input);
        FileRange r1 = TestVectoredReadUtils.retrieve(input, "1");
        ((AbstractIntegerAssert)Assertions.assertThat((int)((ByteBuffer)r1.getData().get()).limit()).describedAs("Data limit of %s", new Object[]{r1})).isEqualTo(0);
    }

    private static FileRange retrieve(List<FileRange> input, String key) {
        return input.stream().filter(r -> key.equals(r.getReference())).findFirst().orElseThrow(() -> new IllegalArgumentException("No range with key " + key));
    }

    private void runAndValidateVectoredRead(List<FileRange> input) throws Exception {
        Stream stream = TestVectoredReadUtils.mockStreamWithReadFully();
        VectoredReadUtils.readVectored((PositionedReadable)stream, input, ByteBuffer::allocate);
        ((Stream)Mockito.verify((Object)stream, (VerificationMode)Mockito.times((int)input.size()))).readFully(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        for (int b = 0; b < input.size(); ++b) {
            TestVectoredReadUtils.validateBuffer("buffer " + b, (ByteBuffer)input.get(b).getData().get(), 0);
        }
    }

    private static Stream mockStreamWithReadFully() throws IOException {
        Stream stream = (Stream)Mockito.mock(Stream.class);
        ((Stream)Mockito.doAnswer(invocation -> {
            TestVectoredReadUtils.fillBuffer((ByteBuffer)invocation.getArgument(1));
            return null;
        }).when((Object)stream)).readFully(ArgumentMatchers.anyLong(), (ByteBuffer)ArgumentMatchers.any(ByteBuffer.class));
        return stream;
    }

    @Test
    public void testEmptyRangesAllowed() throws Throwable {
        VectoredReadUtils.validateAndSortRanges(Collections.emptyList(), Optional.empty());
    }

    @Test
    public void testNegativeOffsetRaisesEOF() throws Throwable {
        LambdaTestUtils.intercept(EOFException.class, () -> VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)1000L, (int)100), FileRange.createFileRange((long)-1000L, (int)100)), Optional.empty()));
    }

    @Test
    public void testNegativePositionRaisesIllegalArgument() throws Throwable {
        LambdaTestUtils.intercept(IllegalArgumentException.class, () -> VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)1000L, (int)100), FileRange.createFileRange((long)1000L, (int)-100)), Optional.empty()));
    }

    @Test
    public void testReadWholeFile() throws Exception {
        int length = 1000;
        List ranges = VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)0L, (int)1000)), Optional.of(1000L));
        TestVectoredReadUtils.assertIsSingleRange(ranges, 0L, 1000);
    }

    @Test
    public void testReadPastEOFRejected() throws Exception {
        int length = 1000;
        LambdaTestUtils.intercept(EOFException.class, () -> VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)0L, (int)1001)), Optional.of(1000L)));
    }

    @Test
    public void testReadStartingPastEOFRejected() throws Exception {
        int length = 1000;
        LambdaTestUtils.intercept(EOFException.class, () -> VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)1000L, (int)0)), Optional.of(1000L)));
    }

    @Test
    public void testReadUpToEOF() throws Exception {
        int length = 1000;
        int p = 999;
        TestVectoredReadUtils.assertIsSingleRange(VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)999L, (int)1)), Optional.of(1000L)), 999L, 1);
    }

    @Test
    public void testReadOverEOFRejected() throws Exception {
        long length = 1000L;
        LambdaTestUtils.intercept(EOFException.class, () -> VectoredReadUtils.validateAndSortRanges(Arrays.asList(FileRange.createFileRange((long)999L, (int)2)), Optional.of(1000L)));
    }

    @Test
    public void testVectorIOBufferPool() throws Throwable {
        ElasticByteBufferPool elasticByteBufferPool = new ElasticByteBufferPool();
        Consumer<Integer> assertPoolSizeEquals = size -> ((AbstractIntegerAssert)Assertions.assertThat((int)elasticByteBufferPool.size(false)).describedAs("Pool size", new Object[0])).isEqualTo(size);
        VectorIOBufferPool vectorBuffers = new VectorIOBufferPool(r -> elasticByteBufferPool.getBuffer(false, r), arg_0 -> ((ElasticByteBufferPool)elasticByteBufferPool).putBuffer(arg_0));
        assertPoolSizeEquals.accept(0);
        ByteBuffer b1 = vectorBuffers.getBuffer(false, 100);
        ByteBuffer b2 = vectorBuffers.getBuffer(false, 50);
        vectorBuffers.putBuffer(b1);
        assertPoolSizeEquals.accept(1);
        ByteBuffer b3 = vectorBuffers.getBuffer(true, 100);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)b3).describedAs("buffer returned from a get after a previous one was returned", new Object[0])).isSameAs((Object)b1);
        assertPoolSizeEquals.accept(0);
        vectorBuffers.putBuffer(b2);
        vectorBuffers.putBuffer(b3);
        assertPoolSizeEquals.accept(2);
        vectorBuffers.release();
        assertPoolSizeEquals.accept(2);
        elasticByteBufferPool.release();
    }

    static interface Stream
    extends PositionedReadable,
    ByteBufferPositionedReadable {
    }
}

