/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;
import mockwebserver3.MockResponse;
import mockwebserver3.MockWebServer;
import mockwebserver3.RecordedRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.http.HttpFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHttpFileSystem {
    private final Configuration conf = new Configuration(false);

    @BeforeEach
    public void setUp() {
        this.conf.set("fs.http.impl", HttpFileSystem.class.getCanonicalName());
    }

    @Test
    public void testHttpFileSystem() throws IOException, URISyntaxException, InterruptedException {
        String data = "foo";
        try (MockWebServer server = new MockWebServer();){
            MockResponse response = new MockResponse.Builder().body("foo").build();
            IntStream.rangeClosed(1, 3).forEach(i -> server.enqueue(response));
            server.start();
            URI uri = URI.create(String.format("http://%s:%d", server.getHostName(), server.getPort()));
            FileSystem fs = FileSystem.get((URI)uri, (Configuration)this.conf);
            this.assertSameData(fs, new Path(new URL(uri.toURL(), "/foo").toURI()), "foo");
            this.assertSameData(fs, new Path("/foo"), "foo");
            this.assertSameData(fs, new Path("foo"), "foo");
            RecordedRequest req = server.takeRequest();
            Assertions.assertEquals((Object)"/foo", (Object)req.getUrl().encodedPath());
        }
    }

    @Test
    public void testHttpFileStatus() throws IOException, URISyntaxException, InterruptedException {
        URI uri = new URI("http://www.example.com");
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)this.conf);
        URI expectedUri = uri.resolve("/foo");
        Assertions.assertEquals((Object)fs.getFileStatus(new Path(new Path(uri), "/foo")).getPath().toUri(), (Object)expectedUri);
        Assertions.assertEquals((Object)fs.getFileStatus(new Path("/foo")).getPath().toUri(), (Object)expectedUri);
        Assertions.assertEquals((Object)fs.getFileStatus(new Path("foo")).getPath().toUri(), (Object)expectedUri);
    }

    private void assertSameData(FileSystem fs, Path path, String data) throws IOException {
        try (FSDataInputStream is = fs.open(path, 4096);){
            byte[] buf = new byte[data.length()];
            IOUtils.readFully((InputStream)is, (byte[])buf, (int)0, (int)buf.length);
            Assertions.assertEquals((Object)data, (Object)new String(buf, StandardCharsets.UTF_8));
        }
    }
}

