/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.test.tags.RootFilesystemTest;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RootFilesystemTest
public abstract class AbstractContractRootDirectoryTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractRootDirectoryTest.class);
    public static final int OBJECTSTORE_RETRY_TIMEOUT = 30000;

    @Override
    @BeforeEach
    public void setup() throws Exception {
        super.setup();
        this.skipIfUnsupported("test.root-tests-enabled");
    }

    @Test
    public void testMkDirDepth1() throws Throwable {
        FileSystem fs = this.getFileSystem();
        Path dir = new Path("/testmkdirdepth1");
        this.assertPathDoesNotExist("directory already exists", dir);
        fs.mkdirs(dir);
        this.assertIsDirectory(dir);
        this.assertPathExists("directory already exists", dir);
        this.assertDeleted(dir, true);
    }

    @Test
    public void testRmEmptyRootDirRecursive() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        this.assertIsDirectory(root);
        boolean deleted = this.getFileSystem().delete(root, true);
        LOG.info("rm -r / of empty dir result is {}", (Object)deleted);
        this.assertIsDirectory(root);
    }

    @Test
    public void testRmEmptyRootDirNonRecursive() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        this.assertIsDirectory(root);
        FileSystem fs = this.getFileSystem();
        AtomicInteger iterations = new AtomicInteger(0);
        FileStatus[] originalChildren = ContractTestUtils.listChildren(fs, root);
        LambdaTestUtils.eventually(30000, () -> {
            iterations.incrementAndGet();
            FileStatus[] deleted = ContractTestUtils.deleteChildren(fs, root, true);
            Object[] children = ContractTestUtils.listChildren(fs, root);
            ((ObjectArrayAssert)Assertions.assertThat((Object[])children).describedAs("After %d attempts: listing after rm /* not empty\ndeleted: %s\n: original %s", new Object[]{iterations.get(), ContractTestUtils.dumpStats("deleted", deleted), ContractTestUtils.dumpStats("original", originalChildren)})).isEmpty();
            return null;
        }, (Callable<Integer>)new LambdaTestUtils.ProportionalRetryInterval(50, 1000));
        boolean deleted = fs.delete(root, false);
        LOG.info("rm / of empty dir result is {}", (Object)deleted);
        this.assertIsDirectory(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRmNonEmptyRootDirNonRecursive() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        String touchfile = "/testRmNonEmptyRootDirNonRecursive";
        Path file = new Path(touchfile);
        ContractTestUtils.touch(this.getFileSystem(), file);
        this.assertIsDirectory(root);
        try {
            boolean deleted = this.getFileSystem().delete(root, false);
            AbstractContractRootDirectoryTest.fail((String)("non recursive delete should have raised an exception, but completed with exit code " + deleted));
        }
        catch (IOException e) {
            this.handleExpectedException(e);
            this.assertIsFile(file);
        }
        finally {
            this.getFileSystem().delete(file, false);
        }
        this.assertIsDirectory(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRmRootRecursive() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        this.assertIsDirectory(root);
        Path file = new Path("/testRmRootRecursive");
        try {
            ContractTestUtils.touch(this.getFileSystem(), file);
            boolean deleted = this.getFileSystem().delete(root, true);
            this.assertIsDirectory(root);
            LOG.info("rm -rf / result is {}", (Object)deleted);
            if (deleted) {
                this.assertPathDoesNotExist("expected file to be deleted", file);
            } else {
                this.assertPathExists("expected file to be preserved", file);
            }
        }
        finally {
            this.getFileSystem().delete(file, false);
        }
    }

    @Test
    public void testCreateFileOverRoot() throws Throwable {
        this.skipIfUnsupported("test.root-tests-enabled");
        Path root = new Path("/");
        byte[] dataset = ContractTestUtils.dataset(1024, 32, 122);
        try {
            ContractTestUtils.createFile(this.getFileSystem(), root, false, dataset);
            AbstractContractRootDirectoryTest.fail((String)("expected an exception, got a file created over root: " + this.ls(root)));
        }
        catch (IOException e) {
            this.handleExpectedException(e);
        }
        this.assertIsDirectory(root);
    }

    @Test
    public void testListEmptyRootDirectory() throws IOException {
        FileStatus[] statuses;
        this.skipIfUnsupported("test.root-tests-enabled");
        FileSystem fs = this.getFileSystem();
        Path root = new Path("/");
        for (FileStatus status : statuses = fs.listStatus(root)) {
            ContractTestUtils.assertDeleted(fs, status.getPath(), false, true, false);
        }
        ((ObjectArrayAssert)Assertions.assertThat((Object[])fs.listStatus(root)).describedAs("ls /", new Object[0])).hasSize(0);
        this.assertNoElements("listFiles(/, false)", (RemoteIterator<LocatedFileStatus>)fs.listFiles(root, false));
        this.assertNoElements("listFiles(/, true)", (RemoteIterator<LocatedFileStatus>)fs.listFiles(root, true));
        this.assertNoElements("listLocatedStatus(/)", (RemoteIterator<LocatedFileStatus>)fs.listLocatedStatus(root));
        this.assertIsDirectory(root);
    }

    protected void assertNoElements(String operation, RemoteIterator<LocatedFileStatus> iter) throws IOException {
        List<LocatedFileStatus> resultList = ContractTestUtils.toList(iter);
        if (!resultList.isEmpty()) {
            AbstractContractRootDirectoryTest.fail((String)("Expected no results from " + operation + ", but got " + resultList.size() + " elements:\n" + StringUtils.join(resultList, (String)"\n")));
        }
    }

    @Test
    public void testSimpleRootListing() throws IOException {
        this.describe("test the nonrecursive root listing calls");
        FileSystem fs = this.getFileSystem();
        Path root = new Path("/");
        Object[] statuses = fs.listStatus(root);
        String listStatusResult = StringUtils.join((Object[])statuses, (String)"\n");
        List<LocatedFileStatus> locatedStatusList = ContractTestUtils.toList((RemoteIterator<LocatedFileStatus>)fs.listLocatedStatus(root));
        String locatedStatusResult = StringUtils.join(locatedStatusList, (String)"\n");
        AbstractContractRootDirectoryTest.assertEquals((int)statuses.length, (int)locatedStatusList.size(), (String)("listStatus(/) vs listLocatedStatus(/) with \nlistStatus =" + listStatusResult + " listLocatedStatus = " + locatedStatusResult));
        List<LocatedFileStatus> fileList = ContractTestUtils.toList((RemoteIterator<LocatedFileStatus>)fs.listFiles(root, false));
        String listFilesResult = StringUtils.join(fileList, (String)"\n");
        AbstractContractRootDirectoryTest.assertTrue((fileList.size() <= statuses.length ? 1 : 0) != 0, (String)("listStatus(/) vs listFiles(/, false) with \nlistStatus = " + listStatusResult + "listFiles = " + listFilesResult));
        List statusList = ContractTestUtils.iteratorToList(fs.listStatusIterator(root));
        ((ListAssert)Assertions.assertThat(statusList).describedAs("Result of listStatus(/) and listStatusIterator(/) must match", new Object[0])).hasSameElementsAs((Iterable)Arrays.stream(statuses).collect(Collectors.toList()));
    }

    @Test
    public void testRecursiveRootListing() throws IOException {
        this.describe("test a recursive root directory listing");
        FileSystem fs = this.getFileSystem();
        Path root = new Path("/");
        ContractTestUtils.TreeScanResults listing = new ContractTestUtils.TreeScanResults((RemoteIterator<? extends FileStatus>)fs.listFiles(root, true));
        this.describe("verifying consistency with treewalk's files");
        ContractTestUtils.TreeScanResults treeWalk = ContractTestUtils.treeWalk(fs, root);
        treeWalk.assertFieldsEquivalent("treewalk vs listFiles(/, true)", listing, treeWalk.getFiles(), listing.getFiles());
    }
}

