/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.junit.jupiter.api.Test;

public abstract class AbstractContractRenameTest
extends AbstractFSContractTestBase {
    @Test
    public void testRenameNewFileSameDir() throws Throwable {
        this.describe("rename a file into a new file in the same directory");
        Path renameSrc = this.path("rename_src");
        Path renameTarget = this.path("rename_dest");
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), renameSrc, data, data.length, 0x100000, false);
        boolean rename = this.rename(renameSrc, renameTarget);
        AbstractContractRenameTest.assertTrue((boolean)rename, (String)("rename(" + renameSrc + ", " + renameTarget + ") returned false"));
        ContractTestUtils.assertListStatusFinds(this.getFileSystem(), renameTarget.getParent(), renameTarget);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), renameTarget, data);
    }

    @Test
    public void testRenameNonexistentFile() throws Throwable {
        this.describe("rename a file into a new file in the same directory");
        Path missing = this.path("testRenameNonexistentFileSrc");
        Path target = this.path("testRenameNonexistentFileDest");
        boolean renameReturnsFalseOnFailure = this.isSupported("rename-returns-false-if-source-missing");
        this.mkdirs(missing.getParent());
        try {
            boolean renamed = this.rename(missing, target);
            if (!renameReturnsFalseOnFailure) {
                String destDirLS = this.generateAndLogErrorListing(missing, target);
                AbstractContractRenameTest.fail((String)("expected rename(" + missing + ", " + target + " ) to fail, got a result of " + renamed + " and a destination directory of " + destDirLS));
            } else {
                AbstractContractRenameTest.getLogger().warn("Rename returned {} renaming a nonexistent file", (Object)renamed);
                AbstractContractRenameTest.assertFalse((boolean)renamed, (String)"Renaming a missing file returned true");
            }
        }
        catch (FileNotFoundException e) {
            if (renameReturnsFalseOnFailure) {
                ContractTestUtils.fail("Renaming a missing file unexpectedly threw an exception", e);
            }
            this.handleExpectedException(e);
        }
        catch (IOException e) {
            this.handleRelaxedException("rename nonexistent file", "FileNotFoundException", e);
        }
        this.assertPathDoesNotExist("rename nonexistent file created a destination file", target);
    }

    @Test
    public void testRenameFileOverExistingFile() throws Throwable {
        this.describe("Verify renaming a file onto an existing file matches expectations");
        Path srcFile = this.path("source-256.txt");
        byte[] srcData = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), srcFile, srcData, srcData.length, 1024, false);
        Path destFile = this.path("dest-512.txt");
        byte[] destData = ContractTestUtils.dataset(512, 65, 90);
        ContractTestUtils.writeDataset(this.getFileSystem(), destFile, destData, destData.length, 1024, false);
        this.assertIsFile(destFile);
        boolean renameOverwritesDest = this.isSupported("rename-overwrites-dest");
        boolean renameReturnsFalseOnRenameDestExists = this.isSupported("rename-returns-false-if-dest-exists");
        AbstractContractRenameTest.assertFalse((renameOverwritesDest && renameReturnsFalseOnRenameDestExists ? 1 : 0) != 0, (String)"rename-overwrites-dest and rename-returns-false-if-dest-exists cannot be both supported");
        String expectedTo = "expected rename(" + srcFile + ", " + destFile + ") to ";
        boolean destUnchanged = true;
        try {
            boolean renamed = this.rename(srcFile, destFile);
            boolean bl = destUnchanged = !renamed;
            if (renameOverwritesDest) {
                AbstractContractRenameTest.assertTrue((boolean)renamed, (String)(expectedTo + "overwrite destination, but got false"));
            } else if (renameReturnsFalseOnRenameDestExists) {
                AbstractContractRenameTest.assertFalse((boolean)renamed, (String)(expectedTo + "be rejected with false, but destination was overwritten"));
            } else if (renamed) {
                String destDirLS = this.generateAndLogErrorListing(srcFile, destFile);
                AbstractContractRenameTest.getLogger().error("dest dir {}", (Object)destDirLS);
                AbstractContractRenameTest.fail((String)(expectedTo + "be rejected with exception, but got overwritten"));
            } else {
                AbstractContractRenameTest.fail((String)(expectedTo + "be rejected with exception, but got false"));
            }
        }
        catch (FileAlreadyExistsException e) {
            AbstractContractRenameTest.assertFalse((boolean)renameOverwritesDest, (String)(expectedTo + "overwrite destination, but got exception"));
            AbstractContractRenameTest.assertFalse((boolean)renameReturnsFalseOnRenameDestExists, (String)(expectedTo + "be rejected with false, but got exception"));
            this.handleExpectedException((Exception)((Object)e));
        }
        ContractTestUtils.verifyFileContents(this.getFileSystem(), destFile, destUnchanged ? destData : srcData);
    }

    @Test
    public void testRenameDirIntoExistingDir() throws Throwable {
        this.describe("Verify renaming a dir into an existing dir puts it underneath and leaves existing files alone");
        FileSystem fs = this.getFileSystem();
        String sourceSubdir = "source";
        Path srcDir = this.path(sourceSubdir);
        Path srcFilePath = new Path(srcDir, "source-256.txt");
        byte[] srcDataset = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(fs, srcFilePath, srcDataset, srcDataset.length, 1024, false);
        Path destDir = this.path("dest");
        Path destFilePath = new Path(destDir, "dest-512.txt");
        byte[] destData = ContractTestUtils.dataset(512, 65, 90);
        ContractTestUtils.writeDataset(fs, destFilePath, destData, destData.length, 1024, false);
        this.assertIsFile(destFilePath);
        boolean rename = this.rename(srcDir, destDir);
        Path renamedSrc = new Path(destDir, sourceSubdir);
        this.assertIsFile(destFilePath);
        this.assertIsDirectory(renamedSrc);
        ContractTestUtils.verifyFileContents(fs, destFilePath, destData);
        AbstractContractRenameTest.assertTrue((boolean)rename, (String)"rename returned false though the contents were copied");
    }

    @Test
    public void testRenameFileNonexistentDir() throws Throwable {
        this.describe("rename a file into a new file in the same directory");
        Path renameSrc = this.path("testRenameSrc");
        Path renameTarget = this.path("subdir/testRenameTarget");
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), renameSrc, data, data.length, 0x100000, false);
        boolean renameCreatesDestDirs = this.isSupported("rename-creates-dest-dirs");
        try {
            boolean rename = this.rename(renameSrc, renameTarget);
            if (renameCreatesDestDirs) {
                AbstractContractRenameTest.assertTrue((boolean)rename);
                ContractTestUtils.verifyFileContents(this.getFileSystem(), renameTarget, data);
            } else {
                AbstractContractRenameTest.assertFalse((boolean)rename);
                ContractTestUtils.verifyFileContents(this.getFileSystem(), renameSrc, data);
            }
        }
        catch (FileNotFoundException e) {
            AbstractContractRenameTest.assertFalse((boolean)renameCreatesDestDirs);
        }
    }

    @Test
    public void testRenameWithNonEmptySubDir() throws Throwable {
        Path renameTestDir = this.path("testRenameWithNonEmptySubDir");
        Path srcDir = new Path(renameTestDir, "src1");
        Path srcSubDir = new Path(srcDir, "sub");
        Path finalDir = new Path(renameTestDir, "dest");
        FileSystem fs = this.getFileSystem();
        boolean renameRemoveEmptyDest = this.isSupported("rename-remove-dest-if-empty-dir");
        ContractTestUtils.rm(fs, renameTestDir, true, false);
        fs.mkdirs(srcDir);
        fs.mkdirs(finalDir);
        ContractTestUtils.writeTextFile(fs, new Path(srcDir, "source.txt"), "this is the file in src dir", false);
        ContractTestUtils.writeTextFile(fs, new Path(srcSubDir, "subfile.txt"), "this is the file in src/sub dir", false);
        this.assertPathExists("not created in src dir", new Path(srcDir, "source.txt"));
        this.assertPathExists("not created in src/sub dir", new Path(srcSubDir, "subfile.txt"));
        this.rename(srcDir, finalDir);
        if (renameRemoveEmptyDest) {
            this.assertPathExists("not renamed into dest dir", new Path(finalDir, "source.txt"));
            this.assertPathExists("not renamed into dest/sub dir", new Path(finalDir, "sub/subfile.txt"));
        } else {
            this.assertPathExists("not renamed into dest dir", new Path(finalDir, "src1/source.txt"));
            this.assertPathExists("not renamed into dest/sub dir", new Path(finalDir, "src1/sub/subfile.txt"));
        }
        this.assertPathDoesNotExist("not deleted", new Path(srcDir, "source.txt"));
    }

    @Test
    public void testRenamePopulatesDirectoryAncestors() throws IOException {
        FileSystem fs = this.getFileSystem();
        Path src = this.path("testRenamePopulatesDirectoryAncestors/source");
        fs.mkdirs(src);
        String nestedDir = "/dir1/dir2/dir3/dir4";
        fs.mkdirs(this.path(src + "/dir1/dir2/dir3/dir4"));
        Path dst = this.path("testRenamePopulatesDirectoryAncestorsNew");
        fs.rename(src, dst);
        this.validateAncestorsMoved(src, dst, "/dir1/dir2/dir3/dir4");
    }

    @Test
    public void testRenamePopulatesFileAncestors() throws IOException {
        FileSystem fs = this.getFileSystem();
        Path src = this.path("testRenamePopulatesFileAncestors/source");
        fs.mkdirs(src);
        String nestedFile = "/dir1/dir2/dir3/file4";
        byte[] srcDataset = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(fs, this.path(src + "/dir1/dir2/dir3/file4"), srcDataset, srcDataset.length, 1024, false);
        Path dst = this.path("testRenamePopulatesFileAncestorsNew");
        fs.rename(src, dst);
        this.validateAncestorsMoved(src, dst, "/dir1/dir2/dir3/file4");
    }

    protected void validateAncestorsMoved(Path src, Path dst, String nestedPath) throws IOException {
        this.assertIsDirectory(dst);
        this.assertPathDoesNotExist("src path should not exist", this.path(src + nestedPath));
        this.assertPathExists("dst path should exist", this.path(dst + nestedPath));
        for (Path path = new Path(nestedPath).getParent(); path != null && !path.isRoot(); path = path.getParent()) {
            Path parentSrc = this.path(src + path.toString());
            this.assertPathDoesNotExist(parentSrc + " is not deleted", parentSrc);
            Path parentDst = this.path(dst + path.toString());
            this.assertPathExists(parentDst + " should exist after rename", parentDst);
            this.assertIsDirectory(parentDst);
        }
    }

    @Test
    public void testRenameFileUnderFile() throws Exception {
        String action = "rename directly under file";
        this.describe(action);
        Path base = this.methodPath();
        Path grandparent = new Path(base, "file");
        this.expectRenameUnderFileFails(action, grandparent, new Path(base, "testRenameSrc"), new Path(grandparent, "testRenameTarget"));
    }

    @Test
    public void testRenameFileUnderFileSubdir() throws Exception {
        String action = "rename directly under file/subdir";
        this.describe(action);
        Path base = this.methodPath();
        Path grandparent = new Path(base, "file");
        Path parent = new Path(grandparent, "parent");
        this.expectRenameUnderFileFails(action, grandparent, new Path(base, "testRenameSrc"), new Path(parent, "testRenameTarget"));
    }

    protected void expectRenameUnderFileFails(String action, Path file, Path renameSrc, Path renameTarget) throws Exception {
        String outcome;
        boolean renamed;
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.writeDataset(fs, file, data, data.length, 0x100000, true);
        ContractTestUtils.writeDataset(fs, renameSrc, data, data.length, 0x100000, true);
        try {
            renamed = this.rename(renameSrc, renameTarget);
            outcome = action + ": rename (" + renameSrc + ", " + renameTarget + ")= " + renamed;
        }
        catch (IOException e) {
            renamed = false;
            outcome = "rename raised an exception: " + e;
        }
        this.assertPathDoesNotExist("after " + outcome, renameTarget);
        AbstractContractRenameTest.assertFalse((boolean)renamed, (String)outcome);
        this.assertPathExists(action, renameSrc);
    }
}

