/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractGetEnclosingRoot
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractGetEnclosingRoot.class);

    @Test
    public void testEnclosingRootEquivalence() throws IOException {
        FileSystem fs = this.getFileSystem();
        Path root = this.path("/");
        Path foobar = this.path("/foo/bar");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(foobar), (String)"Ensure getEnclosingRoot on the root directory returns the root directory");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(fs.getEnclosingRoot(foobar)), (String)"Ensure getEnclosingRoot called on itself returns the root directory");
        AbstractContractGetEnclosingRoot.assertEquals((Object)fs.getEnclosingRoot(root), (Object)fs.getEnclosingRoot(foobar), (String)"Ensure getEnclosingRoot for different paths in the same enclosing root returns the same path");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(this.methodPath()), (String)"Ensure getEnclosingRoot on a path returns the root directory");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(fs.getEnclosingRoot(this.methodPath())), (String)"Ensure getEnclosingRoot called on itself on a path returns the root directory");
        AbstractContractGetEnclosingRoot.assertEquals((Object)fs.getEnclosingRoot(root), (Object)fs.getEnclosingRoot(this.methodPath()), (String)"Ensure getEnclosingRoot for different paths in the same enclosing root returns the same path");
    }

    @Test
    public void testEnclosingRootPathExists() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path root = this.path("/");
        Path foobar = this.methodPath();
        fs.mkdirs(foobar);
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(foobar), (String)"Ensure getEnclosingRoot returns the root directory when the root directory exists");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(foobar), (String)"Ensure getEnclosingRoot returns the root directory when the directory exists");
    }

    @Test
    public void testEnclosingRootPathDNE() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path foobar = this.path("/foo/bar");
        Path root = this.path("/");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(foobar), (String)"Ensure getEnclosingRoot returns the root directory even when the path does not exist");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(this.methodPath()), (String)"Ensure getEnclosingRoot returns the root directory even when the path does not exist");
    }

    @Test
    public void testEnclosingRootWrapped() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path root = this.path("/");
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)fs.getEnclosingRoot(new Path("/foo/bar")), (String)"Ensure getEnclosingRoot returns the root directory when the directory exists");
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"foo");
        Path p = (Path)ugi.doAs(() -> {
            FileSystem wFs = this.getContract().getTestFileSystem();
            return wFs.getEnclosingRoot(new Path("/foo/bar"));
        });
        AbstractContractGetEnclosingRoot.assertEquals((Object)root, (Object)p, (String)"Ensure getEnclosingRoot works correctly within a wrapped FileSystem");
    }
}

