/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContractCreateTest
extends AbstractFSContractTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractContractCreateTest.class);
    public static final int CREATE_TIMEOUT = 15000;

    protected Path path(String filepath, boolean useBuilder) throws IOException {
        return super.path(filepath + (useBuilder ? "" : "-builder"));
    }

    private void testCreateNewFile(boolean useBuilder) throws Throwable {
        this.describe("Foundational 'create a file' test, using builder API=" + useBuilder);
        Path path = this.path("testCreateNewFile", useBuilder);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 0x100000, false, useBuilder);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), path, data);
    }

    @Test
    public void testCreateNewFile() throws Throwable {
        this.testCreateNewFile(true);
        this.testCreateNewFile(false);
    }

    private void testCreateFileOverExistingFileNoOverwrite(boolean useBuilder) throws Throwable {
        this.describe("Verify overwriting an existing file fails, using builder API=" + useBuilder);
        Path path = this.path("testCreateFileOverExistingFileNoOverwrite", useBuilder);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, false);
        byte[] data2 = ContractTestUtils.dataset(10240, 65, 90);
        try {
            ContractTestUtils.writeDataset(this.getFileSystem(), path, data2, data2.length, 1024, false, useBuilder);
            AbstractContractCreateTest.fail((String)"writing without overwrite unexpectedly succeeded");
        }
        catch (FileAlreadyExistsException expected) {
            this.handleExpectedException((Exception)((Object)expected));
        }
        catch (IOException relaxed) {
            this.handleRelaxedException("Creating a file over a file with overwrite==false", "FileAlreadyExistsException", relaxed);
        }
    }

    @Test
    public void testCreateFileOverExistingFileNoOverwrite() throws Throwable {
        this.testCreateFileOverExistingFileNoOverwrite(false);
        this.testCreateFileOverExistingFileNoOverwrite(true);
    }

    private void testOverwriteExistingFile(boolean useBuilder) throws Throwable {
        this.describe("Overwrite an existing file and verify the new data is there, use builder API=" + useBuilder);
        Path path = this.path("testOverwriteExistingFile", useBuilder);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, false, useBuilder);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), path, data);
        byte[] data2 = ContractTestUtils.dataset(10240, 65, 90);
        ContractTestUtils.writeDataset(this.getFileSystem(), path, data2, data2.length, 1024, true, useBuilder);
        ContractTestUtils.verifyFileContents(this.getFileSystem(), path, data2);
    }

    @Test
    public void testOverwriteExistingFile() throws Throwable {
        this.testOverwriteExistingFile(false);
        this.testOverwriteExistingFile(true);
    }

    private void testOverwriteEmptyDirectory(boolean useBuilder) throws Throwable {
        this.describe("verify trying to create a file over an empty dir fails, use builder API=" + useBuilder);
        Path path = this.path("testOverwriteEmptyDirectory");
        this.mkdirs(path);
        this.assertIsDirectory(path);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        try {
            ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, true, useBuilder);
            this.assertIsDirectory(path);
            AbstractContractCreateTest.fail((String)"write of file over empty dir succeeded");
        }
        catch (FileAlreadyExistsException expected) {
            this.handleExpectedException((Exception)((Object)expected));
        }
        catch (IOException e) {
            this.handleRelaxedException("overwriting a dir with a file ", "FileAlreadyExistsException", e);
        }
        this.assertIsDirectory(path);
    }

    @Test
    public void testOverwriteEmptyDirectory() throws Throwable {
        this.testOverwriteEmptyDirectory(false);
        this.testOverwriteEmptyDirectory(true);
    }

    private void testOverwriteNonEmptyDirectory(boolean useBuilder) throws Throwable {
        this.describe("verify trying to create a file over a non-empty dir fails, use builder API=" + useBuilder);
        Path path = this.path("testOverwriteNonEmptyDirectory");
        this.mkdirs(path);
        try {
            this.assertIsDirectory(path);
        }
        catch (AssertionError failure) {
            if (this.isSupported("create-overwrites-directory")) {
                throw new TestAbortedException(((Throwable)((Object)failure)).toString(), (Throwable)((Object)failure));
            }
            throw failure;
        }
        Path child = new Path(path, "child");
        ContractTestUtils.writeTextFile(this.getFileSystem(), child, "child file", true);
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        try {
            ContractTestUtils.writeDataset(this.getFileSystem(), path, data, data.length, 1024, true, useBuilder);
            FileStatus status = this.getFileSystem().getFileStatus(path);
            boolean isDir = status.isDirectory();
            if (!isDir && this.isSupported("create-overwrites-directory")) {
                ContractTestUtils.skip("This Filesystem allows a file to overwrite a directory");
            }
            AbstractContractCreateTest.fail((String)"write of file over dir succeeded");
        }
        catch (FileAlreadyExistsException expected) {
            this.handleExpectedException((Exception)((Object)expected));
        }
        catch (IOException e) {
            this.handleRelaxedException("overwriting a dir with a file ", "FileAlreadyExistsException", e);
        }
        this.assertIsDirectory(path);
        this.assertIsFile(child);
    }

    @Test
    public void testOverwriteNonEmptyDirectory() throws Throwable {
        this.testOverwriteNonEmptyDirectory(false);
        this.testOverwriteNonEmptyDirectory(true);
    }

    @Test
    public void testCreatedFileIsImmediatelyVisible() throws Throwable {
        this.describe("verify that a newly created file exists as soon as open returns");
        Path path = this.path("testCreatedFileIsImmediatelyVisible");
        try (FSDataOutputStream out = this.getFileSystem().create(path, false, 4096, (short)1, 1024L);){
            if (!this.getFileSystem().exists(path)) {
                if (this.isSupported("create-visibility-delayed")) {
                    ContractTestUtils.skip("This Filesystem delays visibility of newly created files");
                }
                this.assertPathExists("expected path to be visible before anything written", path);
            }
        }
    }

    @Test
    public void testCreatedFileIsVisibleOnFlush() throws Throwable {
        this.describe("verify that a newly created file exists once a flush has taken place");
        Path path = this.path("testCreatedFileIsVisibleOnFlush");
        FileSystem fs = this.getFileSystem();
        try (FSDataOutputStream out = fs.create(path, false, 4096, (short)1, 1024L);){
            out.write(97);
            out.flush();
            if (!fs.exists(path)) {
                if (this.isSupported("is-blobstore") || this.isSupported("create-visibility-delayed")) {
                    ContractTestUtils.skip("For object store or some file systems, newly created files are not immediately visible");
                }
                this.assertPathExists("expected path to be visible before file closed", path);
            }
        }
    }

    @Test
    public void testCreatedFileIsEventuallyVisible() throws Throwable {
        this.describe("verify a written to file is visible after the stream is closed");
        Path path = this.path("testCreatedFileIsEventuallyVisible");
        FileSystem fs = this.getFileSystem();
        try (FSDataOutputStream out = fs.create(path, false, 4096, (short)1, 1024L);){
            out.write(1);
            out.close();
            ContractTestUtils.getFileStatusEventually(fs, path, 15000);
        }
    }

    @Test
    public void testFileStatusBlocksizeNonEmptyFile() throws Throwable {
        this.describe("validate the block size of a filesystem and files within it");
        FileSystem fs = this.getFileSystem();
        long rootPath = fs.getDefaultBlockSize(this.path("/"));
        AbstractContractCreateTest.assertTrue((rootPath > 0L ? 1 : 0) != 0, (String)("Root block size is invalid " + rootPath));
        Path path = this.path("testFileStatusBlocksizeNonEmptyFile");
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        ContractTestUtils.writeDataset(fs, path, data, data.length, 0x100000, false);
        this.validateBlockSize(fs, path, 1);
    }

    @Test
    public void testFileStatusBlocksizeEmptyFile() throws Throwable {
        this.describe("check that an empty file may return a 0-byte blocksize");
        FileSystem fs = this.getFileSystem();
        Path path = this.path("testFileStatusBlocksizeEmptyFile");
        ContractTestUtils.touch(fs, path);
        this.validateBlockSize(fs, path, 0);
    }

    private void validateBlockSize(FileSystem fs, Path path, int minValue) throws IOException, InterruptedException {
        FileStatus status = ContractTestUtils.getFileStatusEventually(fs, path, 15000);
        String statusDetails = status.toString();
        AbstractContractCreateTest.assertTrue((status.getBlockSize() >= (long)minValue ? 1 : 0) != 0, (String)("File status block size too low:  " + statusDetails + " min value: " + minValue));
        long defaultBlockSize = fs.getDefaultBlockSize(path);
        AbstractContractCreateTest.assertTrue((defaultBlockSize >= (long)minValue ? 1 : 0) != 0, (String)("fs.getDefaultBlockSize(" + path + ") size " + defaultBlockSize + " is below the minimum of " + minValue));
    }

    @Test
    public void testCreateMakesParentDirs() throws Throwable {
        this.describe("check that after creating a file its parent directories exist");
        FileSystem fs = this.getFileSystem();
        Path grandparent = this.path("testCreateCreatesAndPopulatesParents");
        Path parent = new Path(grandparent, "parent");
        Path child = new Path(parent, "child");
        ContractTestUtils.touch(fs, child);
        AbstractContractCreateTest.assertEquals((int)1, (int)fs.listStatus(parent).length, (String)"List status of parent should include the 1 child file");
        AbstractContractCreateTest.assertTrue((boolean)fs.getFileStatus(parent).isDirectory(), (String)"Parent directory does not appear to be a directory");
        AbstractContractCreateTest.assertEquals((int)1, (int)fs.listStatus(grandparent).length, (String)"List status of grandparent should include the 1 parent dir");
        AbstractContractCreateTest.assertTrue((boolean)fs.getFileStatus(grandparent).isDirectory(), (String)"Grandparent directory does not appear to be a directory");
    }

    @Test
    public void testCreateFileUnderFile() throws Throwable {
        this.describe("Verify that it is forbidden to create file/file");
        if (this.isSupported("create-file-under-file-allowed")) {
            ContractTestUtils.skip("This filesystem supports creating files under files");
        }
        Path grandparent = this.methodPath();
        Path parent = new Path(grandparent, "parent");
        this.expectCreateUnderFileFails("creating a file under a file", grandparent, parent);
    }

    @Test
    public void testCreateUnderFileSubdir() throws Throwable {
        this.describe("Verify that it is forbidden to create file/dir/file");
        if (this.isSupported("create-file-under-file-allowed")) {
            ContractTestUtils.skip("This filesystem supports creating files under files");
        }
        Path grandparent = this.methodPath();
        Path parent = new Path(grandparent, "parent");
        Path child = new Path(parent, "child");
        this.expectCreateUnderFileFails("creating a file under a subdirectory of a file", grandparent, child);
    }

    @Test
    public void testMkdirUnderFile() throws Throwable {
        this.describe("Verify that it is forbidden to create file/dir");
        Path grandparent = this.methodPath();
        Path parent = new Path(grandparent, "parent");
        this.expectMkdirsUnderFileFails("mkdirs() under a file", grandparent, parent);
    }

    @Test
    public void testMkdirUnderFileSubdir() throws Throwable {
        this.describe("Verify that it is forbidden to create file/dir/dir");
        Path grandparent = this.methodPath();
        Path parent = new Path(grandparent, "parent");
        Path child = new Path(parent, "child");
        this.expectMkdirsUnderFileFails("mkdirs() file/dir", grandparent, child);
        try {
            this.mkdirs(child);
        }
        catch (FileAlreadyExistsException | ParentNotDirectoryException ex) {
            this.handleExpectedException((Exception)ex);
        }
        catch (IOException e) {
            this.handleRelaxedException("creating a file under a subdirectory of a file ", "FileAlreadyExistsException", e);
        }
    }

    protected void expectCreateUnderFileFails(String action, Path file, Path descendant) throws Exception {
        this.createFile(file);
        try {
            this.createFile(descendant);
        }
        catch (FileAlreadyExistsException | ParentNotDirectoryException ex) {
            this.handleExpectedException((Exception)ex);
        }
        catch (IOException e) {
            this.handleRelaxedException(action, "ParentNotDirectoryException", e);
        }
    }

    protected void expectMkdirsUnderFileFails(String action, Path file, Path descendant) throws Exception {
        this.createFile(file);
        try {
            this.mkdirs(descendant);
        }
        catch (FileAlreadyExistsException | ParentNotDirectoryException ex) {
            this.handleExpectedException((Exception)ex);
        }
        catch (IOException e) {
            this.handleRelaxedException(action, "ParentNotDirectoryException", e);
        }
    }

    private void createFile(Path path) throws IOException {
        byte[] data = ContractTestUtils.dataset(256, 97, 122);
        FileSystem fs = this.getFileSystem();
        ContractTestUtils.writeDataset(fs, path, data, data.length, 0x100000, true);
    }

    @Test
    public void testSyncable() throws Throwable {
        this.describe("test declared and actual Syncable behaviors");
        FileSystem fs = this.getFileSystem();
        boolean supportsFlush = this.isSupported("supports-hflush");
        boolean supportsSync = this.isSupported("supports-hsync");
        boolean metadataUpdatedOnHSync = this.isSupported("metadata_updated_on_hsync");
        this.validateSyncableSemantics(fs, supportsSync, supportsFlush, metadataUpdatedOnHSync);
    }

    protected void validateSyncableSemantics(FileSystem fs, boolean supportsSync, boolean supportsFlush, boolean metadataUpdatedOnHSync) throws IOException {
        Path path = this.methodPath();
        LOG.info("Expecting files under {} to have supportsSync={} and supportsFlush={}; metadataUpdatedOnHSync={}", new Object[]{path, supportsSync, supportsFlush, metadataUpdatedOnHSync});
        try (FSDataOutputStream out = fs.create(path, true);){
            block54: {
                block53: {
                    LOG.info("Created output stream {}", (Object)out);
                    String[] hflushCapabilities = new String[]{"hflush"};
                    String[] hsyncCapabilities = new String[]{"hsync"};
                    if (supportsFlush) {
                        ContractTestUtils.assertCapabilities(out, hflushCapabilities, null);
                    } else {
                        ContractTestUtils.assertCapabilities(out, null, hflushCapabilities);
                    }
                    if (supportsSync) {
                        ContractTestUtils.assertCapabilities(out, hsyncCapabilities, null);
                    } else {
                        ContractTestUtils.assertCapabilities(out, null, hsyncCapabilities);
                    }
                    out.write(97);
                    try {
                        out.hflush();
                        if (!supportsFlush) {
                            LOG.warn("FS doesn't support Syncable.hflush(), but doesn't reject it either.");
                        }
                    }
                    catch (UnsupportedOperationException e) {
                        if (!supportsFlush) break block53;
                        throw new AssertionError("hflush not supported", e);
                    }
                }
                out.write(98);
                try {
                    out.hsync();
                }
                catch (UnsupportedOperationException e) {
                    if (!supportsSync) break block54;
                    throw new AssertionError("HSync not supported", e);
                }
            }
            if (supportsSync) {
                FileStatus st = fs.getFileStatus(path);
                if (metadataUpdatedOnHSync) {
                    AbstractContractCreateTest.assertEquals((long)2L, (long)st.getLen(), (String)("Metadata not updated during write " + st));
                }
                try (FSDataInputStream in = fs.open(path);){
                    AbstractContractCreateTest.assertEquals((int)97, (int)in.read());
                    AbstractContractCreateTest.assertEquals((int)98, (int)in.read());
                    AbstractContractCreateTest.assertEquals((int)-1, (int)in.read());
                    LOG.info("Successfully read synced data on a new reader {}", (Object)in);
                }
            }
            out.flush();
            try (FSDataInputStream in = fs.open(path);){
                int c = in.read();
                if (c == -1) {
                    LOG.info("sync and flush are declared unsupported -flushed changes were not saved");
                } else {
                    LOG.info("sync and flush are declared unsupported - but the stream does offer some sync/flush semantics");
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                if (!this.isSupported("is-blobstore") && !this.isSupported("create-visibility-delayed")) {
                    throw e;
                }
                LOG.warn("Output file was not created; this is an object store or a file system with different visibility semantics");
            }
            out.close();
            String stats = IOStatisticsLogging.ioStatisticsSourceToString((Object)out);
            if (!stats.isEmpty()) {
                LOG.info("IOStatistics {}", (Object)stats);
            }
        }
    }
}

